/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.internal.wls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import weblogic.cluster.migration.MigratableActivatingException;
import weblogic.cluster.migration.MigratableInactiveException;
import weblogic.common.internal.VersionInfoFactory;
import weblogic.corba.rmic.IDLMangler;
import weblogic.ejb.EJBObjectEnum;
import weblogic.iiop.HostIDImpl;
import weblogic.iiop.InboundRequest;
import weblogic.iiop.OutboundResponse;
import weblogic.iiop.VendorInfoCluster;
import weblogic.jndi.Environment;
import weblogic.jndi.internal.AdminModeAccessException;
import weblogic.jndi.internal.ThreadEnvironment;
import weblogic.kernel.Kernel;
import weblogic.kernel.KernelStatus;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JTAMBean;
import weblogic.management.provider.ManagementService;
import weblogic.rmi.cluster.ClusterableServerRef;
import weblogic.rmi.cluster.ReplicaList;
import weblogic.rmi.extensions.server.CBVInputStream;
import weblogic.rmi.extensions.server.CBVOutputStream;
import weblogic.rmi.extensions.server.InvokableServerReference;
import weblogic.rmi.extensions.server.RuntimeMethodDescriptor;
import weblogic.rmi.internal.BasicServerRef;
import weblogic.rmi.internal.CBVInput;
import weblogic.rmi.internal.CBVOutput;
import weblogic.rmi.internal.ClusterAwareServerReference;
import weblogic.rmi.internal.NonTxRMIShutdownService;
import weblogic.rmi.internal.RMIEntityResolver;
import weblogic.rmi.internal.RMIEnvironment;
import weblogic.rmi.internal.RMIShutdownService;
import weblogic.rmi.internal.wls.WLSCBVInput;
import weblogic.rmi.internal.wls.WLSCBVOutput;
import weblogic.rmi.internal.wls.WLSExecuteRequest;
import weblogic.rmi.spi.HostID;
import weblogic.rmi.spi.InvokeHandler;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.work.Work;
import weblogic.xml.jaxp.WebLogicSAXParserFactory;

public final class WLSRMIEnvironment
extends RMIEnvironment {
    private static final String WLS_STUB_VERSION = "_" + VersionInfoFactory.getPeerInfo().getMajor() + VersionInfoFactory.getPeerInfo().getMinor() + VersionInfoFactory.getPeerInfo().getServicePack() + "_WLStub";
    private final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private ClusterMBean clusterMBean;

    public boolean isTracingEnabled() {
        return Kernel.isTracingEnabled();
    }

    public long getTimedOutRefIsolationTime() {
        return Kernel.getConfig().getTimedOutRefIsolationTime();
    }

    public String getIIOPSystemSecurity() {
        return Kernel.getConfig().getIIOP().getSystemSecurity();
    }

    public boolean isLogRemoteExceptions() {
        return Kernel.getConfig().isLogRemoteExceptionsEnabled();
    }

    public int getHeartbeatPeriodLength() {
        return Kernel.getConfig().getPeriodLength();
    }

    public boolean isRefreshClientRuntimeDescriptor() {
        return Kernel.getConfig().getRefreshClientRuntimeDescriptor();
    }

    public int getDGCIdlePeriodsUntilTimeout() {
        return Kernel.getConfig().getDGCIdlePeriodsUntilTimeout();
    }

    public boolean isInstrumentStackTrace() {
        return Kernel.getConfig().isInstrumentStackTraceEnabled();
    }

    public int getTransactionTimeoutMillis() {
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(this.kernelId).getDomain();
        JTAMBean jTAMBean = domainMBean.getJTA();
        return jTAMBean.getTimeoutSeconds() * 1000;
    }

    public boolean isNetworkClassLoadingEnabled() {
        return !KernelStatus.isServer() || ManagementService.getRuntimeAccess(this.kernelId).getServer().isNetworkClassLoadingEnabled();
    }

    public String getStubVersion() {
        return WLS_STUB_VERSION;
    }

    public CBVInput getCBVInput(CBVInputStream cBVInputStream, InputStream inputStream) throws IOException {
        return new WLSCBVInput(cBVInputStream, inputStream);
    }

    public CBVOutput getCBVOutput(CBVOutputStream cBVOutputStream, OutputStream outputStream) throws IOException {
        return new WLSCBVOutput(cBVOutputStream, outputStream);
    }

    public Parser getSAXParser() throws SAXException, ParserConfigurationException {
        WebLogicSAXParserFactory webLogicSAXParserFactory = new WebLogicSAXParserFactory();
        webLogicSAXParserFactory.setValidating(false);
        webLogicSAXParserFactory.setDisabledEntityResolutionRegistry(true);
        SAXParser sAXParser = webLogicSAXParserFactory.newSAXParser();
        Parser parser2 = sAXParser.getParser();
        parser2.setEntityResolver(new RMIEntityResolver());
        return parser2;
    }

    public Work createExecuteRequest(BasicServerRef basicServerRef, weblogic.rmi.spi.InboundRequest inboundRequest, RuntimeMethodDescriptor runtimeMethodDescriptor, InvokeHandler invokeHandler, AuthenticatedSubject authenticatedSubject) {
        return new WLSExecuteRequest(basicServerRef, inboundRequest, runtimeMethodDescriptor, invokeHandler, authenticatedSubject);
    }

    public ClusterAwareServerReference createClusteredServerRef(InvokableServerReference invokableServerReference) {
        return new ClusterableServerRef(invokableServerReference);
    }

    public String getIIOPMangledName(Method method, Class clazz) {
        return IDLMangler.getMangledMethodName(method, clazz);
    }

    public boolean isIIOPResponse(Object object) {
        return object instanceof OutboundResponse;
    }

    public Object replaceSpecialCBVObject(Object object) {
        if (object instanceof EJBObjectEnum) {
            return ((EJBObjectEnum)object).clone();
        }
        return null;
    }

    public boolean isIIOPHostID(HostID hostID) {
        return hostID instanceof HostIDImpl;
    }

    public Context getContext(Object object) throws NamingException {
        return ((Environment)object).getContext(null);
    }

    public boolean isIIOPVendorInfoCluster(ReplicaList replicaList) {
        return replicaList instanceof VendorInfoCluster;
    }

    public boolean isIIOPInboundRequest(weblogic.rmi.spi.InboundRequest inboundRequest) {
        return inboundRequest instanceof InboundRequest;
    }

    public Object newEnvironment() {
        return new Environment();
    }

    public Object threadEnvironmentGet() {
        return ThreadEnvironment.get();
    }

    public Object threadEnvironmentPop() {
        return ThreadEnvironment.pop();
    }

    public void threadEnvironmentPush(Object object) {
        ThreadEnvironment.push((Environment)object);
    }

    public Hashtable getProperties(Object object) {
        return ((Environment)object).getProperties();
    }

    public boolean isAdminModeAccessException(NamingException namingException) {
        return namingException instanceof AdminModeAccessException;
    }

    public ClassLoader getDescriptorClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public String getClusterDefaultLoadAlgorithm() {
        if (this.clusterMBean == null) {
            this.clusterMBean = ManagementService.getRuntimeAccess(this.kernelId).getServer().getCluster();
        }
        if (this.clusterMBean != null) {
            return this.clusterMBean.getDefaultLoadAlgorithm();
        }
        return null;
    }

    public boolean isServerInCluster() {
        return this.clusterMBean != null;
    }

    public AuthenticatedSubject getCurrentSubjectForWire(AuthenticatedSubject authenticatedSubject) {
        return SecurityServiceManager.getCurrentSubjectForWire((AuthenticatedSubject)authenticatedSubject);
    }

    public boolean rmiShutdownAcceptRequest(int n, AuthenticatedSubject authenticatedSubject) {
        return RMIShutdownService.acceptRequest((int)n, (AuthenticatedSubject)authenticatedSubject);
    }

    public boolean nonTxRmiShutdownAcceptRequest(int n, AuthenticatedSubject authenticatedSubject, Object object) {
        return NonTxRMIShutdownService.acceptRequest((int)n, (AuthenticatedSubject)authenticatedSubject, (Object)object);
    }

    public boolean isMigratableActivatingException(RemoteException remoteException) {
        return remoteException instanceof MigratableActivatingException;
    }

    public boolean isMigratableInactiveException(RemoteException remoteException) {
        return remoteException instanceof MigratableInactiveException;
    }
}

