/*
 * Decompiled with CFR 0.152.
 */
package weblogic.scheduler;

import java.io.IOException;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.transaction.Transaction;
import oracle.sql.BLOB;
import weblogic.cluster.ClusterLogger;
import weblogic.j2ee.descriptor.wl.JDBCDataSourceParamsBean;
import weblogic.management.configuration.JDBCSystemResourceMBean;
import weblogic.scheduler.ApplicationNotFoundException;
import weblogic.scheduler.GenericSQLHelperImpl;
import weblogic.scheduler.InformixSQLHelperImpl;
import weblogic.scheduler.MySQLHelperImpl;
import weblogic.scheduler.ObjectPersistenceHelper;
import weblogic.scheduler.OracleSQLHelperImpl;
import weblogic.scheduler.SQLHelper;
import weblogic.scheduler.Timer;
import weblogic.scheduler.TimerBasis;
import weblogic.scheduler.TimerCreationCallback;
import weblogic.scheduler.TimerException;
import weblogic.scheduler.TimerImpl;
import weblogic.scheduler.TimerListenerExtension;
import weblogic.scheduler.TimerState;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.store.io.jdbc.JDBCHelper;
import weblogic.timers.TimerListener;
import weblogic.transaction.TransactionManager;
import weblogic.transaction.TxHelper;
import weblogic.utils.Debug;
import weblogic.utils.StackTraceUtils;

public final class DBTimerBasisImpl
implements TimerBasis {
    private static final boolean DEBUG = Debug.getCategory((String)"weblogic.JobScheduler").isEnabled();
    private DataSource ds;
    private final JDBCSystemResourceMBean jdbcResource;
    private final SQLHelper sqlHelper;
    private final String serverName;
    long previousIdTime = -1L;
    int idSuffix = 0;
    private Connection connection;

    DBTimerBasisImpl(JDBCSystemResourceMBean jDBCSystemResourceMBean, String string, String string2, String string3, String string4) throws SQLException {
        this.jdbcResource = jDBCSystemResourceMBean;
        this.serverName = string4;
        DatabaseMetaData databaseMetaData = this.getJDBCConnection().getMetaData();
        int n = JDBCHelper.getDBMSType((DatabaseMetaData)databaseMetaData, null);
        this.sqlHelper = n == 1 ? new OracleSQLHelperImpl(string, string2, string3) : (n == 9 ? new MySQLHelperImpl(string, string2, string3) : (n == 5 ? new InformixSQLHelperImpl(string, string2, string3) : new GenericSQLHelperImpl(string, string2, string3)));
    }

    public String createTimer(String string, TimerListener timerListener, long l, long l2, AuthenticatedSubject authenticatedSubject) throws TimerException {
        String string2;
        block8: {
            Transaction transaction = null;
            TransactionManager transactionManager = null;
            if (!(timerListener instanceof TimerListenerExtension)) {
                transactionManager = TxHelper.getTransactionManager();
                transaction = transactionManager.forceSuspend();
            }
            try {
                String string3 = this.getUniqueId(timerListener);
                if (DEBUG) {
                    DBTimerBasisImpl.debug("generated id " + string3 + " for listener " + timerListener);
                }
                long l3 = System.currentTimeMillis() + l;
                String string4 = this.sqlHelper.getCreateTimerSQL(string3, string, l3, l2);
                if (DEBUG) {
                    DBTimerBasisImpl.debug("executing sql: " + string4);
                }
                this.runCreate(string3, (Serializable)timerListener, string4);
                ClusterLogger.logCreatedJob((String)string3, (String)timerListener.toString());
                string2 = string3;
                Object var16_13 = null;
                if (transaction == null) break block8;
            }
            catch (SQLException sQLException) {
                try {
                    if (DEBUG) {
                        sQLException.printStackTrace();
                    }
                    throw new TimerException("Unable to create timer", sQLException);
                }
                catch (Throwable throwable) {
                    block9: {
                        Object var16_14 = null;
                        if (transaction == null) break block9;
                        transactionManager.forceResume(transaction);
                    }
                    throw throwable;
                }
            }
            transactionManager.forceResume(transaction);
        }
        return string2;
    }

    public boolean cancelTimer(String string) throws TimerException {
        try {
            int n = this.runUpdate(this.sqlHelper.getCancelTimerSQL(string));
            if (n > 0) {
                ClusterLogger.logCancelledJob((String)string);
                return true;
            }
            return false;
        }
        catch (SQLException sQLException) {
            if (DEBUG) {
                sQLException.printStackTrace();
            }
            throw new TimerException("unable to cancel timer", sQLException);
        }
    }

    public synchronized void advanceIntervalTimer(String string, TimerListener timerListener) throws TimerException {
        TransactionManager transactionManager = TxHelper.getTransactionManager();
        Transaction transaction = transactionManager.forceSuspend();
        try {
            try {
                this.writeListener(string, (Serializable)timerListener, this.sqlHelper.getAdvanceTimerSQL(string));
            }
            catch (SQLException sQLException) {
                if (DEBUG) {
                    sQLException.printStackTrace();
                }
                throw new TimerException("unable to timeout in database", sQLException);
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            transactionManager.forceResume(transaction);
            throw throwable;
        }
        transactionManager.forceResume(transaction);
    }

    public synchronized TimerState getTimerState(String string) throws TimerException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection;
        block12: {
            connection = null;
            preparedStatement = null;
            resultSet = null;
            connection = this.getJDBCConnection();
            String string2 = this.sqlHelper.getTimerStateSQL(string);
            preparedStatement = connection.prepareStatement(string2);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) break block12;
            TimerState timerState = new TimerState(resultSet.getString(1), (TimerListener)ObjectPersistenceHelper.getObject(connection, resultSet, 2), resultSet.getLong(3), resultSet.getLong(4), null);
            Object var8_12 = null;
            this.closeResultSet(resultSet);
            this.closePreparedStatement(preparedStatement);
            this.closeSQLConnection(connection);
            return timerState;
        }
        try {
            try {
                throw new TimerException("unable to get timerstate");
            }
            catch (SQLException sQLException) {
                if (DEBUG) {
                    ClusterLogger.logInvalidTimerState((String)string, (Throwable)sQLException);
                }
                throw new TimerException("unable to get timer", sQLException);
            }
            catch (ApplicationNotFoundException applicationNotFoundException) {
                if (DEBUG) {
                    ClusterLogger.logInvalidTimerState((String)string, (Throwable)applicationNotFoundException);
                }
                throw new TimerException("unable to read TimerListener", applicationNotFoundException);
            }
            catch (IOException iOException) {
                if (DEBUG) {
                    ClusterLogger.logInvalidTimerState((String)string, (Throwable)iOException);
                }
                throw new TimerException("unable to read TimerListener", iOException);
            }
            catch (RuntimeException runtimeException) {
                ClusterLogger.logInvalidTimerState((String)string, (Throwable)runtimeException);
                throw runtimeException;
            }
            catch (Error error) {
                ClusterLogger.logInvalidTimerState((String)string, (Throwable)error);
                throw error;
            }
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            this.closeResultSet(resultSet);
            this.closePreparedStatement(preparedStatement);
            this.closeSQLConnection(connection);
            throw throwable;
        }
    }

    public synchronized List getReadyTimers(int n) throws TimerException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = this.sqlHelper.getReadyTimersSQL(n);
        try {
            connection = this.getJDBCConnection();
            preparedStatement = connection.prepareStatement(string);
            resultSet = preparedStatement.executeQuery();
            ArrayList<String> arrayList = new ArrayList<String>();
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1));
            }
            ArrayList<String> arrayList2 = arrayList;
            Object var9_9 = null;
            this.closeResultSet(resultSet);
            this.closePreparedStatement(preparedStatement);
            this.closeSQLConnection(connection);
            return arrayList2;
        }
        catch (SQLException sQLException) {
            try {
                if (DEBUG) {
                    sQLException.printStackTrace();
                }
                throw new TimerException("SQLException while getting timers", sQLException);
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                this.closeResultSet(resultSet);
                this.closePreparedStatement(preparedStatement);
                this.closeSQLConnection(connection);
                throw throwable;
            }
        }
    }

    private Timer[] getTimersHelper(String string) throws TimerException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getJDBCConnection();
            preparedStatement = connection.prepareStatement(string);
            resultSet = preparedStatement.executeQuery();
            ArrayList<TimerImpl> arrayList = new ArrayList<TimerImpl>();
            while (resultSet.next()) {
                arrayList.add(new TimerImpl(resultSet.getString(1)));
            }
            Timer[] timerArray = new Timer[arrayList.size()];
            arrayList.toArray(timerArray);
            Timer[] timerArray2 = timerArray;
            Object var9_9 = null;
            this.closeResultSet(resultSet);
            this.closePreparedStatement(preparedStatement);
            this.closeSQLConnection(connection);
            return timerArray2;
        }
        catch (SQLException sQLException) {
            try {
                if (DEBUG) {
                    sQLException.printStackTrace();
                }
                throw new TimerException("SQLException while getting timers", sQLException);
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                this.closeResultSet(resultSet);
                this.closePreparedStatement(preparedStatement);
                this.closeSQLConnection(connection);
                throw throwable;
            }
        }
    }

    public Timer[] getTimers(String string) throws TimerException {
        return this.getTimersHelper(this.sqlHelper.getTimersSQL(string));
    }

    public Timer[] getTimers(String string, String string2) throws TimerException {
        return this.getTimersHelper(this.sqlHelper.getTimersSQL(string, string2));
    }

    public void cancelTimers(String string) throws TimerException {
        try {
            this.runUpdate(this.sqlHelper.getCancelTimersSQL(string));
        }
        catch (SQLException sQLException) {
            if (DEBUG) {
                sQLException.printStackTrace();
            }
            throw new TimerException(sQLException.toString());
        }
    }

    private synchronized String getUniqueId(TimerListener timerListener) {
        long l = System.currentTimeMillis();
        String string = this.serverName + "_" + l;
        if (l == this.previousIdTime) {
            ++this.idSuffix;
            string = string + "_" + this.idSuffix;
        } else {
            this.previousIdTime = l;
            this.idSuffix = 0;
        }
        if (timerListener instanceof TimerCreationCallback) {
            return ((TimerCreationCallback)timerListener).getTimerId(string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runUpdate(String string) throws SQLException {
        Connection connection = this.getJDBCConnection();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(string);
            int n = preparedStatement.executeUpdate();
            Object var6_5 = null;
            this.closePreparedStatement(preparedStatement);
            this.closeSQLConnection(connection);
            return n;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.closePreparedStatement(preparedStatement);
            this.closeSQLConnection(connection);
            throw throwable;
        }
    }

    private void runCreate(String string, Serializable serializable, String string2) throws SQLException {
        this.writeListener(string, serializable, string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeListener(String string, Serializable serializable, String string2) throws SQLException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection;
        block12: {
            connection = this.getJDBCConnection();
            preparedStatement = null;
            resultSet = null;
            boolean bl = connection.getAutoCommit();
            if (bl) {
                connection.setAutoCommit(false);
            }
            try {
                try {
                    preparedStatement = connection.prepareStatement(string2);
                    if (ObjectPersistenceHelper.mustSelectForInsert(connection)) {
                        preparedStatement.setBlob(1, (Blob)BLOB.empty_lob());
                        preparedStatement.executeUpdate();
                        preparedStatement = connection.prepareStatement(((OracleSQLHelperImpl)this.sqlHelper).getSelectForInsertSQL(string));
                        resultSet = preparedStatement.executeQuery();
                        if (!resultSet.next()) {
                            throw new SQLException("unable to insert listener");
                        }
                        Blob blob = resultSet.getBlob(1);
                        ObjectPersistenceHelper.writeToBlob(blob, serializable);
                    } else {
                        ObjectPersistenceHelper objectPersistenceHelper = new ObjectPersistenceHelper(serializable);
                        preparedStatement.setBinaryStream(1, objectPersistenceHelper.getBinaryStream(), (int)objectPersistenceHelper.length());
                        preparedStatement.executeUpdate();
                    }
                    if (bl) {
                        connection.commit();
                    }
                }
                catch (IOException iOException) {
                    if (DEBUG) {
                        iOException.printStackTrace();
                    }
                    if (!bl) throw new SQLException("unable to convert Object to Blob. Reason: " + iOException.getMessage());
                    connection.rollback();
                    throw new SQLException("unable to convert Object to Blob. Reason: " + iOException.getMessage());
                }
                Object var10_11 = null;
                if (!bl) break block12;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (bl) {
                    connection.setAutoCommit(bl);
                }
                this.closeResultSet(resultSet);
                this.closePreparedStatement(preparedStatement);
                this.closeSQLConnection(connection);
                throw throwable;
            }
            connection.setAutoCommit(bl);
        }
        this.closeResultSet(resultSet);
        this.closePreparedStatement(preparedStatement);
        this.closeSQLConnection(connection);
    }

    private void closePreparedStatement(PreparedStatement preparedStatement) {
        block3: {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {
                    if (!DEBUG) break block3;
                    sQLException.printStackTrace();
                }
            }
        }
    }

    private void closeSQLConnection(Connection connection) {
        block4: {
            if (this.connection != null) {
                return;
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    if (!DEBUG) break block4;
                    sQLException.printStackTrace();
                }
            }
        }
    }

    private void closeResultSet(ResultSet resultSet) {
        block3: {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    if (!DEBUG) break block3;
                    sQLException.printStackTrace();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Connection getJDBCConnection() throws SQLException {
        Connection connection;
        if (this.connection != null) {
            return this.connection;
        }
        if (this.ds != null) {
            return this.ds.getConnection();
        }
        JDBCDataSourceParamsBean jDBCDataSourceParamsBean = this.jdbcResource.getJDBCResource().getJDBCDataSourceParams();
        String[] stringArray = jDBCDataSourceParamsBean.getJNDINames();
        InitialContext initialContext = null;
        try {
            try {
                if (stringArray == null) throw new SQLException("Job Scheduler data source is invalid !");
                if (stringArray.length == 0) {
                    throw new SQLException("Job Scheduler data source is invalid !");
                }
                initialContext = new InitialContext();
                this.ds = (DataSource)initialContext.lookup(stringArray[0]);
                connection = this.ds.getConnection();
                Object var6_6 = null;
                if (initialContext == null) return connection;
            }
            catch (NamingException namingException) {
                throw new SQLException("Got a NamingException while looking up JobScheduler datasource\n" + StackTraceUtils.throwable2StackTrace((Throwable)namingException));
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (initialContext == null) throw throwable;
            try {
                initialContext.close();
                throw throwable;
            }
            catch (NamingException namingException2) {
                throw throwable;
            }
        }
        try {}
        catch (NamingException namingException) {
            // empty catch block
            return connection;
        }
        initialContext.close();
        return connection;
    }

    private static void debug(String string) {
        ClusterLogger.logDebug((String)("[DBTimerBasisImpl] " + string));
    }

    public static TimerBasis getDBTimerBasis(Connection connection, String string, String string2, String string3, String string4) throws SQLException {
        return new DBTimerBasisImpl(connection, string, string2, string3, string4);
    }

    private DBTimerBasisImpl(Connection connection, String string, String string2, String string3, String string4) throws SQLException {
        this.connection = connection;
        this.jdbcResource = null;
        this.serverName = string4;
        this.sqlHelper = JDBCHelper.getDBMSType((DatabaseMetaData)connection.getMetaData(), null) == 1 ? new OracleSQLHelperImpl(string, string2, string3) : new GenericSQLHelperImpl(string, string2, string3);
    }
}

