/*
 * Decompiled with CFR 0.152.
 */
package weblogic.scheduler;

import java.io.Serializable;
import weblogic.management.ManagementException;
import weblogic.management.runtime.JobRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.scheduler.NoSuchObjectLocalException;
import weblogic.scheduler.TimerBasisAccess;
import weblogic.scheduler.TimerException;
import weblogic.scheduler.TimerImpl;
import weblogic.scheduler.TimerState;

public class JobRuntimeMBeanImpl
extends RuntimeMBeanDelegate
implements JobRuntimeMBean {
    private final String id;
    private final String description;
    private long lastLocalExecutionTime;
    private long localExecutionCount;
    private long period;
    private String state = "Running";

    public JobRuntimeMBeanImpl(RuntimeMBean runtimeMBean, String string, String string2, long l) throws ManagementException {
        super("JobRuntime-" + string, runtimeMBean, true);
        this.id = string;
        this.lastLocalExecutionTime = System.currentTimeMillis();
        this.localExecutionCount = 1L;
        this.period = l;
        this.description = string2;
    }

    public void cancel() {
        if (new TimerImpl(this.id).cancel()) {
            this.state = "Cancelled";
        }
    }

    public Serializable getTimerListener() {
        return (Serializable)new TimerImpl(this.id).getListener();
    }

    public long getPeriod() {
        return this.period;
    }

    public long getTimeout() {
        return new TimerImpl(this.id).getTimeout();
    }

    public long getLastLocalExecutionTime() {
        return this.lastLocalExecutionTime;
    }

    public long getLocalExecutionCount() {
        return this.localExecutionCount;
    }

    public void update() {
        this.lastLocalExecutionTime = System.currentTimeMillis();
        ++this.localExecutionCount;
    }

    public String getDescription() {
        return this.description;
    }

    public String getID() {
        return this.id;
    }

    public String getState() {
        if (this.state.equals("Cancelled")) {
            return this.state;
        }
        try {
            TimerState timerState = TimerBasisAccess.getTimerBasis().getTimerState(this.id);
        }
        catch (NoSuchObjectLocalException noSuchObjectLocalException) {
            this.state = "Cancelled";
        }
        catch (TimerException timerException) {
            this.state = "Cancelled";
        }
        return this.state;
    }
}

