/*
 * Decompiled with CFR 0.152.
 */
package weblogic.scheduler;

import java.security.AccessController;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.cluster.ClusterLogger;
import weblogic.jndi.Environment;
import weblogic.management.configuration.JDBCSystemResourceMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.scheduler.TimerServiceImpl;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;
import weblogic.timers.TimerManagerFactory;
import weblogic.utils.Debug;

public final class JobSchedulerBindingService
extends AbstractServerService {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final String JNDI_NAME = "weblogic.JobScheduler";
    private static final boolean DEBUG = Debug.getCategory((String)"weblogic.JobScheduler").isEnabled();

    public void start() throws ServiceFailureException {
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        ServerMBean serverMBean = runtimeAccess.getServer();
        if (serverMBean.getCluster() == null) {
            return;
        }
        try {
            JDBCSystemResourceMBean jDBCSystemResourceMBean = serverMBean.getCluster().getDataSourceForJobScheduler();
            if (DEBUG) {
                JobSchedulerBindingService.debug("datasource for job scheduler " + jDBCSystemResourceMBean);
            }
            if (jDBCSystemResourceMBean == null) {
                return;
            }
            this.bindJNDI();
        }
        catch (NamingException namingException) {
            throw new ServiceFailureException((Throwable)namingException);
        }
    }

    private void bindJNDI() throws NamingException {
        Environment environment = new Environment();
        environment.setReplicateBindings(false);
        environment.setCreateIntermediateContexts(true);
        Context context = environment.getInitialContext();
        context.bind(JNDI_NAME, (Object)TimerManagerFactory.getTimerManagerFactory().getCommonjTimerManager(TimerServiceImpl.create(JNDI_NAME)));
        if (DEBUG) {
            JobSchedulerBindingService.debug("bound JobScheduler into JNDI");
        }
    }

    private static void debug(String string) {
        ClusterLogger.logDebug((String)("[JobScheduler] " + string));
    }
}

