/*
 * Decompiled with CFR 0.152.
 */
package weblogic.scheduler;

import java.util.LinkedHashMap;
import java.util.Map;
import weblogic.management.ManagementException;
import weblogic.management.runtime.JobRuntimeMBean;
import weblogic.management.runtime.JobSchedulerRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.scheduler.JobRuntimeMBeanImpl;

public class JobSchedulerRuntimeMBeanImpl
extends RuntimeMBeanDelegate
implements JobSchedulerRuntimeMBean {
    private static final boolean DEBUG = false;
    private static JobSchedulerRuntimeMBeanImpl THE_ONE;
    private LinkedHashMap jobMap = new JobHashMap();

    JobSchedulerRuntimeMBeanImpl(RuntimeMBean runtimeMBean) throws ManagementException {
        super("JobSchedulerRuntime", runtimeMBean, true);
        THE_ONE = this;
    }

    public static JobSchedulerRuntimeMBeanImpl getInstance() {
        return THE_ONE;
    }

    public synchronized JobRuntimeMBean getJob(String string) {
        JobRuntimeMBeanImpl jobRuntimeMBeanImpl = (JobRuntimeMBeanImpl)this.jobMap.get(string);
        if (jobRuntimeMBeanImpl != null) {
            return jobRuntimeMBeanImpl;
        }
        try {
            JobRuntimeMBeanImpl jobRuntimeMBeanImpl2 = new JobRuntimeMBeanImpl(this, string, null, -1L);
            this.jobMap.put(string, jobRuntimeMBeanImpl2);
            return jobRuntimeMBeanImpl2;
        }
        catch (ManagementException managementException) {
            return null;
        }
    }

    public synchronized JobRuntimeMBean[] getExecutedJobs() {
        JobRuntimeMBean[] jobRuntimeMBeanArray = new JobRuntimeMBean[this.jobMap.size()];
        this.jobMap.values().toArray(jobRuntimeMBeanArray);
        return jobRuntimeMBeanArray;
    }

    synchronized void timerExecuted(String string, String string2, long l) {
        JobRuntimeMBeanImpl jobRuntimeMBeanImpl = (JobRuntimeMBeanImpl)this.jobMap.get(string);
        if (jobRuntimeMBeanImpl != null) {
            jobRuntimeMBeanImpl.update();
        } else {
            try {
                this.jobMap.put(string, new JobRuntimeMBeanImpl(this, string, string2, l));
            }
            catch (ManagementException managementException) {
                // empty catch block
            }
        }
    }

    private static final class JobHashMap
    extends LinkedHashMap {
        private static final int JOB_MBEAN_SIZE = JobHashMap.initProperty("weblogic.scheduler.JobRuntimeMBeanPoolSize", 50);

        JobHashMap() {
            super((JOB_MBEAN_SIZE + 1) / 2, 2.0f, true);
        }

        private static int initProperty(String string, int n) {
            try {
                return Integer.getInteger(string, n);
            }
            catch (SecurityException securityException) {
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                return n;
            }
        }

        protected boolean removeEldestEntry(Map.Entry entry) {
            if (JOB_MBEAN_SIZE > 0 && this.size() > JOB_MBEAN_SIZE) {
                JobRuntimeMBeanImpl jobRuntimeMBeanImpl = (JobRuntimeMBeanImpl)entry.getValue();
                try {
                    jobRuntimeMBeanImpl.unregister();
                }
                catch (ManagementException managementException) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }

        private static void p(String string) {
            System.out.println("[JobRuntimeMBean] " + string);
        }
    }
}

