/*
 * Decompiled with CFR 0.152.
 */
package weblogic.scheduler;

import java.security.AccessController;
import weblogic.cluster.ClusterLogger;
import weblogic.management.ManagementException;
import weblogic.management.configuration.JDBCSystemResourceMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.management.runtime.ClusterRuntimeMBean;
import weblogic.scheduler.JobSchedulerRuntimeMBeanImpl;
import weblogic.scheduler.TimerExecutor;
import weblogic.scheduler.TimerMaster;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;
import weblogic.utils.Debug;

public final class JobSchedulerService
extends AbstractServerService {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final boolean DEBUG = Debug.getCategory((String)"weblogic.JobScheduler").isEnabled();
    private static boolean initialized;

    public void start() throws ServiceFailureException {
        try {
            if (!JobSchedulerService.markInitialized()) {
                return;
            }
            RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
            ServerMBean serverMBean = runtimeAccess.getServer();
            if (serverMBean.getCluster() == null) {
                return;
            }
            JDBCSystemResourceMBean jDBCSystemResourceMBean = serverMBean.getCluster().getDataSourceForJobScheduler();
            if (jDBCSystemResourceMBean == null) {
                return;
            }
            JobSchedulerService.registerJobSchedulerRuntime();
            TimerMaster.initialize();
            TimerExecutor.initialize();
        }
        catch (ManagementException managementException) {
            throw new ServiceFailureException("JobScheduler failed to start!", (Throwable)managementException);
        }
    }

    private static synchronized boolean markInitialized() {
        if (initialized) {
            return false;
        }
        initialized = true;
        return true;
    }

    private static synchronized void registerJobSchedulerRuntime() throws ManagementException {
        ClusterRuntimeMBean clusterRuntimeMBean = ManagementService.getRuntimeAccess(kernelId).getServerRuntime().getClusterRuntime();
        new JobSchedulerRuntimeMBeanImpl(clusterRuntimeMBean);
    }

    private static void debug(String string) {
        ClusterLogger.logDebug((String)("[JobScheduler] " + string));
    }
}

