/*
 * Decompiled with CFR 0.152.
 */
package weblogic.scheduler;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import weblogic.jdbc.vendor.oracle.OracleThinBlob;
import weblogic.store.io.jdbc.JDBCHelper;

final class ObjectPersistenceHelper
implements Blob,
Serializable {
    private byte[] data;
    private static final int DEFAULT_BUF_SIZE = 1000;

    ObjectPersistenceHelper() {
        this.data = new byte[0];
    }

    ObjectPersistenceHelper(Serializable serializable) throws IOException {
        this.data = ObjectPersistenceHelper.getBytes(serializable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] getBytes(Serializable serializable) throws IOException {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream;
        block4: {
            byteArrayOutputStream = null;
            ObjectOutputStream objectOutputStream = null;
            try {
                byteArrayOutputStream = new ByteArrayOutputStream(1000);
                objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(serializable);
                objectOutputStream.flush();
                byArray = byteArrayOutputStream.toByteArray();
                Object var5_4 = null;
                if (objectOutputStream == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var5_5 = null;
                    if (objectOutputStream != null) {
                        objectOutputStream.close();
                    }
                    if (byteArrayOutputStream == null) break block5;
                    byteArrayOutputStream.close();
                }
                throw throwable;
            }
            objectOutputStream.close();
        }
        if (byteArrayOutputStream != null) {
            byteArrayOutputStream.close();
        }
        return byArray;
    }

    static Blob getBlob(Serializable serializable) throws IOException {
        return new ObjectPersistenceHelper(serializable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeToBlob(Blob blob, Serializable serializable) throws SQLException, IOException {
        OutputStream outputStream = null;
        try {
            outputStream = blob instanceof OracleThinBlob ? ((OracleThinBlob)blob).getBinaryOutputStream() : blob.setBinaryStream(1L);
            byte[] byArray = ObjectPersistenceHelper.getBytes(serializable);
            outputStream.write(byArray);
            outputStream.flush();
            outputStream.close();
            outputStream = null;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException iOException) {}
    }

    static Object getObject(Blob blob) throws SQLException, IOException {
        assert (blob != null);
        return ObjectPersistenceHelper.getObject(blob.getBytes(1L, (int)blob.length()));
    }

    static Object getObject(byte[] byArray) throws SQLException, IOException {
        Object object;
        ByteArrayInputStream byteArrayInputStream;
        block6: {
            ObjectInputStream objectInputStream = null;
            byteArrayInputStream = null;
            try {
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                objectInputStream = new SchedulerObjectInputStream(byteArrayInputStream);
                object = objectInputStream.readObject();
                Object var5_5 = null;
                if (objectInputStream == null) break block6;
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    throw new IOException(classNotFoundException.getMessage());
                }
                catch (Throwable throwable) {
                    block7: {
                        Object var5_6 = null;
                        if (objectInputStream != null) {
                            objectInputStream.close();
                        }
                        if (byteArrayInputStream == null) break block7;
                        byteArrayInputStream.close();
                    }
                    throw throwable;
                }
            }
            objectInputStream.close();
        }
        if (byteArrayInputStream != null) {
            byteArrayInputStream.close();
        }
        return object;
    }

    public long length() {
        return this.data.length;
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        if (l < 0L || l > (long)this.data.length) {
            throw new SQLException("Position: " + l + " must be >=0 and less than Blob.length()");
        }
        if (n < 0) {
            throw new SQLException("length must be positive");
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.data, (int)l, byArray, 0, n);
        return byArray;
    }

    public InputStream getBinaryStream() {
        return new ByteArrayInputStream(this.data);
    }

    public long position(byte[] byArray, long l) throws SQLException {
        if (l < 0L || l >= (long)this.data.length) {
            throw new SQLException("start must be >= 0 and < Blob.length()");
        }
        for (int i = (int)l; i < this.data.length; ++i) {
            boolean bl = true;
            for (int j = 0; j < byArray.length; ++j) {
                if (this.data[i + j] == byArray[j]) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return i + 1;
        }
        return -1L;
    }

    public long position(Blob blob, long l) throws SQLException {
        if (blob.length() > Integer.MAX_VALUE) {
            throw new SQLException("RowSets cannot read BLOBs greater than 2147483647 bytes.");
        }
        return this.position(blob.getBytes(0L, (int)blob.length()), l);
    }

    public int setBytes(long l, byte[] byArray) {
        return this.setBytes(l, byArray, 0, byArray.length);
    }

    public int setBytes(long l, byte[] byArray, int n, int n2) {
        this.ensureLength(l + (long)n2);
        System.arraycopy(byArray, n, this.data, (int)l, n2);
        return n2;
    }

    public OutputStream setBinaryStream(final long l) {
        return new OutputStream(){
            int pos;
            {
                this.pos = (int)l - 1;
            }

            public void write(int n) {
                ObjectPersistenceHelper.this.ensureLength(this.pos + 1);
                ((ObjectPersistenceHelper)ObjectPersistenceHelper.this).data[this.pos++] = (byte)n;
            }

            public void write(byte[] byArray, int n, int n2) {
                this.pos += ObjectPersistenceHelper.this.setBytes(this.pos, byArray, n, n2);
            }
        };
    }

    public void free() throws SQLException {
        throw new SQLException("Java SE 6.0 method free is not supported");
    }

    public InputStream getBinaryStream(long l, long l2) throws SQLException {
        throw new SQLException("Java SE 6.0 method getBinaryStream is not supported");
    }

    public void truncate(long l) throws SQLException {
        if (l > (long)this.data.length) {
            throw new SQLException("truncate to length: " + l + " is larger than current size: " + this.data.length);
        }
        this.changeLength(l, (int)l);
    }

    private void ensureLength(long l) {
        if (l > (long)this.data.length) {
            this.changeLength(l, this.data.length);
        }
    }

    private void changeLength(long l, int n) {
        byte[] byArray = this.data;
        this.data = new byte[(int)l];
        System.arraycopy(byArray, 0, this.data, 0, n);
    }

    static boolean isOracleBlobRecord(Connection connection, ResultSet resultSet, int n) throws SQLException {
        return JDBCHelper.isOracleBlobColumn((int)JDBCHelper.getDBMSType((DatabaseMetaData)connection.getMetaData(), null), (ResultSet)resultSet, (int)n);
    }

    static boolean mustSelectForInsert(Connection connection) throws SQLException {
        return JDBCHelper.mustSelectForUpdateToInsertBinary((int)JDBCHelper.getDBMSType((DatabaseMetaData)connection.getMetaData(), null), (DatabaseMetaData)connection.getMetaData());
    }

    static Object getObject(Connection connection, ResultSet resultSet, int n) throws SQLException, IOException {
        if (ObjectPersistenceHelper.isOracleBlobRecord(connection, resultSet, n)) {
            return ObjectPersistenceHelper.getObject(resultSet.getBlob(n));
        }
        return ObjectPersistenceHelper.getObject(resultSet.getBytes(n));
    }

    private static class SchedulerObjectInputStream
    extends ObjectInputStream {
        private SchedulerObjectInputStream(InputStream inputStream) throws IOException {
            super(inputStream);
        }

        protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            return Class.forName(objectStreamClass.getName(), false, classLoader);
        }
    }
}

