/*
 * Decompiled with CFR 0.152.
 */
package weblogic.scheduler;

import java.security.AccessController;
import java.sql.SQLException;
import weblogic.management.configuration.JDBCSystemResourceMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.scheduler.DBTimerBasisImpl;
import weblogic.scheduler.TimerBasis;
import weblogic.scheduler.TimerException;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public final class TimerBasisAccess {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static TimerBasis basis;

    public static synchronized TimerBasis getTimerBasis() throws TimerException {
        if (basis != null) {
            return basis;
        }
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        ServerMBean serverMBean = runtimeAccess.getServer();
        assert (serverMBean.getCluster() != null);
        JDBCSystemResourceMBean jDBCSystemResourceMBean = serverMBean.getCluster().getDataSourceForJobScheduler();
        assert (jDBCSystemResourceMBean != null);
        try {
            basis = new DBTimerBasisImpl(jDBCSystemResourceMBean, serverMBean.getCluster().getJobSchedulerTableName(), runtimeAccess.getDomainName(), serverMBean.getCluster().getName(), runtimeAccess.getServerName());
            return basis;
        }
        catch (SQLException sQLException) {
            throw new TimerException("Unable to access data source '" + jDBCSystemResourceMBean.getName() + "'", sQLException);
        }
    }
}

