/*
 * Decompiled with CFR 0.152.
 */
package weblogic.scheduler;

import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.application.ApplicationAccess;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.utils.TargetUtils;
import weblogic.cluster.ClusterLogger;
import weblogic.cluster.singleton.LeaseManager;
import weblogic.cluster.singleton.LeaseManagerFactory;
import weblogic.cluster.singleton.LeasingException;
import weblogic.jndi.Environment;
import weblogic.protocol.URLManager;
import weblogic.rmi.extensions.PortableRemoteObject;
import weblogic.scheduler.ApplicationNotFoundException;
import weblogic.scheduler.NoSuchObjectLocalException;
import weblogic.scheduler.TimerBasisAccess;
import weblogic.scheduler.TimerException;
import weblogic.scheduler.TimerMasterRemote;
import weblogic.scheduler.TimerState;
import weblogic.timers.NakedTimerListener;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManagerFactory;
import weblogic.utils.Debug;

public class TimerExecutor
implements NakedTimerListener {
    private static final boolean DEBUG = Debug.getCategory((String)"weblogic.JobScheduler").isEnabled();
    private static final String TIMER_MANAGER = "weblogic.scheduler.TimerExecutor";
    private static TimerExecutor THE_ONE;
    private Context jndiContext;
    private Set unavailableTimerApps = new HashSet();

    static synchronized void initialize() {
        Debug.assertion((THE_ONE == null ? 1 : 0) != 0);
        THE_ONE = new TimerExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getUnavailableTimerApplications() {
        HashSet<String> hashSet = new HashSet<String>();
        Set set = this.unavailableTimerApps;
        synchronized (set) {
            Iterator iterator = this.unavailableTimerApps.iterator();
            while (iterator.hasNext()) {
                TimerApplication timerApplication = (TimerApplication)iterator.next();
                if (this.isDeployedLocally(timerApplication.getApplicationName())) {
                    iterator.remove();
                    continue;
                }
                hashSet.add(timerApplication.getTimerId());
            }
        }
        return hashSet;
    }

    private boolean isDeployedLocally(String string) {
        ApplicationContextInternal applicationContextInternal = ApplicationAccess.getApplicationAccess().getApplicationContext(string);
        boolean bl = applicationContextInternal != null && TargetUtils.isDeployedLocally(applicationContextInternal.getBasicDeploymentMBean().getTargets());
        return bl;
    }

    private TimerExecutor() {
        try {
            Environment environment = new Environment();
            environment.setReplicateBindings(false);
            environment.setCreateIntermediateContexts(true);
            this.jndiContext = environment.getInitialContext();
        }
        catch (NamingException namingException) {
            throw new AssertionError((Object)"Failed to create initial context");
        }
        TimerManagerFactory.getTimerManagerFactory().getTimerManager(TIMER_MANAGER, "weblogic.kernel.System").schedule((TimerListener)this, 0L, 30000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timerExpired(Timer timer) {
        List list;
        Object object;
        TimerMasterRemote timerMasterRemote = this.lookupTimerMaster();
        if (timerMasterRemote == null) {
            return;
        }
        if (DEBUG) {
            TimerExecutor.debug(" looked up TimerMasterRemote " + timerMasterRemote);
        }
        try {
            object = this.getUnavailableTimerApplications();
            list = timerMasterRemote.getReadyTimers((Set)object);
            if (DEBUG) {
                TimerExecutor.debug("getReadyTimers from MASTER size=" + list.size());
            }
        }
        catch (TimerException timerException) {
            if (DEBUG) {
                timerException.printStackTrace();
            }
            return;
        }
        catch (RemoteException remoteException) {
            if (DEBUG) {
                remoteException.printStackTrace();
            }
            return;
        }
        object = list.listIterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            try {
                TimerState timerState = TimerBasisAccess.getTimerBasis().getTimerState(string);
                timerState.fireWhenReady();
            }
            catch (TimerException timerException) {
                Throwable throwable = timerException.getCause();
                if (throwable == null || !(throwable instanceof ApplicationNotFoundException)) continue;
                ApplicationNotFoundException applicationNotFoundException = (ApplicationNotFoundException)throwable;
                TimerApplication timerApplication = new TimerApplication(applicationNotFoundException.getMessage(), string);
                Set set = this.unavailableTimerApps;
                synchronized (set) {
                    this.unavailableTimerApps.add(timerApplication);
                }
                if (!DEBUG) continue;
                TimerExecutor.debug("Failed to find " + timerApplication);
            }
            catch (NoSuchObjectLocalException noSuchObjectLocalException) {}
        }
    }

    private static void debug(String string) {
        ClusterLogger.logDebug((String)("[TimerExecutor] " + string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TimerMasterRemote lookupTimerMaster() {
        Context context = null;
        String string = null;
        try {
            LeaseManager leaseManager = LeaseManagerFactory.singleton().getLeaseManager("service");
            String string2 = leaseManager.findOwner("TimerMaster");
            if (string2 == null) {
                if (DEBUG) {
                    TimerExecutor.debug("Could not find the current owner of the service TimerMaster");
                }
                TimerMasterRemote timerMasterRemote = null;
                return timerMasterRemote;
            }
            string = LeaseManager.getServerNameFromOwnerIdentity(string2);
            if (DEBUG) {
                TimerExecutor.debug("The location of TimerMaster is: " + string);
            }
            String string3 = URLManager.findAdministrationURL(string);
            if (DEBUG) {
                TimerExecutor.debug("Contacting " + string + " at " + string3 + " to fetch the " + "TimerMaster");
            }
            if (string3 == null) {
                TimerMasterRemote timerMasterRemote = null;
                return timerMasterRemote;
            }
            Environment environment = new Environment();
            environment.setProviderUrl(string3);
            context = environment.getInitialContext();
            TimerMasterRemote timerMasterRemote = (TimerMasterRemote)PortableRemoteObject.narrow((Object)context.lookup("weblogic.scheduler.TimerMaster"), TimerMasterRemote.class);
            return timerMasterRemote;
        }
        catch (LeasingException leasingException) {
            if (!DEBUG) return null;
            TimerExecutor.debug("Could not find TimerMaster on " + string + ". Exception:" + leasingException.getMessage());
            return null;
        }
        catch (NamingException namingException) {
            if (!DEBUG) return null;
            TimerExecutor.debug("Could not find TimerMaster on " + string + ". Exception:" + namingException.getMessage());
            return null;
        }
        catch (UnknownHostException unknownHostException) {
            if (!DEBUG) return null;
            TimerExecutor.debug("Could not find server " + string);
            return null;
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException namingException) {}
            }
        }
    }

    private class TimerApplication {
        private String applicationName;
        private String timerId;
        private int hashCode;

        public TimerApplication(String string, String string2) {
            this.applicationName = string;
            this.timerId = string2;
            this.hashCode = this.applicationName.hashCode() ^ this.timerId.hashCode();
        }

        public String getApplicationName() {
            return this.applicationName;
        }

        public String getTimerId() {
            return this.timerId;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            TimerApplication timerApplication;
            if (this == object) {
                return true;
            }
            return object instanceof TimerApplication && (timerApplication = (TimerApplication)object).getApplicationName().equals(this.applicationName) && timerApplication.getTimerId().equals(this.timerId);
        }

        public String toString() {
            return "ApplictionName:" + this.applicationName + " TimerId:" + this.timerId;
        }
    }
}

