/*
 * Decompiled with CFR 0.152.
 */
package weblogic.scheduler;

import java.io.Serializable;
import weblogic.scheduler.NoSuchObjectLocalException;
import weblogic.scheduler.Timer;
import weblogic.scheduler.TimerBasisAccess;
import weblogic.scheduler.TimerException;
import weblogic.scheduler.TimerHandle;
import weblogic.scheduler.TimerHandleImpl;
import weblogic.scheduler.TimerState;
import weblogic.timers.TimerListener;

public class TimerImpl
implements Timer {
    private final String id;

    TimerImpl(String string) {
        this.id = string;
    }

    String getID() {
        return this.id;
    }

    public boolean cancel() {
        try {
            return TimerBasisAccess.getTimerBasis().cancelTimer(this.id);
        }
        catch (NoSuchObjectLocalException noSuchObjectLocalException) {
            return false;
        }
        catch (TimerException timerException) {
            return false;
        }
    }

    public boolean isStopped() {
        return this.isCancelled();
    }

    public boolean isCancelled() {
        return this.getTimerState() == null;
    }

    public long getTimeout() {
        TimerState timerState = this.getTimerState();
        if (timerState == null) {
            return -1L;
        }
        return timerState.getTimeout();
    }

    public long getPeriod() {
        TimerState timerState = this.getTimerState();
        if (timerState == null) {
            return -1L;
        }
        return timerState.getInterval();
    }

    public TimerListener getListener() {
        TimerState timerState = this.getTimerState();
        if (timerState == null) {
            return null;
        }
        return this.getTimerState().getTimedObject();
    }

    public Serializable getInfo() throws NoSuchObjectLocalException, TimerException {
        TimerState timerState = TimerBasisAccess.getTimerBasis().getTimerState(this.id);
        return timerState.getInfo();
    }

    public TimerHandle getHandle() throws NoSuchObjectLocalException, TimerException {
        return new TimerHandleImpl(this.id);
    }

    private TimerState getTimerState() {
        try {
            return TimerBasisAccess.getTimerBasis().getTimerState(this.id);
        }
        catch (NoSuchObjectLocalException noSuchObjectLocalException) {
            return null;
        }
        catch (TimerException timerException) {
            return null;
        }
    }

    public int hashCode() {
        int n = 17;
        if (this.id != null) {
            n *= this.id.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TimerImpl)) {
            return false;
        }
        TimerImpl timerImpl = (TimerImpl)object;
        if (this.id == null && timerImpl.id == null) {
            return true;
        }
        return this.id != null && this.id.equals(timerImpl.id);
    }

    public String toString() {
        return this.id;
    }
}

