/*
 * Decompiled with CFR 0.152.
 */
package weblogic.scheduler;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import weblogic.cluster.ClusterLogger;
import weblogic.cluster.ClusterService;
import weblogic.cluster.singleton.LeaseLostListener;
import weblogic.cluster.singleton.LeaseManager;
import weblogic.cluster.singleton.LeaseManagerFactory;
import weblogic.cluster.singleton.LeasingBasis;
import weblogic.cluster.singleton.LeasingException;
import weblogic.cluster.singleton.RemoteLeasingBasisImpl;
import weblogic.cluster.singleton.SimpleLeasingBasis;
import weblogic.cluster.singleton.SingletonService;
import weblogic.cluster.singleton.SingletonServicesManager;
import weblogic.jndi.Environment;
import weblogic.scheduler.TimerBasisAccess;
import weblogic.scheduler.TimerException;
import weblogic.scheduler.TimerMasterRemote;
import weblogic.timers.NakedTimerListener;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManagerFactory;
import weblogic.utils.Debug;

public class TimerMaster
implements TimerMasterRemote,
NakedTimerListener,
SingletonService,
LeaseLostListener {
    private static final boolean DEBUG = Debug.getCategory((String)"weblogic.JobScheduler").isEnabled();
    private static final String TIMER_MANAGER = "weblogic.scheduler.TimerMaster";
    static final String JNDI_NAME = "weblogic.scheduler.TimerMaster";
    static final String LEASE_NAME = "TimerMaster";
    static final String LEASE_TYPE = "timer";
    static final int eventHorizonSeconds = 60;
    static final int pollsPerPeriod = 2;
    private static LeaseManager leaseMgr;
    private List readyTimers;
    private int numServersCalledIn;
    private int status;
    private static final int WAITING_TO_REGISTER = 0;
    private static final long registrationRetryPeriodSeconds = 20L;
    private static final int WAITING_TO_LEASE = 1;
    private static final int IS_MASTER = 2;
    private Context context;
    private Timer timer;
    private static TimerMaster THE_ONE;

    static synchronized void initialize() {
        Debug.assertion((THE_ONE == null ? 1 : 0) != 0);
        THE_ONE = new TimerMaster();
    }

    private TimerMaster() {
        try {
            Environment environment = new Environment();
            environment.setReplicateBindings(false);
            environment.setCreateIntermediateContexts(true);
            this.context = environment.getInitialContext();
            try {
                this.context.bind("weblogic.scheduler.TimerMaster", (Object)this);
            }
            catch (NamingException namingException) {
                namingException.printStackTrace();
                throw new AssertionError((Object)"Unable to bind TimerMaster");
            }
            TimerMaster.getLeaseManager();
        }
        catch (NamingException namingException) {
            throw new AssertionError((Object)"Failed to create initial context");
        }
        this.setupRegistration();
    }

    static synchronized LeaseManager getLeaseManager() throws NamingException {
        if (leaseMgr != null) {
            return leaseMgr;
        }
        if (Boolean.getBoolean("weblogic.UseSimpleLeasingForJobScheduler")) {
            LeasingBasis leasingBasis = null;
            InitialContext initialContext = new InitialContext();
            try {
                leasingBasis = (LeasingBasis)initialContext.lookup("RemoteLeasingBasis");
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            if (leasingBasis == null) {
                leasingBasis = new RemoteLeasingBasisImpl(new SimpleLeasingBasis());
                initialContext.bind("RemoteLeasingBasis", (Object)leasingBasis);
            }
            leaseMgr = new LeaseManager(leasingBasis, 500, 1000, 1000, LEASE_TYPE);
            leaseMgr.start();
        } else {
            leaseMgr = ClusterService.getClusterService().getDefaultLeaseManager(LEASE_TYPE);
        }
        return leaseMgr;
    }

    private void setupRegistration() {
        this.status = 1;
        SingletonServicesManager.getInstance().add(this.getName(), this);
    }

    public synchronized void timerExpired(Timer timer) {
        if (this.status != 2) {
            throw new AssertionError((Object)("TimerMaster executing in " + this.status));
        }
        try {
            String string;
            if (DEBUG) {
                TimerMaster.debug("we are the master of lease. get ready timers");
            }
            List list = TimerBasisAccess.getTimerBasis().getReadyTimers(60);
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                string = (String)listIterator.next();
                if (this.readyTimers.contains(string)) continue;
                this.readyTimers.add(string);
            }
            if (DEBUG) {
                TimerMaster.debug("total number of ready timers = " + this.readyTimers.size());
            }
            listIterator = this.readyTimers.listIterator();
            while (listIterator.hasNext()) {
                string = (String)listIterator.next();
                try {
                    if (leaseMgr.findOwner(string) != null) {
                        if (DEBUG) {
                            TimerMaster.debug("timer already has a owner:" + string);
                        }
                        listIterator.remove();
                        continue;
                    }
                    if (!DEBUG) continue;
                    TimerMaster.debug("timer is ready:" + string);
                }
                catch (LeasingException leasingException) {}
            }
            this.numServersCalledIn = 0;
        }
        catch (TimerException timerException) {
            // empty catch block
        }
    }

    private static void debug(String string) {
        ClusterLogger.logDebug((String)("[TimerMaster] " + string));
    }

    public synchronized void activate() {
        if (this.status != 1) {
            throw new AssertionError((Object)"State machine failure: lease obtained while not WAITING_TO_LEASE");
        }
        this.status = 2;
        if (DEBUG) {
            TimerMaster.debug("Obtained lease NOTIFICATION on " + this.getName());
        }
        this.readyTimers = new ArrayList();
        this.numServersCalledIn = 0;
        this.timer = TimerManagerFactory.getTimerManagerFactory().getTimerManager("weblogic.scheduler.TimerMaster", "weblogic.kernel.System").schedule((TimerListener)this, 0L, 30000L);
        this.registerWithSingletonMonitorLeaseManager();
    }

    public synchronized void deactivate() {
        if (this.status != 2) {
            return;
        }
        this.timer.cancel();
        if (DEBUG) {
            TimerMaster.debug("Lease LOST [TimerMaster] ");
        }
        this.status = 1;
    }

    public synchronized List getReadyTimers(Set set) throws RemoteException, TimerException {
        if (this.status != 2) {
            throw new TimerException("Attempt to get ready timers from server that is not master");
        }
        int n = ClusterService.getClusterService().getRemoteMembers().size() + 1 - this.numServersCalledIn;
        int n2 = 1;
        if (n < 1) {
            n = 1;
        }
        if (n < this.readyTimers.size()) {
            n2 = this.readyTimers.size() / n;
        }
        int n3 = 0;
        ArrayList arrayList = new ArrayList();
        if (DEBUG) {
            TimerMaster.debug("getReadyTimers size=" + this.readyTimers.size() + ", numServersCalledIn=" + this.numServersCalledIn + ", numServerToCall=" + n + ", timers to send=" + n2);
        }
        Iterator iterator = this.readyTimers.iterator();
        while (n3 >= 0 && n3 < n2 && iterator.hasNext()) {
            Object e = iterator.next();
            if (!set.contains(e)) {
                arrayList.add(e);
                iterator.remove();
                if (DEBUG) {
                    TimerMaster.debug("Sending ready timer " + e + " to TimerExecutor");
                }
            } else if (DEBUG) {
                TimerMaster.debug("Skipping to send ready timer " + e + " to TimerExecutor");
            }
            ++n3;
        }
        ++this.numServersCalledIn;
        return arrayList;
    }

    public String getName() {
        return LEASE_NAME;
    }

    private void registerWithSingletonMonitorLeaseManager() {
        LeaseManager leaseManager = LeaseManagerFactory.singleton().getLeaseManager("service");
        leaseManager.addLeaseLostListener(this);
    }

    private void unregisterWithSingletonMonitorLeaseManager() {
        LeaseManager leaseManager = LeaseManagerFactory.singleton().getLeaseManager("service");
        leaseManager.removeLeaseLostListener(this);
    }

    public void onRelease() {
        if (this.status != 2) {
            return;
        }
        if (DEBUG) {
            TimerMaster.debug("TimerMaster Got a callback for LeaseLost.");
        }
        this.deactivate();
        this.unregisterWithSingletonMonitorLeaseManager();
    }
}

