/*
 * Decompiled with CFR 0.152.
 */
package weblogic.scheduler;

import java.security.AccessController;
import java.util.Date;
import weblogic.scheduler.TimerBasis;
import weblogic.scheduler.TimerBasisAccess;
import weblogic.scheduler.TimerException;
import weblogic.scheduler.TimerImpl;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;

public class TimerServiceImpl
implements TimerManager {
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    static final long ILLEGAL_INTERVAL = -1L;
    private TimerBasis basis;
    private String name;

    public static TimerManager create(String string) {
        return new TimerServiceImpl(string);
    }

    private TimerServiceImpl(String string) {
        this.name = string;
    }

    public Timer schedule(TimerListener timerListener, long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Duration is negative");
        }
        try {
            return this.createTimerInternal(timerListener, l, -1L);
        }
        catch (TimerException timerException) {
            throw new IllegalStateException(timerException);
        }
    }

    public Timer schedule(TimerListener timerListener, long l, long l2) {
        if (l < 0L) {
            throw new IllegalArgumentException("Initial duration is negative");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("Interval duration is negative");
        }
        try {
            return this.createTimerInternal(timerListener, l, l2);
        }
        catch (TimerException timerException) {
            throw new IllegalStateException(timerException);
        }
    }

    public Timer schedule(TimerListener timerListener, Date date) throws IllegalArgumentException {
        if (date == null) {
            throw new IllegalArgumentException("Expiration is null");
        }
        return this.schedule(timerListener, date.getTime() - System.currentTimeMillis());
    }

    public Timer schedule(TimerListener timerListener, Date date, long l) throws IllegalArgumentException {
        if (date == null) {
            throw new IllegalArgumentException("Expiration is null");
        }
        return this.schedule(timerListener, date.getTime() - System.currentTimeMillis(), l);
    }

    public Timer scheduleAtFixedRate(TimerListener timerListener, Date date, long l) {
        throw new UnsupportedOperationException("Job scheduler does not support scheduleAtFixedRate(). It only supports schedule()");
    }

    public Timer scheduleAtFixedRate(TimerListener timerListener, long l, long l2) {
        throw new UnsupportedOperationException("Job scheduler does not support scheduleAtFixedRate(). It only supports schedule()");
    }

    public void resume() {
        throw new IllegalStateException("job scheduler is already running!");
    }

    public void suspend() {
        throw new UnsupportedOperationException("job scheduler cannot be suspended!");
    }

    public void stop() {
        throw new UnsupportedOperationException("job scheduler cannot be stopped!");
    }

    public boolean waitForStop(long l) throws InterruptedException {
        throw new UnsupportedOperationException("job scheduler cannot be stopped!");
    }

    public boolean isStopping() {
        return false;
    }

    public boolean isStopped() {
        return false;
    }

    public boolean waitForSuspend(long l) throws InterruptedException {
        throw new UnsupportedOperationException("job scheduler cannot be suspended!");
    }

    public boolean isSuspending() {
        return false;
    }

    public boolean isSuspended() {
        return false;
    }

    private Timer createTimerInternal(TimerListener timerListener, long l, long l2) throws TimerException {
        AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)KERNEL_ID);
        TimerBasis timerBasis = TimerBasisAccess.getTimerBasis();
        String string = timerBasis.createTimer(this.name, timerListener, l, l2, authenticatedSubject);
        return new TimerImpl(string);
    }
}

