/*
 * Decompiled with CFR 0.152.
 */
package weblogic.scheduler;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.naming.NamingException;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import weblogic.cluster.ClusterLogger;
import weblogic.cluster.singleton.LeaseLostListener;
import weblogic.cluster.singleton.LeaseManager;
import weblogic.cluster.singleton.LeasingException;
import weblogic.scheduler.JobSchedulerRuntimeMBeanImpl;
import weblogic.scheduler.NoSuchObjectLocalException;
import weblogic.scheduler.TimerBasisAccess;
import weblogic.scheduler.TimerException;
import weblogic.scheduler.TimerImpl;
import weblogic.scheduler.TimerListenerExtension;
import weblogic.scheduler.TimerMaster;
import weblogic.scheduler.TransactionalTimerListener;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityManager;
import weblogic.timers.NakedTimerListener;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManagerFactory;
import weblogic.transaction.TxHelper;
import weblogic.utils.Debug;
import weblogic.utils.StackTraceUtils;
import weblogic.work.WorkAdapter;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public class TimerState
implements NakedTimerListener,
LeaseLostListener {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final boolean DEBUG = Debug.getCategory((String)"weblogic.JobScheduler").isEnabled();
    private static final String TIMER_MANAGER = "weblogic.scheduler.TimerState";
    private final String id;
    private final TimerListener to;
    private final long duration;
    private final long interval;
    private final long timeout;
    private final AuthenticatedSubject user;
    private boolean timerLeaseLost = false;

    public TimerState(String string, TimerListener timerListener, long l, long l2, AuthenticatedSubject authenticatedSubject) {
        this.id = string;
        this.to = timerListener;
        this.timeout = l;
        this.duration = l - System.currentTimeMillis();
        this.interval = l2;
        this.user = authenticatedSubject == null ? SubjectUtils.getAnonymousSubject() : authenticatedSubject;
    }

    LeaseManager getLeasing() {
        try {
            return TimerMaster.getLeaseManager();
        }
        catch (NamingException namingException) {
            namingException.printStackTrace();
            return null;
        }
    }

    public String getId() {
        return this.id;
    }

    public TimerListener getTimedObject() {
        return this.to;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public long getInterval() {
        return this.interval;
    }

    public Serializable getInfo() {
        return null;
    }

    public AuthenticatedSubject getUser() {
        return this.user;
    }

    public void fireWhenReady() {
        LeaseManager leaseManager = this.getLeasing();
        assert (leaseManager != null);
        try {
            if (!leaseManager.tryAcquire(this.id)) {
                if (DEBUG) {
                    TimerState.debug("failed to claim ownership of timer " + this.id);
                }
                return;
            }
            if (DEBUG) {
                TimerState.debug("claimed ownership of timer " + this.id);
            }
        }
        catch (LeasingException leasingException) {
            if (DEBUG) {
                TimerState.debug("failed to claim ownership of timer " + this.id);
            }
            return;
        }
        leaseManager.addLeaseLostListener(this);
        if (this.duration <= 0L) {
            if (DEBUG) {
                TimerState.debug("timer will execute immediately " + this.id);
            }
            this.enqueueTimer(this);
        } else {
            if (DEBUG) {
                TimerState.debug("execute timer after " + this.duration + "ms");
            }
            TimerManagerFactory.getTimerManagerFactory().getTimerManager(TIMER_MANAGER, "weblogic.kernel.System").schedule((TimerListener)this, this.duration);
        }
    }

    public void timerExpired(Timer timer) {
        this.enqueueTimer(this);
    }

    private void enqueueTimer(final TimerState timerState) {
        TimerListenerExtension timerListenerExtension;
        WorkAdapter workAdapter = new WorkAdapter(){

            public String toString() {
                return "Execute job " + timerState.getId() + " for Job Scheduler";
            }

            public Runnable cancel(String string) {
                if (DEBUG) {
                    TimerState.debug("timer execution is cancelled because of '" + string + "'");
                }
                return new Runnable(){

                    public void run() {
                    }
                };
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public void run() {
                block32: {
                    block30: {
                        block31: {
                            var1_1 = false;
                            var2_2 = false;
                            if (!TimerState.access$200(TimerState.this)) {
                                return;
                            }
                            if (timerState.getTimedObject() instanceof TransactionalTimerListener) {
                                var2_2 = true;
                                try {
                                    TimerState.this.preInvoke();
                                }
                                catch (SystemException var3_3) {
                                    if (TimerState.access$000()) {
                                        TimerState.access$100("tx begin failed with " + StackTraceUtils.throwable2StackTrace((Throwable)var3_3));
                                    }
                                    return;
                                }
                                catch (NotSupportedException var3_4) {
                                    if (TimerState.access$000()) {
                                        TimerState.access$100("tx begin failed with " + StackTraceUtils.throwable2StackTrace((Throwable)var3_4));
                                    }
                                    return;
                                }
                            }
                            try {
                                SecurityManager.runAs((AuthenticatedSubject)TimerState.access$300(), (AuthenticatedSubject)timerState.getUser(), (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                                    public Object run() throws Exception {
                                        timerState.getTimedObject().timerExpired((Timer)new TimerImpl(timerState.getId()));
                                        return null;
                                    }
                                });
                            }
                            catch (PrivilegedActionException var3_5) {
                                throw new AssertionError((Object)var3_5);
                            }
                            var3_6 = TimerBasisAccess.getTimerBasis();
                            if (timerState.getInterval() != -1L) break block31;
                            var3_6.cancelTimer(timerState.getId());
                            ** GOTO lbl56
                        }
                        if (TimerState.access$200(TimerState.this)) break block29;
                        var5_9 = null;
                        if (!var2_2) break block30;
                        if (var1_1) {
                            TimerState.this.postInvokeSuccess();
                            break block30;
                        }
                        TimerState.this.postInvokeFailure();
                    }
                    try {
                        TimerState.access$402(timerState, false);
                        var6_12 = TimerState.this.getLeasing();
                        if (!1.$assertionsDisabled && var6_12 == null) {
                            throw new AssertionError();
                        }
                        var6_12.removeLeaseLostListener(timerState);
                        var6_12.release(timerState.getId());
                    }
                    catch (LeasingException var6_13) {
                        // empty catch block
                    }
                    {
                        block29: {
                            return;
                        }
                        try {
                            var3_6.advanceIntervalTimer(timerState.getId(), timerState.getTimedObject());
lbl56:
                            // 2 sources

                            var1_1 = true;
                            JobSchedulerRuntimeMBeanImpl.getInstance().timerExecuted(timerState.getId(), timerState.getTimedObject().toString(), timerState.getInterval());
                        }
                        catch (NoSuchObjectLocalException var3_7) {
                            throw new AssertionError((Object)var3_7);
                        }
                        catch (TimerException var3_8) {
                            throw new AssertionError((Object)var3_8);
                        }
                    }
                    var5_10 = null;
                    if (var2_2) {
                        if (var1_1) {
                            TimerState.this.postInvokeSuccess();
                        } else {
                            TimerState.this.postInvokeFailure();
                        }
                    }
                    try {
                        TimerState.access$402(timerState, false);
                        var6_14 = TimerState.this.getLeasing();
                        if (!1.$assertionsDisabled && var6_14 == null) {
                            throw new AssertionError();
                        }
                        var6_14.removeLeaseLostListener(timerState);
                        var6_14.release(timerState.getId());
                    }
                    catch (LeasingException var6_15) {}
                    break block32;
                    catch (Throwable var4_18) {
                        var5_11 = null;
                        if (var2_2) {
                            if (var1_1) {
                                TimerState.this.postInvokeSuccess();
                            } else {
                                TimerState.this.postInvokeFailure();
                            }
                        }
                        try {
                            TimerState.access$402(timerState, false);
                            var6_16 = TimerState.this.getLeasing();
                            if (!1.$assertionsDisabled && var6_16 == null) {
                                throw new AssertionError();
                            }
                            var6_16.removeLeaseLostListener(timerState);
                            var6_16.release(timerState.getId());
                        }
                        catch (LeasingException var6_17) {
                            // empty catch block
                        }
                        throw var4_18;
                    }
                }
            }
        };
        WorkManager workManager = WorkManagerFactory.getInstance().getSystem();
        if (this.to instanceof TimerListenerExtension && (timerListenerExtension = (TimerListenerExtension)this.to).getDispatchPolicy() != null) {
            workManager = WorkManagerFactory.getInstance().find(timerListenerExtension.getDispatchPolicy(), timerListenerExtension.getApplicationName(), timerListenerExtension.getModuleName());
        }
        workManager.schedule((Runnable)workAdapter);
    }

    private boolean isLeaseOwner() {
        try {
            if (this.isLeaseLost()) {
                return false;
            }
            return this.getLeasing().tryAcquire(this.id);
        }
        catch (LeasingException leasingException) {
            if (DEBUG) {
                TimerState.debug("failed to claim ownership of timer " + this.id);
            }
            return false;
        }
    }

    private static void debug(String string) {
        ClusterLogger.logDebug((String)("[TimerState] " + string));
    }

    synchronized boolean isLeaseLost() {
        return this.timerLeaseLost;
    }

    public synchronized void onRelease() {
        LeaseManager leaseManager = this.getLeasing();
        assert (leaseManager != null);
        leaseManager.removeLeaseLostListener(this);
        this.timerLeaseLost = true;
    }

    public void preInvoke() throws SystemException, NotSupportedException {
        TxHelper.getTransactionManager().begin();
    }

    public void postInvokeSuccess() {
        block2: {
            try {
                TxHelper.getTransactionManager().commit();
            }
            catch (Exception exception) {
                if (!DEBUG) break block2;
                TimerState.debug("tx commit failed with " + StackTraceUtils.throwable2StackTrace((Throwable)exception));
            }
        }
    }

    public void postInvokeFailure() {
        block2: {
            try {
                TxHelper.getTransactionManager().rollback();
            }
            catch (SystemException systemException) {
                if (!DEBUG) break block2;
                TimerState.debug("tx rollback failed with " + StackTraceUtils.throwable2StackTrace((Throwable)systemException));
            }
        }
    }

    static /* synthetic */ boolean access$200(TimerState timerState) {
        return timerState.isLeaseOwner();
    }

    static /* synthetic */ AuthenticatedSubject access$300() {
        return kernelId;
    }

    static /* synthetic */ boolean access$402(TimerState timerState, boolean bl) {
        timerState.timerLeaseLost = bl;
        return timerState.timerLeaseLost;
    }
}

