/*
 * Decompiled with CFR 0.152.
 */
package weblogic.scheduler.ejb.internal;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.application.ApplicationAccess;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.utils.TargetUtils;
import weblogic.j2ee.ApplicationManager;
import weblogic.scheduler.ApplicationNotFoundException;
import weblogic.scheduler.TimerCreationCallback;
import weblogic.scheduler.TimerListenerExtension;
import weblogic.scheduler.ejb.EJBTimerListener;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.utils.classloaders.Annotation;

public class EJBListenerWrapper
implements TimerListener,
TimerCreationCallback,
TimerListenerExtension,
Externalizable {
    private EJBTimerListener ejbListener;
    private String annotation;
    private String dispatchPolicy;

    EJBListenerWrapper(String string, EJBTimerListener eJBTimerListener, String string2) {
        this.ejbListener = eJBTimerListener;
        this.annotation = string;
        this.dispatchPolicy = string2 != null ? string2 : "default";
    }

    public EJBListenerWrapper() {
    }

    public void timerExpired(Timer timer) {
        this.executeTimer(timer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTimer(Timer timer) {
        ClassLoader classLoader = ApplicationManager.getApplicationClassLoader(new Annotation(this.annotation));
        ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            this.ejbListener.timerExpired(timer);
            Object var5_4 = null;
            Thread.currentThread().setContextClassLoader(classLoader2);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            Thread.currentThread().setContextClassLoader(classLoader2);
            throw throwable;
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(this.annotation);
        objectOutput.writeObject(this.ejbListener);
        objectOutput.writeUTF(this.dispatchPolicy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        boolean bl;
        this.annotation = objectInput.readUTF();
        Annotation annotation = new Annotation(this.annotation);
        ClassLoader classLoader = ApplicationManager.getApplicationClassLoader(annotation);
        ApplicationContextInternal applicationContextInternal = ApplicationAccess.getApplicationAccess().getApplicationContext(annotation.getApplicationName());
        boolean bl2 = bl = applicationContextInternal != null && TargetUtils.isDeployedLocally(applicationContextInternal.getBasicDeploymentMBean().getTargets());
        if (!bl) {
            throw new ApplicationNotFoundException(annotation.getApplicationName());
        }
        ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            this.ejbListener = (EJBTimerListener)objectInput.readObject();
            Object var8_7 = null;
            Thread.currentThread().setContextClassLoader(classLoader2);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            Thread.currentThread().setContextClassLoader(classLoader2);
            throw throwable;
        }
        this.dispatchPolicy = objectInput.readUTF();
    }

    public String getTimerId(String string) {
        String string2 = string;
        if (this.ejbListener.getGroupName() != null) {
            string2 = this.ejbListener.getGroupName() + "@@" + string2;
        }
        return string2;
    }

    public EJBTimerListener getEJBTimerListener() {
        return this.ejbListener;
    }

    public String getDispatchPolicy() {
        return this.dispatchPolicy;
    }

    public boolean isTransactional() {
        return false;
    }

    public String getApplicationName() {
        return new Annotation(this.annotation).getApplicationName();
    }

    public String getModuleName() {
        return new Annotation(this.annotation).getModuleName();
    }
}

