/*
 * Decompiled with CFR 0.152.
 */
package weblogic.scheduler.ejb.internal;

import java.io.Serializable;
import java.util.Date;
import weblogic.scheduler.NoSuchObjectLocalException;
import weblogic.scheduler.Timer;
import weblogic.scheduler.TimerBasisAccess;
import weblogic.scheduler.TimerException;
import weblogic.scheduler.TimerHandle;
import weblogic.scheduler.TimerServiceImpl;
import weblogic.scheduler.ejb.EJBTimerListener;
import weblogic.scheduler.ejb.EJBTimerManager;
import weblogic.scheduler.ejb.internal.EJBListenerWrapper;
import weblogic.scheduler.ejb.internal.TransactionalEJBListenerWrapper;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;

public final class EJBTimerManagerImpl
implements EJBTimerManager {
    private final String name;
    private final String annotation;
    private final TimerManager timerManagerDelegate;
    private final String dispatchPolicy;

    public EJBTimerManagerImpl(String string, String string2) {
        this.name = string;
        this.annotation = string2;
        this.timerManagerDelegate = TimerServiceImpl.create(string);
        this.dispatchPolicy = null;
    }

    public EJBTimerManagerImpl(String string, String string2, String string3) {
        this.name = string;
        this.annotation = string2;
        this.timerManagerDelegate = TimerServiceImpl.create(string);
        this.dispatchPolicy = string3;
    }

    public weblogic.timers.Timer schedule(TimerListener timerListener, long l) {
        Timer timer = (Timer)this.timerManagerDelegate.schedule(this.getTimerListener(timerListener), l);
        return new TimerWrapper(timer);
    }

    public weblogic.timers.Timer schedule(TimerListener timerListener, Date date) {
        Timer timer = (Timer)this.timerManagerDelegate.schedule(this.getTimerListener(timerListener), date);
        return new TimerWrapper(timer);
    }

    public weblogic.timers.Timer schedule(TimerListener timerListener, long l, long l2) {
        Timer timer = (Timer)this.timerManagerDelegate.schedule(this.getTimerListener(timerListener), l, l2);
        return new TimerWrapper(timer);
    }

    public weblogic.timers.Timer schedule(TimerListener timerListener, Date date, long l) {
        Timer timer = (Timer)this.timerManagerDelegate.schedule(this.getTimerListener(timerListener), date, l);
        return new TimerWrapper(timer);
    }

    public weblogic.timers.Timer scheduleAtFixedRate(TimerListener timerListener, Date date, long l) {
        Timer timer = (Timer)this.timerManagerDelegate.scheduleAtFixedRate(this.getTimerListener(timerListener), date, l);
        return new TimerWrapper(timer);
    }

    public weblogic.timers.Timer scheduleAtFixedRate(TimerListener timerListener, long l, long l2) {
        Timer timer = (Timer)this.timerManagerDelegate.scheduleAtFixedRate(this.getTimerListener(timerListener), l, l2);
        return new TimerWrapper(timer);
    }

    public void resume() {
        this.timerManagerDelegate.resume();
    }

    public void suspend() {
        this.timerManagerDelegate.suspend();
    }

    public void stop() {
        try {
            TimerBasisAccess.getTimerBasis().cancelTimers(this.name);
        }
        catch (TimerException timerException) {
            // empty catch block
        }
    }

    public boolean waitForStop(long l) throws InterruptedException {
        return this.timerManagerDelegate.waitForStop(l);
    }

    public boolean isStopping() {
        return this.timerManagerDelegate.isStopping();
    }

    public boolean isStopped() {
        return this.timerManagerDelegate.isStopped();
    }

    public boolean waitForSuspend(long l) throws InterruptedException {
        return this.timerManagerDelegate.waitForSuspend(l);
    }

    public boolean isSuspending() {
        return this.timerManagerDelegate.isSuspending();
    }

    public boolean isSuspended() {
        return this.timerManagerDelegate.isSuspended();
    }

    private TimerListener getTimerListener(TimerListener timerListener) {
        if (timerListener instanceof EJBTimerListener) {
            if (((EJBTimerListener)timerListener).isTransactional()) {
                return new TransactionalEJBListenerWrapper(this.annotation, (EJBTimerListener)timerListener, this.dispatchPolicy);
            }
            return new EJBListenerWrapper(this.annotation, (EJBTimerListener)timerListener, this.dispatchPolicy);
        }
        return timerListener;
    }

    public weblogic.timers.Timer[] getTimers() {
        try {
            return this.getWrappers(TimerBasisAccess.getTimerBasis().getTimers(this.name));
        }
        catch (TimerException timerException) {
            return null;
        }
    }

    public weblogic.timers.Timer[] getTimers(String string) {
        try {
            return this.getWrappers(TimerBasisAccess.getTimerBasis().getTimers(this.name, string + "@@"));
        }
        catch (TimerException timerException) {
            return null;
        }
    }

    private weblogic.timers.Timer[] getWrappers(Timer[] timerArray) {
        if (timerArray == null) {
            return null;
        }
        weblogic.timers.Timer[] timerArray2 = new TimerWrapper[timerArray.length];
        for (int i = 0; i < timerArray.length; ++i) {
            timerArray2[i] = new TimerWrapper(timerArray[i]);
        }
        return timerArray2;
    }

    private static class TimerHandleWrapper
    implements TimerHandle {
        private final TimerHandle handle;

        TimerHandleWrapper(TimerHandle timerHandle) {
            this.handle = timerHandle;
        }

        public Timer getTimer() throws NoSuchObjectLocalException, TimerException {
            return new TimerWrapper(this.handle.getTimer());
        }
    }

    private static class TimerWrapper
    implements Timer {
        private final Timer timer;

        TimerWrapper(Timer timer) {
            this.timer = timer;
        }

        public long getTimeout() {
            return this.timer.getTimeout();
        }

        public long getPeriod() {
            return this.timer.getPeriod();
        }

        public TimerListener getListener() {
            return ((EJBListenerWrapper)this.timer.getListener()).getEJBTimerListener();
        }

        public boolean cancel() {
            return this.timer.cancel();
        }

        public boolean isStopped() {
            return this.timer.isStopped();
        }

        public boolean isCancelled() {
            return this.timer.isCancelled();
        }

        public Serializable getInfo() throws NoSuchObjectLocalException, TimerException {
            return this.timer.getInfo();
        }

        public TimerHandle getHandle() throws NoSuchObjectLocalException, TimerException {
            return new TimerHandleWrapper(this.timer.getHandle());
        }
    }
}

