/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security;

import java.security.ProviderException;
import java.security.SecureRandom;

public abstract class AbstractRandomData {
    private String provider = null;
    private String algorithm = null;
    private int initialSeedSize = 0;
    private int incrementalSeedSize = 0;
    private int seedingIntervalMillis = 0;
    private SecureRandom random = null;
    private long lastSeedTime = 0L;

    private AbstractRandomData() {
    }

    protected AbstractRandomData(String string, String string2, int n, int n2, int n3) {
        this.provider = string;
        this.algorithm = string2;
        this.initialSeedSize = n;
        this.incrementalSeedSize = n2;
        this.seedingIntervalMillis = n3;
    }

    private final synchronized void ensureInittedAndSeeded() {
        long l;
        int n = this.incrementalSeedSize;
        if (this.random == null) {
            try {
                this.random = this.algorithm != null && this.provider != null ? SecureRandom.getInstance(this.algorithm, this.provider) : (this.algorithm != null ? SecureRandom.getInstance(this.algorithm) : new SecureRandom());
            }
            catch (Exception exception) {
                this.random = null;
                throw new ProviderException("AbstractRandomData: Unable to instantiate SecureRandom");
            }
            n = this.initialSeedSize;
            this.lastSeedTime = 0L;
        }
        if (n > 0 && (l = System.currentTimeMillis()) >= this.lastSeedTime + (long)this.seedingIntervalMillis) {
            byte[] byArray = this.random.generateSeed(n);
            this.random.setSeed(byArray);
            this.lastSeedTime = l;
        }
    }

    public final byte[] getRandomBytes(int n) {
        byte[] byArray = new byte[n];
        this.getRandomBytes(byArray);
        return byArray;
    }

    public final synchronized void getRandomBytes(byte[] byArray) {
        this.ensureInittedAndSeeded();
        this.random.nextBytes(byArray);
    }
}

