/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Set;
import weblogic.security.CertificatePolicy;

public class CertificatePoliciesExtension {
    private static final String EXTN_ID = "2.5.29.32";
    private static final String className = "com.bea.sslplus.extensions.CertificatePoliciesImpl";
    private CertificatePolicy[] policies;
    private boolean critical;

    public CertificatePoliciesExtension(boolean bl, CertificatePolicy[] certificatePolicyArray) {
        this.critical = bl;
        this.policies = certificatePolicyArray;
    }

    public static CertificatePoliciesExtension getCertificatePoliciesExtension(X509Certificate x509Certificate) throws CertificateParsingException {
        Object var1_1 = null;
        boolean bl = false;
        Set<String> set = x509Certificate.getCriticalExtensionOIDs();
        if (set != null && !set.isEmpty()) {
            bl = set.contains(EXTN_ID);
        }
        try {
            Class<?> clazz = Class.forName(className);
            Method method = clazz.getMethod("getPolicies", X509Certificate.class);
            CertificatePolicy[] certificatePolicyArray = (CertificatePolicy[])method.invoke(null, x509Certificate);
            return new CertificatePoliciesExtension(bl, certificatePolicyArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            CertificateParsingException certificateParsingException = new CertificateParsingException("Cannot Parse the Certificate Policies Extension");
            certificateParsingException.initCause(invocationTargetException.getCause());
            throw certificateParsingException;
        }
        catch (Exception exception) {
            throw new RuntimeException("Unexpected exception", exception);
        }
    }

    public boolean isCritical() {
        return this.critical;
    }

    public CertificatePolicy[] getPolicies() {
        CertificatePolicy[] certificatePolicyArray = new CertificatePolicy[this.policies.length];
        System.arraycopy(this.policies, 0, certificatePolicyArray, 0, this.policies.length);
        return certificatePolicyArray;
    }
}

