/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import weblogic.security.SecurityLogger;

public final class PEMInputStream
extends FilterInputStream {
    private static final char[] pem_array;
    private static final byte[] pem_convert_array;
    static final int EOF = -1;

    public PEMInputStream(InputStream inputStream) throws IOException {
        super(null);
        if (inputStream.available() == 0) {
            throw new IOException(SecurityLogger.getZeroLengthPemInputStream());
        }
        byte[] byArray = new byte[45];
        int n = 0;
        while (n < byArray.length) {
            n = PEMInputStream.decodeAtom(inputStream, byArray, n) == 3 ? n + 3 : 0;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(byArray, 0, n);
        int n2 = 0;
        while (n2 <= 3) {
            int n3 = PEMInputStream.decodeAtom(inputStream, byArray, 0);
            if (n3 > 0) {
                byteArrayOutputStream.write(byArray, 0, n3);
                if (n3 < 3) break;
                n2 = 0;
                continue;
            }
            if (n3 == -1) break;
            ++n2;
        }
        this.in = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    static int decodeAtom(InputStream inputStream, byte[] byArray, int n) throws IOException {
        int n2 = inputStream.read();
        if (n2 < 0) {
            return -1;
        }
        if ((n2 = pem_convert_array[n2]) < 0) {
            return 0;
        }
        byArray[n] = (byte)(n2 << 2);
        n2 = inputStream.read();
        if (n2 < 0) {
            return -1;
        }
        if ((n2 = pem_convert_array[n2]) < 0) {
            return 0;
        }
        int n3 = n;
        byArray[n3] = (byte)(byArray[n3] | n2 >> 4);
        byArray[n + 1] = (byte)(n2 << 4);
        n2 = inputStream.read();
        if (n2 < 0 || n2 == 61) {
            return 1;
        }
        if ((n2 = pem_convert_array[n2]) < 0) {
            return 0;
        }
        int n4 = n + 1;
        byArray[n4] = (byte)(byArray[n4] | n2 >> 2);
        byArray[n + 2] = (byte)(n2 << 6);
        n2 = inputStream.read();
        if (n2 < 0 || n2 == 61) {
            return 2;
        }
        if ((n2 = pem_convert_array[n2]) < 0) {
            return 0;
        }
        int n5 = n + 2;
        byArray[n5] = (byte)(byArray[n5] | n2);
        return 3;
    }

    static {
        int n;
        pem_array = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        pem_convert_array = new byte[256];
        for (n = 0; n < 255; ++n) {
            PEMInputStream.pem_convert_array[n] = -1;
        }
        for (n = 0; n < pem_array.length; ++n) {
            PEMInputStream.pem_convert_array[PEMInputStream.pem_array[n]] = (byte)n;
        }
    }
}

