/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security;

import java.security.AccessController;
import weblogic.management.ManagementException;
import weblogic.management.runtime.RealmRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.management.runtime.ServerSecurityRuntimeMBean;
import weblogic.management.runtime.UserLockoutManagerRuntimeMBean;
import weblogic.security.UserLockoutManagerRuntime;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.InvalidParameterException;
import weblogic.security.service.NotYetInitializedException;
import weblogic.security.service.PrincipalAuthenticator;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.service.UserLockoutManager;

public final class RealmRuntime
extends RuntimeMBeanDelegate
implements RealmRuntimeMBean {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private UserLockoutManagerRuntimeMBean userLockoutManagerRuntime = null;

    public RealmRuntime(String string, ServerSecurityRuntimeMBean serverSecurityRuntimeMBean) throws ManagementException {
        super(string, (RuntimeMBean)serverSecurityRuntimeMBean, true, "DefaultRealmRuntime");
        try {
            PrincipalAuthenticator principalAuthenticator = SecurityServiceManager.getPrincipalAuthenticator((AuthenticatedSubject)kernelId, (String)string);
            UserLockoutManager userLockoutManager = principalAuthenticator.getUserLockoutManager();
            if (userLockoutManager.isLockoutEnabled()) {
                this.userLockoutManagerRuntime = new UserLockoutManagerRuntime(userLockoutManager, this);
            }
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (NotYetInitializedException notYetInitializedException) {
            throw new AssertionError((Object)notYetInitializedException);
        }
    }

    public UserLockoutManagerRuntimeMBean getUserLockoutManagerRuntime() {
        return this.userLockoutManagerRuntime;
    }
}

