/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security;

import java.security.AccessController;
import weblogic.management.configuration.Acl;
import weblogic.management.configuration.Group;
import weblogic.management.configuration.Principal;
import weblogic.management.configuration.RealmException;
import weblogic.management.configuration.RealmIterator;
import weblogic.management.configuration.RealmManager;
import weblogic.management.configuration.User;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

class RealmTester {
    private static boolean verboseex = true;
    private RealmManager realm;
    private static boolean debugPrintRealm = false;
    private static boolean debugEditRealm = false;

    public static void runTest() {
        if (debugPrintRealm | debugEditRealm) {
            RealmTester realmTester = new RealmTester();
        }
    }

    private void handleEx(Throwable throwable) {
        if (verboseex) {
            System.out.println("Unexpected exception : " + throwable);
            throwable.printStackTrace();
        }
    }

    private void handleEx(Throwable throwable, boolean bl) {
        if (bl) {
            this.handleEx(throwable);
        }
    }

    private String print(User user) {
        return user.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String print(Group group) {
        String string = group.getName() + '(';
        try {
            RealmIterator realmIterator = group.getMembers();
            try {
                boolean bl = true;
                while (realmIterator.hasNext()) {
                    if (!bl) {
                        string = string + ',';
                    } else {
                        bl = false;
                    }
                    string = string + this.print((Principal)realmIterator.next());
                }
                Object var6_6 = null;
                realmIterator.close();
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                realmIterator.close();
                throw throwable;
            }
        }
        catch (Exception exception) {
            this.handleEx(exception);
            string = string + exception;
        }
        string = string + ')';
        return string;
    }

    private String print(Principal principal) {
        String string = "";
        string = principal instanceof User ? string + "User" : (principal instanceof Group ? string + "Group" : string + "Unknown");
        string = string + '{' + principal.getName() + '}';
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String print(Acl acl) {
        String string = acl.getName() + '(';
        String[] stringArray = null;
        try {
            stringArray = acl.getPermissions();
        }
        catch (Exception exception) {
            this.handleEx(exception);
            string = string + exception;
        }
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            if (i != 0) {
                string = string + ',';
            }
            String string2 = stringArray[i];
            string = string + '[' + string2 + '=';
            try {
                Object var9_10;
                RealmIterator realmIterator = acl.getGrantees(string2);
                try {
                    boolean bl = true;
                    while (realmIterator.hasNext()) {
                        if (!bl) {
                            string = string + ',';
                        } else {
                            bl = false;
                        }
                        string = string + this.print((Principal)realmIterator.next());
                    }
                    var9_10 = null;
                    realmIterator.close();
                }
                catch (Throwable throwable) {
                    var9_10 = null;
                    realmIterator.close();
                    throw throwable;
                }
            }
            catch (RealmException realmException) {
                this.handleEx((Throwable)((Object)realmException));
                string = string + (Object)((Object)realmException);
            }
            string = string + ']';
        }
        string = string + ')';
        return string;
    }

    private String getPass(boolean bl) {
        return bl ? "SUCCESS : " : "FAILURE : ";
    }

    private String getFail(boolean bl) {
        return !bl ? "SUCCESS : " : "FAILURE : ";
    }

    private User createUser(String string, boolean bl) {
        try {
            User user = this.realm.createUser(string, string + "_password");
            System.out.println(this.getPass(bl) + " created user " + this.print(user));
            return user;
        }
        catch (Exception exception) {
            this.handleEx(exception, bl);
            System.out.println(this.getFail(bl) + " couldn't create user " + string + " : " + exception);
            return null;
        }
    }

    private User getUser(String string, boolean bl) {
        try {
            User user = this.realm.getUser(string);
            if (user != null) {
                System.out.println(this.getPass(bl) + " got user " + this.print(user));
            } else {
                System.out.println(this.getFail(bl) + " couldn't get user " + string);
            }
            return user;
        }
        catch (Exception exception) {
            this.handleEx(exception, bl);
            System.out.println("FAILURE :  error getting user " + string + " : " + exception);
            return null;
        }
    }

    private void removeUser(User user, boolean bl) {
        try {
            this.realm.removeUser(user);
            System.out.println(this.getPass(bl) + " removed user " + this.print(user));
        }
        catch (Exception exception) {
            this.handleEx(exception, bl);
            System.out.println(this.getFail(bl) + " couldn't remove user " + this.print(user) + " : " + exception);
        }
    }

    private Group createGroup(String string, boolean bl) {
        try {
            Group group = this.realm.createGroup(string);
            System.out.println(this.getPass(bl) + " created group " + this.print(group));
            return group;
        }
        catch (Exception exception) {
            this.handleEx(exception, bl);
            System.out.println(this.getFail(bl) + " couldn't create group " + string + " : " + exception);
            return null;
        }
    }

    private Group getGroup(String string, boolean bl) {
        try {
            Group group = this.realm.getGroup(string);
            if (group != null) {
                System.out.println(this.getPass(bl) + " got group " + this.print(group));
            } else {
                System.out.println(this.getFail(bl) + " couldn't get group " + string);
            }
            return group;
        }
        catch (Exception exception) {
            this.handleEx(exception, bl);
            System.out.println("FAILURE :  error getting group " + string + " : " + exception);
            return null;
        }
    }

    private void removeGroup(Group group, boolean bl) {
        try {
            this.realm.removeGroup(group);
            System.out.println(this.getPass(bl) + " removed group " + this.print(group));
        }
        catch (Exception exception) {
            this.handleEx(exception, bl);
            System.out.println(this.getFail(bl) + " couldn't remove group " + this.print(group) + " : " + exception);
        }
    }

    private void changeUserCredential(User user, Object object, Object object2, boolean bl) {
        try {
            boolean bl2 = user.changeCredential(object, object2);
            if (bl2) {
                System.out.println(this.getPass(bl) + " changed credential for " + this.print(user) + " from " + object + " to " + object2);
            } else {
                System.out.println(this.getPass(bl) + " wouldn't change credential for " + this.print(user) + " from " + object + " to " + object2);
            }
        }
        catch (Exception exception) {
            this.handleEx(exception, bl);
            System.out.println(this.getFail(bl) + " couldn't change credential for " + this.print(user) + " from " + object + " to " + object2);
        }
    }

    private void addGroupMember(Group group, Principal principal, boolean bl) {
        try {
            group.addMember(principal);
            System.out.println(this.getPass(bl) + " added " + this.print(principal) + " to " + this.print(group));
        }
        catch (Exception exception) {
            this.handleEx(exception, bl);
            System.out.println(this.getFail(bl) + " couldn't add " + this.print(principal) + " to " + this.print(group) + " : " + exception);
        }
    }

    private void removeGroupMember(Group group, Principal principal, boolean bl) {
        try {
            group.removeMember(principal);
            System.out.println(this.getPass(bl) + " removed " + this.print(principal) + " from " + this.print(group));
        }
        catch (Exception exception) {
            this.handleEx(exception, bl);
            System.out.println(this.getFail(bl) + " couldn't remove " + this.print(principal) + " from " + this.print(group) + " : " + exception);
        }
    }

    private Acl createAcl(String string, boolean bl) {
        try {
            Acl acl = this.realm.createAcl(string);
            System.out.println(this.getPass(bl) + " created acl " + this.print(acl));
            return acl;
        }
        catch (Exception exception) {
            this.handleEx(exception, bl);
            System.out.println(this.getFail(bl) + " couldn't create acl " + string + " : " + exception);
            return null;
        }
    }

    private Acl getAcl(String string, boolean bl) {
        try {
            Acl acl = this.realm.getAcl(string);
            if (acl != null) {
                System.out.println(this.getPass(bl) + " got acl " + this.print(acl));
            } else {
                System.out.println(this.getFail(bl) + " couldn't get acl " + string);
            }
            return acl;
        }
        catch (Exception exception) {
            this.handleEx(exception, bl);
            System.out.println("FAILURE :  error getting acl " + string + " : " + exception);
            return null;
        }
    }

    private void removeAcl(Acl acl, boolean bl) {
        try {
            this.realm.removeAcl(acl);
            System.out.println(this.getPass(bl) + " removed acl " + this.print(acl));
        }
        catch (Exception exception) {
            this.handleEx(exception, bl);
            System.out.println(this.getFail(bl) + " couldn't remove acl " + this.print(acl) + " : " + exception);
        }
    }

    private void grantPermission(Acl acl, Principal principal, String string, boolean bl) {
        try {
            acl.grantPermission(principal, string);
            System.out.println(this.getPass(bl) + " added " + string + " for " + this.print(principal) + " to " + this.print(acl));
        }
        catch (Exception exception) {
            this.handleEx(exception, bl);
            System.out.println(this.getFail(bl) + " couldn't add " + string + " for " + this.print(principal) + " to " + this.print(acl) + " : " + exception);
        }
    }

    private void revokePermission(Acl acl, Principal principal, String string, boolean bl) {
        try {
            acl.revokePermission(principal, string);
            System.out.println(this.getPass(bl) + " revoked " + string + " for " + this.print(principal) + " from " + this.print(acl));
        }
        catch (Exception exception) {
            this.handleEx(exception, bl);
            System.out.println(this.getFail(bl) + " couldn't revoke " + string + " for " + this.print(principal) + " from " + this.print(acl) + " : " + exception);
        }
    }

    private void getGrantees(Acl acl, String string, boolean bl) {
        try {
            RealmIterator realmIterator = acl.getGrantees(string);
            realmIterator.close();
            System.out.println(this.getPass(bl) + " got grantees for " + string + " from " + this.print(acl));
        }
        catch (Exception exception) {
            this.handleEx(exception, bl);
            System.out.println(this.getFail(bl) + " couldn't get grantees for " + string + " from " + this.print(acl) + " : " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printRealm() {
        RealmIterator realmIterator;
        try {
            realmIterator = this.realm.listUsers();
            try {
                System.out.println("users = ");
                while (realmIterator.hasNext()) {
                    System.out.println('\t' + this.print((User)realmIterator.next()));
                }
                Object var3_5 = null;
                realmIterator.close();
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                realmIterator.close();
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            this.handleEx(throwable);
            System.out.println("FAILURE : listUsers failed : " + throwable);
        }
        try {
            realmIterator = this.realm.listGroups();
            try {
                System.out.println("groups = ");
                while (realmIterator.hasNext()) {
                    System.out.println('\t' + this.print((Group)realmIterator.next()));
                }
                Object var5_8 = null;
                realmIterator.close();
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                realmIterator.close();
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            this.handleEx(throwable);
            System.out.println("FAILURE : listGroups failed : " + throwable);
        }
        try {
            realmIterator = this.realm.listAcls();
            try {
                System.out.println("acls = ");
                while (realmIterator.hasNext()) {
                    System.out.println('\t' + this.print((Acl)realmIterator.next()));
                }
                Object var7_11 = null;
                realmIterator.close();
            }
            catch (Throwable throwable) {
                Object var7_12 = null;
                realmIterator.close();
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            this.handleEx(throwable);
            System.out.println("FAILURE : listAcls failed : " + throwable);
        }
    }

    private void testEdit() {
        if (!debugEditRealm) {
            return;
        }
        User user = this.createUser(" \t=:#!u \t=:#!0 \t=:#!", true);
        Group group = this.createGroup(" \t=:#!g \t=:#!0 \t=:#!", true);
        Acl acl = this.createAcl(" \t=:#!a \t=:#!0 \t=:#!", true);
        this.addGroupMember(group, user, true);
        this.grantPermission(acl, group, " \t=:#!p \t=:#!0 \t=:#!", true);
        this.grantPermission(acl, user, " \t=:#!p \t=:#!0 \t=:#!", true);
        this.createUser("u,u", false);
        this.createGroup("g,g", false);
        this.grantPermission(acl, user, "p.p", false);
        this.getUser("noSuchUser", false);
        this.getGroup("noSuchGroup", false);
        this.getAcl("noSuchAcl", false);
        User user2 = this.createUser("u1", true);
        this.getUser("u1", true);
        this.createUser("u1", false);
        Group group2 = this.createGroup("g1", true);
        this.getGroup("g1", true);
        this.createGroup("g1", false);
        Acl acl2 = this.createAcl("a1", true);
        this.getAcl("a1", true);
        this.createAcl("a1", false);
        this.getGrantees(acl2, "noSuchPermission", true);
        this.changeUserCredential(user2, "u1_password_bogus", "u1_password1", false);
        this.changeUserCredential(user2, "u1_password", "u1_password2", true);
        this.changeUserCredential(user2, "u1_password", "u1_password3", false);
        this.changeUserCredential(user2, "u1_password2", "u1_password4", true);
        this.addGroupMember(group2, user2, true);
        this.addGroupMember(group2, user2, false);
        this.grantPermission(acl2, user2, "p1", true);
        this.grantPermission(acl2, user2, "p1", false);
        Group group3 = this.createGroup("g2", true);
        this.addGroupMember(group2, group3, true);
        this.addGroupMember(group2, group3, false);
        this.grantPermission(acl2, group3, "p1", true);
        this.grantPermission(acl2, group3, "p1", false);
        Group group4 = this.getGroup("everyone", true);
        this.removeGroupMember(group4, user2, false);
        this.addGroupMember(group2, group2, false);
        this.removeGroupMember(group2, group2, false);
        User user3 = this.createUser("u3", true);
        this.addGroupMember(group2, user3, true);
        this.removeGroupMember(group2, user3, true);
        this.removeGroupMember(group2, user3, false);
        this.grantPermission(acl2, user3, "p1", true);
        this.revokePermission(acl2, user3, "p1", true);
        this.revokePermission(acl2, user3, "p1", false);
        Group group5 = this.createGroup("g3", true);
        this.addGroupMember(group2, group5, true);
        this.removeGroupMember(group2, group5, true);
        this.removeGroupMember(group2, group5, false);
        this.grantPermission(acl2, group5, "p1", true);
        this.revokePermission(acl2, group5, "p1", true);
        this.revokePermission(acl2, group5, "p1", false);
        User user4 = this.createUser("u4", true);
        this.addGroupMember(group2, user4, true);
        this.grantPermission(acl2, user4, "p1", true);
        this.removeUser(user4, true);
        this.removeUser(user4, false);
        Group group6 = this.createGroup("g4", true);
        this.addGroupMember(group2, group6, true);
        this.grantPermission(acl2, group6, "p1", true);
        this.removeGroup(group6, true);
        this.removeGroup(group6, false);
        Acl acl3 = this.createAcl("a4", true);
        this.removeAcl(acl3, true);
        this.removeAcl(acl3, false);
        User user5 = this.createUser("u5", true);
        Group group7 = this.createGroup("g5", true);
        this.grantPermission(acl2, user5, "p5", true);
        this.grantPermission(acl2, group7, "p5", true);
        this.revokePermission(acl2, user5, "p5", true);
        this.revokePermission(acl2, group7, "p5", true);
        User user6 = this.createUser("uOld", true);
        User user7 = this.createUser("uNew", true);
        this.changeUserCredential(user7, "uNew_password", "uOld_password", true);
    }

    private void testPrint() {
        if (!debugPrintRealm) {
            return;
        }
        this.printRealm();
    }

    private void test() {
        this.testEdit();
        this.testPrint();
    }

    private RealmTester() {
        try {
            AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
            this.realm = ManagementService.getRuntimeAccess(authenticatedSubject).getDomain().getSecurity().getRealm().manager();
        }
        catch (Exception exception) {
            this.handleEx(exception);
            throw new Error("error running Realm tester: " + exception);
        }
        this.test();
    }
}

