/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.SSL;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.security.KeyManagementException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.StringTokenizer;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import weblogic.security.SSL.HostnameVerifier;
import weblogic.security.SSL.HostnameVerifierJSSE;
import weblogic.security.SSL.TrustManager;
import weblogic.security.SSL.TrustManagerJSSE;
import weblogic.security.SecurityLogger;
import weblogic.security.utils.InputStreamsCloner;
import weblogic.security.utils.SSLCertUtility;
import weblogic.security.utils.SSLContextWrapper;
import weblogic.security.utils.SSLSetup;
import weblogic.utils.Hex;

public final class SSLClientInfo {
    private String expectedName = null;
    private HostnameVerifier hostnameVerifier;
    private TrustManager trustManager;
    private HostnameVerifierJSSE hostnameVerifierJSSE;
    private TrustManagerJSSE trustManagerJSSE;
    private String clientKeyPassword = null;
    private PrivateKey clientPrivateKey = null;
    private InputStreamsCloner clientCertCloner = null;
    private X509Certificate[] clientCertChain = null;
    private X509Certificate[] trustedCA = null;
    private byte[][] rootCAfingerprints = null;
    private transient SSLSocketFactory socketFactory;
    private boolean bNio = false;

    public SSLClientInfo(boolean bl) {
        this.bNio = bl;
    }

    public SSLClientInfo() {
        this(false);
    }

    public void setNio(boolean bl) {
        if (bl != this.bNio) {
            this.socketFactory = null;
            this.bNio = bl;
        }
    }

    public boolean isNioSet() {
        return this.bNio;
    }

    public synchronized SSLSocketFactory getSSLSocketFactory() throws SocketException {
        if (this.socketFactory == null) {
            this.socketFactory = !this.bNio ? SSLSetup.getSSLContext(this).getSSLSocketFactory() : SSLSetup.getSSLContext(this).getSSLNioSocketFactory();
        }
        return this.socketFactory;
    }

    public boolean isEmpty() {
        return this.expectedName == null && this.hostnameVerifier == null && this.trustManager == null && this.trustedCA == null && this.clientKeyPassword == null && this.clientPrivateKey == null && this.clientCertChain == null && this.clientCertCloner == null && this.rootCAfingerprints == null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof SSLClientInfo)) {
            return false;
        }
        SSLClientInfo sSLClientInfo = (SSLClientInfo)object;
        if (this.isEmpty()) {
            return sSLClientInfo.isEmpty();
        }
        return !sSLClientInfo.isEmpty() && SSLClientInfo.equals(this.expectedName, sSLClientInfo.expectedName) && SSLClientInfo.equals(this.hostnameVerifier, sSLClientInfo.hostnameVerifier) && SSLClientInfo.equals(this.trustManager, sSLClientInfo.trustManager) && SSLClientInfo.equals(this.trustedCA, sSLClientInfo.trustedCA) && SSLClientInfo.equals(this.clientKeyPassword, sSLClientInfo.clientKeyPassword) && SSLClientInfo.equals(this.clientPrivateKey, sSLClientInfo.clientPrivateKey) && Arrays.equals(this.clientCertChain, sSLClientInfo.clientCertChain) && SSLClientInfo.equals(this.clientCertCloner, sSLClientInfo.clientCertCloner) && SSLClientInfo.equals(this.rootCAfingerprints, this.rootCAfingerprints);
    }

    public int hashCode() {
        if (this.isEmpty()) {
            return 0;
        }
        int n = 1;
        n = n * 31 + SSLClientInfo.getHashCode(this.expectedName);
        n = n * 31 + SSLClientInfo.getHashCode(this.hostnameVerifier);
        n = n * 31 + SSLClientInfo.getHashCode(this.trustManager);
        n = n * 31 + SSLClientInfo.getHashCode(this.trustedCA);
        n = n * 31 + SSLClientInfo.getHashCode(this.clientKeyPassword);
        n = n * 31 + SSLClientInfo.getHashCode(this.clientPrivateKey);
        n = n * 31 + SSLClientInfo.getHashCode(this.clientCertChain);
        n = n * 31 + SSLClientInfo.getHashCode(this.clientCertCloner);
        n = n * 31 + SSLClientInfo.getHashCode(this.rootCAfingerprints);
        return n;
    }

    private static final boolean equals(byte[][] byArray, byte[][] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (Arrays.equals(byArray[i], byArray2[i])) continue;
            return false;
        }
        return true;
    }

    private static final boolean equals(Object object, Object object2) {
        return object == object2 || object != null && object2 != null && object.equals(object2);
    }

    private static final int getHashCode(byte[][] byArray) {
        if (byArray == null) {
            return 0;
        }
        int n = 1;
        for (int i = 0; i < byArray.length; ++i) {
            int n2 = 1;
            for (int j = 0; j < byArray[i].length; ++j) {
                n2 = n2 * 31 + byArray[i][j];
            }
            n = n * 31 + n2;
        }
        return n;
    }

    private static final int getHashCode(Object[] objectArray) {
        if (objectArray == null) {
            return 0;
        }
        int n = 1;
        for (int i = 0; i < objectArray.length; ++i) {
            n = n * 31 + SSLClientInfo.getHashCode(objectArray[i]);
        }
        return n;
    }

    private static final int getHashCode(Object object) {
        return object == null ? 0 : object.hashCode();
    }

    public InputStream[] getSSLClientCertificate() {
        if (this.clientCertCloner != null) {
            try {
                return this.clientCertCloner.cloneStreams();
            }
            catch (IOException iOException) {
                SecurityLogger.logStackTrace((Throwable)iOException);
            }
        }
        return null;
    }

    public final synchronized void setSSLClientCertificate(InputStream[] inputStreamArray) {
        this.socketFactory = null;
        this.clientCertCloner = inputStreamArray != null && inputStreamArray.length > 0 ? new InputStreamsCloner(inputStreamArray) : null;
    }

    public synchronized void setSSLClientCertificateCloner(InputStreamsCloner inputStreamsCloner) {
        this.socketFactory = null;
        this.clientCertCloner = inputStreamsCloner;
    }

    public String getExpectedName() {
        return this.expectedName;
    }

    public synchronized void setExpectedName(String string) {
        this.socketFactory = null;
        this.expectedName = string;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public synchronized void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.socketFactory = null;
        this.hostnameVerifier = hostnameVerifier;
        this.hostnameVerifierJSSE = null;
    }

    public synchronized void setHostnameVerifierJSSE(HostnameVerifierJSSE hostnameVerifierJSSE) {
        this.socketFactory = null;
        this.hostnameVerifierJSSE = hostnameVerifierJSSE;
        this.hostnameVerifier = hostnameVerifierJSSE == null ? null : new HostnameVerifier(){

            public boolean verify(String string, SSLSession sSLSession) {
                return SSLClientInfo.this.hostnameVerifierJSSE.verify(string, SSLCertUtility.getCommonName(sSLSession));
            }
        };
    }

    public HostnameVerifierJSSE getHostnameVerifierJSSE() {
        return this.hostnameVerifierJSSE;
    }

    public TrustManager getTrustManager() {
        return this.trustManager;
    }

    public synchronized void setTrustManager(TrustManager trustManager) {
        this.socketFactory = null;
        this.trustManager = trustManager;
        this.trustManagerJSSE = null;
    }

    public synchronized void setTrustManagerJSSE(TrustManagerJSSE trustManagerJSSE) {
        this.socketFactory = null;
        this.trustManagerJSSE = trustManagerJSSE;
        this.trustManager = trustManagerJSSE == null ? null : new TrustManager(){

            public boolean certificateCallback(X509Certificate[] x509CertificateArray, int n) {
                return SSLClientInfo.this.trustManagerJSSE.certificateCallback(SSLCertUtility.toJavaX509(x509CertificateArray), n);
            }
        };
    }

    public TrustManagerJSSE getTrustManagerJSSE() {
        return this.trustManagerJSSE;
    }

    public byte[][] getRootCAfingerprints() {
        return this.rootCAfingerprints;
    }

    public synchronized void setRootCAfingerprints(byte[][] byArray) {
        this.socketFactory = null;
        this.rootCAfingerprints = byArray;
    }

    public synchronized void setRootCAfingerprints(String string) {
        this.socketFactory = null;
        if (string == null) {
            this.rootCAfingerprints = null;
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", \t");
        byte[][] byArrayArray = new byte[stringTokenizer.countTokens()][];
        for (int i = 0; i < byArrayArray.length; ++i) {
            byArrayArray[i] = Hex.fromHexString((String)stringTokenizer.nextToken());
        }
        this.rootCAfingerprints = byArrayArray;
    }

    public final synchronized void setSSLClientKeyPassword(String string) {
        this.socketFactory = null;
        this.clientKeyPassword = string;
    }

    public final String getSSLClientKeyPassword() {
        return this.clientKeyPassword;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("SSLClientInfo: rootCAFingerprints ");
        stringBuffer.append(this.rootCAfingerprints != null ? String.valueOf(this.rootCAfingerprints.length) : "null");
        stringBuffer.append(", expectedServerName ").append(this.expectedName);
        stringBuffer.append(", key/certificates ");
        stringBuffer.append(this.clientCertCloner != null ? String.valueOf(this.clientCertCloner.size()) : "null");
        stringBuffer.append(", HostnameVerifier ");
        stringBuffer.append(this.hostnameVerifier != null ? this.hostnameVerifier.getClass().getName() : "null");
        stringBuffer.append(", TrustManager ");
        stringBuffer.append(this.trustManager != null ? this.trustManager.getClass().getName() : "null");
        stringBuffer.append(", ClientCertChain ");
        stringBuffer.append(this.clientCertChain != null ? String.valueOf(this.clientCertChain.length) : "null");
        stringBuffer.append(", ClientPrivateKey ").append(this.clientPrivateKey);
        return stringBuffer.toString();
    }

    public synchronized void loadLocalIdentity(InputStream inputStream, InputStream inputStream2, char[] cArray) {
        this.socketFactory = null;
        try {
            SSLContextWrapper sSLContextWrapper = SSLSetup.getSSLContext();
            this.clientCertChain = SSLCertUtility.inputCertificateChain(sSLContextWrapper, inputStream);
            this.clientPrivateKey = sSLContextWrapper.inputPrivateKey(inputStream2, cArray);
        }
        catch (SocketException socketException) {
            SSLSetup.info(socketException, "Problem getting SSLContext");
        }
        catch (KeyManagementException keyManagementException) {
            SSLSetup.info(keyManagementException, "Problem reading certificate/key");
        }
        catch (IOException iOException) {
            SSLSetup.info(iOException, "Problem reading certificate/key");
        }
    }

    public synchronized void loadLocalIdentity(Certificate[] certificateArray, PrivateKey privateKey) {
        this.socketFactory = null;
        try {
            this.clientCertChain = SSLCertUtility.toJavaX5092(certificateArray);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Cannot convert to X509 certificates\n" + exception.getMessage());
        }
        this.clientPrivateKey = privateKey;
    }

    public X509Certificate[] getClientLocalIdentityCert() {
        return this.clientCertChain;
    }

    public PrivateKey getClientLocalIdentityKey() {
        return this.clientPrivateKey;
    }

    public boolean isClientCertAvailable() {
        return this.clientCertCloner != null && this.clientCertCloner.size() > 0;
    }

    public boolean isLocalIdentitySet() {
        return this.clientCertChain != null && this.clientCertChain.length > 0;
    }
}

