/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.SSL;

import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import weblogic.security.SSL.HostnameVerifier;
import weblogic.security.SSL.HostnameVerifierJSSE;
import weblogic.security.SSL.SSLClientInfo;
import weblogic.security.SSL.SSLNioSocketFactory;
import weblogic.security.SSL.SSLSocketFactory;
import weblogic.security.SSL.TrustManager;
import weblogic.security.SSL.TrustManagerJSSE;

public final class SSLContext {
    private SSLClientInfo clientInfo;
    private String protocol;

    public static SSLContext getInstance(String string) {
        return new SSLContext(string);
    }

    public SSLContext(String string) {
        this.protocol = string;
    }

    public SSLContext() {
        this.protocol = "https";
    }

    public void setTrustManager(TrustManager trustManager) {
        this.getClientInfo().setTrustManager(trustManager);
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.getClientInfo().setHostnameVerifier(hostnameVerifier);
    }

    public void setTrustManagerJSSE(TrustManagerJSSE trustManagerJSSE) {
        if (trustManagerJSSE != null) {
            this.getClientInfo().setTrustManagerJSSE(trustManagerJSSE);
        }
    }

    public void setHostnameVerifierJSSE(HostnameVerifierJSSE hostnameVerifierJSSE) {
        if (hostnameVerifierJSSE != null) {
            this.getClientInfo().setHostnameVerifierJSSE(hostnameVerifierJSSE);
        }
    }

    public void loadLocalIdentity(InputStream[] inputStreamArray) {
        if (inputStreamArray != null) {
            this.getClientInfo().setSSLClientCertificate(inputStreamArray);
        }
    }

    public void loadLocalIdentity(InputStream[] inputStreamArray, String string) {
        if (inputStreamArray != null) {
            this.getClientInfo().setSSLClientCertificate(inputStreamArray);
            this.getClientInfo().setSSLClientKeyPassword(string);
        }
    }

    public void loadLocalIdentity(Certificate[] certificateArray, PrivateKey privateKey) {
        if (certificateArray != null && privateKey != null) {
            this.getClientInfo().loadLocalIdentity(certificateArray, privateKey);
        }
    }

    public SSLSocketFactory getSocketFactoryJSSE() {
        return SSLSocketFactory.getJSSE(this.clientInfo);
    }

    public SSLSocketFactory getSocketFactory() {
        return SSLSocketFactory.getInstance(this.clientInfo);
    }

    public SSLSocketFactory getNioSocketFactory() {
        return SSLNioSocketFactory.getInstance(this.clientInfo);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getProvider() {
        return "weblogic.net";
    }

    protected SSLClientInfo getSSLClientInfo() {
        return this.clientInfo;
    }

    protected void setSSLClientInfo(SSLClientInfo sSLClientInfo) {
        this.clientInfo = sSLClientInfo;
    }

    private SSLClientInfo getClientInfo() {
        if (this.clientInfo == null) {
            this.clientInfo = new SSLClientInfo();
        }
        return this.clientInfo;
    }
}

