/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.SSL;

import java.util.ArrayList;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSLEnabledProtocolVersions {
    private static final String SSLv2Hello = "SSLv2Hello";

    public static int getSSLContextDelegateProtocolVersions(String string, LogListener logListener) {
        ProtocolVersion protocolVersion;
        if (null != logListener && logListener.isDebugEnabled()) {
            logListener.debug("supported protocol version modes: V2HELLO_SSL3_TLS1, TLS1_ONLY", null);
        }
        SSLEnabledProtocolVersions.debug_givenMinProtocolVersion(string, logListener);
        if (null == string) {
            throw new NullPointerException("Unexpected null minimumProtocolVersion.");
        }
        if ("".equals(string)) {
            if (null != logListener) {
                logListener.logUnsupportedMinimumProtocolVersion(string, SSLv2Hello);
            }
            SSLEnabledProtocolVersions.debug_selectedProtocolMode(logListener, "V2HELLO_SSL3_TLS1");
            return 3;
        }
        try {
            protocolVersion = new ProtocolVersion(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            SSLEnabledProtocolVersions.debug_unableToInstantiateProtocolVersion(string, "minimum", logListener, illegalArgumentException);
            if (null != logListener) {
                logListener.logUnsupportedMinimumProtocolVersion(string, SSLv2Hello);
            }
            SSLEnabledProtocolVersions.debug_selectedProtocolMode(logListener, "V2HELLO_SSL3_TLS1");
            return 3;
        }
        if (protocolVersion.greaterThan(ProtocolVersion.SSLV3)) {
            if (protocolVersion.greaterThan(ProtocolVersion.TLSV1_0) && null != logListener) {
                logListener.logUnsupportedMinimumProtocolVersion(string, ProtocolVersion.TLSV1_0.toString());
            }
            SSLEnabledProtocolVersions.debug_selectedProtocolMode(logListener, "TLS1_ONLY");
            return 0;
        }
        if (null != logListener) {
            logListener.logUnsupportedMinimumProtocolVersion(string, SSLv2Hello);
        }
        SSLEnabledProtocolVersions.debug_selectedProtocolMode(logListener, "V2HELLO_SSL3_TLS1");
        return 3;
    }

    public static String[] getJSSEProtocolVersions(String string, String[] stringArray, LogListener logListener) throws IllegalArgumentException {
        ProtocolVersion protocolVersion;
        if (null != logListener && logListener.isDebugEnabled()) {
            logListener.debug("supportedProtocolVersions=" + SSLEnabledProtocolVersions.toString(stringArray), null);
        }
        if (null == stringArray || 0 == stringArray.length) {
            throw new IllegalArgumentException("No supported SSL protocol versions.");
        }
        SSLEnabledProtocolVersions.debug_givenMinProtocolVersion(string, logListener);
        if (null == string) {
            throw new NullPointerException("Unexpected null minimumProtocolVersion.");
        }
        boolean bl = false;
        if ("".equals(string)) {
            bl = true;
            protocolVersion = ProtocolVersion.SSLV3;
        } else {
            try {
                protocolVersion = new ProtocolVersion(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                SSLEnabledProtocolVersions.debug_unableToInstantiateProtocolVersion(string, "minimum", logListener, illegalArgumentException);
                bl = true;
                protocolVersion = ProtocolVersion.SSLV3;
            }
        }
        ProtocolVersion protocolVersion2 = null;
        ProtocolVersion protocolVersion3 = null;
        ProtocolVersion protocolVersion4 = null;
        ArrayList<String> arrayList = new ArrayList<String>(3);
        for (String string2 : stringArray) {
            ProtocolVersion protocolVersion5;
            if (null == string2) continue;
            try {
                protocolVersion5 = new ProtocolVersion(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                SSLEnabledProtocolVersions.debug_unableToInstantiateProtocolVersion(string2, "provider-supported", logListener, illegalArgumentException);
                continue;
            }
            if (null == protocolVersion4) {
                if (protocolVersion5.equals(protocolVersion)) {
                    protocolVersion4 = protocolVersion5;
                    SSLEnabledProtocolVersions.addIfNotPresent(arrayList, protocolVersion5);
                    continue;
                }
                if (protocolVersion5.lessThan(protocolVersion)) {
                    if (null == protocolVersion2) {
                        protocolVersion2 = protocolVersion5;
                        continue;
                    }
                    if (!protocolVersion5.greaterThan(protocolVersion2)) continue;
                    protocolVersion2 = protocolVersion5;
                    continue;
                }
                if (null == protocolVersion3) {
                    protocolVersion3 = protocolVersion5;
                } else if (protocolVersion5.lessThan(protocolVersion3)) {
                    protocolVersion3 = protocolVersion5;
                }
                SSLEnabledProtocolVersions.addIfNotPresent(arrayList, protocolVersion5);
                continue;
            }
            if (!protocolVersion5.greaterThan(protocolVersion)) continue;
            SSLEnabledProtocolVersions.addIfNotPresent(arrayList, protocolVersion5);
        }
        if (null == protocolVersion4) {
            if (null != protocolVersion2) {
                if (null != logListener) {
                    logListener.logUnsupportedMinimumProtocolVersion(string, protocolVersion2.toString());
                }
                SSLEnabledProtocolVersions.addIfNotPresent(arrayList, protocolVersion2);
            } else if (null == protocolVersion3) {
                if (null != logListener && logListener.isDebugEnabled()) {
                    logListener.debug("nextHigherThanMin unexpectedly null. ", null);
                }
            } else if (null != logListener) {
                logListener.logUnsupportedMinimumProtocolVersion(string, protocolVersion3.toString());
            }
        } else if (bl && null != logListener) {
            logListener.logUnsupportedMinimumProtocolVersion(string, protocolVersion4.toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static void addIfNotPresent(ArrayList<String> arrayList, ProtocolVersion protocolVersion) {
        String string = protocolVersion.toString();
        if (!arrayList.contains(string)) {
            arrayList.add(string);
        }
    }

    static String toString(String[] stringArray) {
        if (null == stringArray) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder(stringArray.length * 5);
        for (String string : stringArray) {
            if (null == string) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private static void debug_selectedProtocolMode(LogListener logListener, String string) {
        if (null != logListener && logListener.isDebugEnabled()) {
            logListener.debug("selected protocol version mode: " + string, null);
        }
    }

    private static void debug_givenMinProtocolVersion(String string, LogListener logListener) {
        if (null != logListener && logListener.isDebugEnabled()) {
            logListener.debug("given minimumProtocolVersion=" + string, null);
        }
    }

    private static void debug_unableToInstantiateProtocolVersion(String string, String string2, LogListener logListener, IllegalArgumentException illegalArgumentException) {
        if (null != logListener && logListener.isDebugEnabled()) {
            logListener.debug("Unable to instantiate ProtocolVersion for " + string2 + " protocol version " + string + ": " + illegalArgumentException.getMessage(), null);
        }
    }

    static interface LogListener {
        public boolean isDebugEnabled();

        public void debug(String var1, Throwable var2);

        public void logUnsupportedMinimumProtocolVersion(String var1, String var2);
    }

    static class ProtocolVersion {
        public static final ProtocolVersion SSLV3 = new ProtocolVersion("SSLv3");
        public static final ProtocolVersion TLSV1_0 = new ProtocolVersion("TLSv1.0");
        private static final byte SSLV3_ORDINAL = 0;
        private static final byte TLS_MAJOR_VERSION_ORDINAL_MULTIPLIER = 10;
        private final int ordinal;
        private final String originalString;

        ProtocolVersion(String string) {
            if (null == string) {
                throw new IllegalArgumentException("Null input string.");
            }
            this.originalString = string;
            String string2 = string.toLowerCase(Locale.US).trim();
            if (string2.equals("sslv3")) {
                this.ordinal = 0;
            } else if (string2.startsWith("tlsv")) {
                String string3 = string2.substring(4);
                if (string3.equals("1")) {
                    this.ordinal = 10;
                } else {
                    byte by;
                    byte by2;
                    if (string3.length() < 3) {
                        throw new IllegalArgumentException("Bad prefix: " + string);
                    }
                    int n = string3.indexOf(46);
                    if (-1 == n) {
                        throw new IllegalArgumentException("Missing dot: " + string);
                    }
                    String string4 = string3.substring(0, n);
                    if (string4.length() != 1) {
                        throw new IllegalArgumentException("Only 1 digit major version supported: " + string);
                    }
                    try {
                        by2 = Byte.valueOf(string4, 10);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException("Major version not a number: " + string);
                    }
                    if (by2 < 1 || by2 > 9) {
                        throw new IllegalArgumentException("Major version range 1-9: " + string);
                    }
                    String string5 = string3.substring(n + 1);
                    if (string5.length() != 1) {
                        throw new IllegalArgumentException("Only 1 digit minor version supported: " + string);
                    }
                    try {
                        by = Byte.valueOf(string5, 10);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException("Minor version not a number: " + string);
                    }
                    if (by < 0 || by > 9) {
                        throw new IllegalArgumentException("Minor version range 0-9: " + string);
                    }
                    this.ordinal = by2 * 10 + by;
                }
            } else {
                throw new IllegalArgumentException("Unknown protocol: " + string);
            }
        }

        public String toString() {
            return this.originalString;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ProtocolVersion protocolVersion = (ProtocolVersion)object;
            return this.ordinal == protocolVersion.ordinal;
        }

        public int hashCode() {
            return this.ordinal;
        }

        boolean lessThan(ProtocolVersion protocolVersion) {
            if (protocolVersion == null) {
                throw new IllegalArgumentException("Unexpected null ProtocolVersion.");
            }
            return this.ordinal < protocolVersion.ordinal;
        }

        boolean greaterThan(ProtocolVersion protocolVersion) {
            if (protocolVersion == null) {
                throw new IllegalArgumentException("Unexpected null ProtocolVersion.");
            }
            return this.ordinal > protocolVersion.ordinal;
        }
    }
}

