/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.SSL;

import java.net.SocketException;
import javax.net.SocketFactory;
import weblogic.security.SSL.SSLClientInfo;
import weblogic.security.SSL.SSLSocketFactory;
import weblogic.security.utils.SSLSetup;

public class SSLNioSocketFactory
extends SSLSocketFactory {
    public SSLNioSocketFactory() {
    }

    private SSLNioSocketFactory(SSLClientInfo sSLClientInfo) {
        this.setSSLClientInfo(sSLClientInfo);
    }

    protected SSLNioSocketFactory(javax.net.ssl.SSLSocketFactory sSLSocketFactory) {
        super(sSLSocketFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SocketFactory getDefault() {
        if (defFactory != null) return defFactory;
        Class<SSLNioSocketFactory> clazz = SSLNioSocketFactory.class;
        synchronized (SSLNioSocketFactory.class) {
            if (defFactory != null) return defFactory;
            defFactory = new SSLNioSocketFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return defFactory;
        }
    }

    public static SSLSocketFactory getInstance(SSLClientInfo sSLClientInfo) {
        return new SSLNioSocketFactory(sSLClientInfo);
    }

    public static SSLSocketFactory getJSSE(SSLClientInfo sSLClientInfo) {
        return new SSLNioSocketFactory(sSLClientInfo);
    }

    public void setSSLClientInfo(SSLClientInfo sSLClientInfo) {
        try {
            if (sSLClientInfo != null && !sSLClientInfo.isNioSet()) {
                sSLClientInfo.setNio(true);
            }
            this.jsseFactory = sSLClientInfo == null ? SSLSetup.getSSLContext(sSLClientInfo).getSSLNioSocketFactory() : sSLClientInfo.getSSLSocketFactory();
        }
        catch (SocketException socketException) {
            SSLSetup.debug(3, socketException, "Failed to create context");
            throw new RuntimeException("Failed to update factory: " + socketException.getMessage());
        }
    }
}

