/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.SSL;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.net.SocketFactory;
import weblogic.security.SSL.SSLClientInfo;
import weblogic.security.utils.SSLSetup;
import weblogic.socket.SocketMuxer;
import weblogic.socket.WeblogicSocketFactory;

public class SSLSocketFactory
extends WeblogicSocketFactory {
    protected static SocketFactory defFactory = null;
    protected javax.net.ssl.SSLSocketFactory jsseFactory = null;

    public SSLSocketFactory() {
        this((SSLClientInfo)null);
    }

    private SSLSocketFactory(SSLClientInfo sSLClientInfo) {
        this.setSSLClientInfo(sSLClientInfo);
    }

    protected SSLSocketFactory(javax.net.ssl.SSLSocketFactory sSLSocketFactory) {
        this.jsseFactory = sSLSocketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SocketFactory getDefault() {
        if (defFactory != null) return defFactory;
        Class<SSLSocketFactory> clazz = SSLSocketFactory.class;
        synchronized (SSLSocketFactory.class) {
            if (defFactory != null) return defFactory;
            defFactory = new SSLSocketFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return defFactory;
        }
    }

    public static SSLSocketFactory getInstance(SSLClientInfo sSLClientInfo) {
        return new SSLSocketFactory(sSLClientInfo);
    }

    public static synchronized SocketFactory getDefaultJSSE() {
        if (defFactory == null) {
            defFactory = SSLSocketFactory.getJSSE(null);
        }
        return defFactory;
    }

    public static SSLSocketFactory getJSSE(SSLClientInfo sSLClientInfo) {
        return new SSLSocketFactory(sSLClientInfo);
    }

    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws UnknownHostException, IOException {
        return this.jsseFactory.createSocket(socket, string, n, bl);
    }

    public Socket createSocket(String string, int n) throws UnknownHostException, IOException {
        return this.jsseFactory.createSocket(string, n);
    }

    public Socket createSocket(InetAddress inetAddress, int n) throws UnknownHostException, IOException {
        return this.jsseFactory.createSocket(inetAddress, n);
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws UnknownHostException, IOException {
        return this.jsseFactory.createSocket(string, n, inetAddress, n2);
    }

    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws UnknownHostException, IOException {
        return this.jsseFactory.createSocket(inetAddress, n, inetAddress2, n2);
    }

    public Socket createSocket(InetAddress inetAddress, int n, int n2) throws IOException {
        Socket socket = SocketMuxer.getMuxer().newSocket(inetAddress, n, n2);
        return this.createSocket(socket, inetAddress.getHostName(), n, true);
    }

    public String[] getDefaultCipherSuites() {
        return this.jsseFactory.getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        return this.jsseFactory.getSupportedCipherSuites();
    }

    public void setSSLClientInfo(SSLClientInfo sSLClientInfo) {
        try {
            this.jsseFactory = sSLClientInfo == null ? SSLSetup.getSSLContext(sSLClientInfo).getSSLSocketFactory() : sSLClientInfo.getSSLSocketFactory();
        }
        catch (SocketException socketException) {
            SSLSetup.debug(3, socketException, "Failed to create context");
            throw new RuntimeException("Failed to update factory: " + socketException.getMessage());
        }
    }
}

