/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.SSL;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.cert.CertificateException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import weblogic.management.configuration.ConfigurationException;
import weblogic.security.SSL.SSLSocketFactory;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.utils.SSLContextManager;
import weblogic.security.utils.SSLIOContextTable;

public class ServerSSLSocketFactory
extends SSLSocketFactory {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public ServerSSLSocketFactory() throws CertificateException, ConfigurationException {
        super(SSLContextManager.getDefaultSSLSocketFactory(SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId)));
    }

    public static SocketFactory getDefault() {
        try {
            return new ServerSSLSocketFactory();
        }
        catch (CertificateException certificateException) {
            throw new RuntimeException("Failed to initialize ServerSSLSocketFactory", certificateException);
        }
        catch (ConfigurationException configurationException) {
            throw new RuntimeException("Failed to initialize ServerSSLSocketFactory", configurationException);
        }
    }

    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws UnknownHostException, IOException {
        SSLSocket sSLSocket = (SSLSocket)super.createSocket(socket, string, n, bl);
        SSLIOContextTable.removeContext(sSLSocket);
        return sSLSocket;
    }

    public Socket createSocket(String string, int n) throws UnknownHostException, IOException {
        SSLSocket sSLSocket = (SSLSocket)super.createSocket(string, n);
        SSLIOContextTable.removeContext(sSLSocket);
        return sSLSocket;
    }

    public Socket createSocket(InetAddress inetAddress, int n) throws UnknownHostException, IOException {
        SSLSocket sSLSocket = (SSLSocket)super.createSocket(inetAddress, n);
        SSLIOContextTable.removeContext(sSLSocket);
        return sSLSocket;
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws UnknownHostException, IOException {
        SSLSocket sSLSocket = (SSLSocket)super.createSocket(string, n, inetAddress, n2);
        SSLIOContextTable.removeContext(sSLSocket);
        return sSLSocket;
    }

    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws UnknownHostException, IOException {
        SSLSocket sSLSocket = (SSLSocket)super.createSocket(inetAddress, n, inetAddress2, n2);
        SSLIOContextTable.removeContext(sSLSocket);
        return sSLSocket;
    }
}

