/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.SSL;

import com.bea.sslplus.SSLNioSocket;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.security.InvalidParameterException;
import javax.net.ssl.SSLSocket;
import weblogic.security.SSL.WLSSSLNioSocket;

public class WLSCmnChannel {
    boolean isNio;
    private SocketChannel sockChan;
    private WLSSSLNioSocket nioSock;
    private Socket OrgSock;

    public WLSCmnChannel(Socket socket) {
        if (socket == null) {
            throw new InvalidParameterException("The passed in SocketChannel instance is null");
        }
        if (socket instanceof SSLNioSocket) {
            this.isNio = true;
            this.nioSock = (WLSSSLNioSocket)((Object)socket);
        } else if (socket instanceof SSLSocket) {
            this.isNio = false;
            this.sockChan = socket.getChannel();
        } else if (socket instanceof Socket) {
            this.isNio = false;
            this.sockChan = socket.getChannel();
        } else {
            throw new InvalidParameterException("The passed in SocketChannel is not a SSL socket");
        }
        this.OrgSock = socket;
    }

    public WLSCmnChannel(WLSSSLNioSocket wLSSSLNioSocket) {
        this((Socket)((Object)wLSSSLNioSocket));
    }

    public SelectableChannel getSelectableChannel() {
        if (this.isNio) {
            return this.nioSock.getSelectableChannel();
        }
        return this.sockChan;
    }

    public int write(ByteBuffer byteBuffer) throws IOException {
        if (this.isNio) {
            return this.nioSock.getWritableByteChannel().write(byteBuffer);
        }
        return this.sockChan.write(byteBuffer);
    }

    public long write(ByteBuffer[] byteBufferArray) throws IOException {
        if (this.isNio) {
            throw new UnsupportedOperationException("Not supported for the non-blocking SSL mode, use the other write method, write(ByteBuffer src)");
        }
        return this.sockChan.write(byteBufferArray);
    }

    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        if (this.isNio) {
            throw new UnsupportedOperationException("Not supported for the non-blocking SSL mode, use the other write method, write(ByteBuffer src)");
        }
        return this.sockChan.write(byteBufferArray, n, n2);
    }

    public int read(ByteBuffer byteBuffer) throws IOException {
        if (this.isNio) {
            return this.nioSock.getReadableByteChannel().read(byteBuffer);
        }
        return this.sockChan.read(byteBuffer);
    }

    public final long read(ByteBuffer[] byteBufferArray) throws IOException {
        if (this.isNio) {
            throw new UnsupportedOperationException("Not supported for the non-blocking SSL mode, use the alternative read method, read(ByteBuffer dst)");
        }
        return this.sockChan.read(byteBufferArray, 0, byteBufferArray.length);
    }

    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        if (this.isNio) {
            throw new UnsupportedOperationException("Not supported for the non-blocking SSL mode, use the alternative read method, read(ByteBuffer dst)");
        }
        return this.sockChan.read(byteBufferArray, n, n2);
    }

    public void close() throws IOException {
        if (this.isNio) {
            this.OrgSock.close();
        } else {
            this.sockChan.close();
        }
    }
}

