/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.SSL.jsseadapter;

import java.io.IOException;
import java.math.BigInteger;
import weblogic.security.SSL.jsseadapter.DERDecoder;

class ASN1Object {
    protected int type;
    protected int length;
    protected byte[] value;
    protected int tag;

    public ASN1Object(int n, int n2, byte[] byArray) {
        this.tag = n;
        this.length = n2;
        this.value = byArray;
        this.type = n % 32;
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getValue() {
        return this.value;
    }

    public int getType() {
        return this.type;
    }

    public boolean isConstructed() {
        return (this.tag & 0x20) == 32;
    }

    public DERDecoder getDecoder() {
        DERDecoder dERDecoder = null;
        if (this.isConstructed()) {
            dERDecoder = new DERDecoder(this.value);
        }
        return dERDecoder;
    }

    public BigInteger getBigInteger() {
        BigInteger bigInteger = null;
        if (this.type == 2) {
            bigInteger = new BigInteger(this.value);
        }
        return bigInteger;
    }

    public String getString() throws IOException {
        String string;
        switch (this.type) {
            case 12: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: {
                string = "UTF-8";
                break;
            }
            case 30: {
                string = "UTF-16BE";
                break;
            }
            case 28: {
                throw new IOException("Universal string not supported.");
            }
            default: {
                throw new IOException("Object not recognized as string.");
            }
        }
        return new String(this.value, string);
    }
}

