/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.SSL.jsseadapter;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import weblogic.security.SSL.jsseadapter.ASN1Object;

class DERDecoder {
    static final int UNIVERSAL = 0;
    static final int APPLICATION = 64;
    static final int PRIVATE = 192;
    static final int CONTEXT_SPECIFIC = 128;
    static final int TYPE_CONSTRUCTED = 32;
    static final int BOOLEAN = 1;
    static final int INTEGER = 2;
    static final int BIT_STRING = 3;
    static final int OCTET_STRING = 4;
    static final int SEQUENCE_AND_SEQUENCE_OF = 16;
    static final int SET_AND_SET_OF = 17;
    static final int BMP_STRING = 30;
    static final int IA5_STRING = 22;
    static final int GENERAL_STRING = 27;
    static final int GRAPHIC_STRING = 25;
    static final int NUMERIC_STRING = 18;
    static final int PRINTABLE_STRING = 19;
    static final int TELETEX_STRING = 20;
    static final int UNIVERSAL_STRING = 28;
    static final int UTF8_STRING = 12;
    static final int VIDEO_TEX_STRING = 21;
    static final int VISIBLE_STRING = 26;
    private InputStream is;

    public DERDecoder(InputStream inputStream) {
        this.is = inputStream;
    }

    public DERDecoder(byte[] byArray) {
        this(new ByteArrayInputStream(byArray));
    }

    public ASN1Object readObject() throws IOException {
        int n = this.is.read();
        if (n == -1) {
            throw new IOException("Unexpected end of stream while reading tag");
        }
        int n2 = this.getLength();
        byte[] byArray = new byte[n2];
        int n3 = this.is.read(byArray);
        if (n3 < n2) {
            throw new IOException("The actual number of bytes readObject is less than that of the value.");
        }
        ASN1Object aSN1Object = new ASN1Object(n, n2, byArray);
        return aSN1Object;
    }

    private int getLength() throws IOException {
        int n = this.is.read();
        if (n == -1) {
            throw new IOException("Unexpected end of stream.");
        }
        if ((n & 0xFFFFFF80) == 0) {
            return n;
        }
        int n2 = n & 0x7F;
        if (n >= 255 || n2 > 4) {
            throw new IOException("Unexpected too big length: " + n);
        }
        byte[] byArray = new byte[n2];
        int n3 = this.is.read(byArray);
        if (n3 < n2) {
            throw new IOException("Length shorter than expected: " + n3);
        }
        return new BigInteger(1, byArray).intValue();
    }
}

