/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.SSL.jsseadapter;

import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.math.BigInteger;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.logging.Level;
import weblogic.security.SSL.jsseadapter.JaLogger;

class JSAFE_PrivateKeyWrapper
implements RSAPrivateKey,
RSAPrivateCrtKey {
    private JSAFE_PrivateKey key;
    BigInteger crtCoefficient;
    BigInteger primeExponentP;
    BigInteger primeExponentQ;
    BigInteger primeP;
    BigInteger primeQ;
    BigInteger publicExponent;
    BigInteger modulus;

    public BigInteger getCrtCoefficient() {
        return this.crtCoefficient;
    }

    public BigInteger getPrimeExponentP() {
        return this.primeExponentP;
    }

    public BigInteger getPrimeExponentQ() {
        return this.primeExponentQ;
    }

    public BigInteger getPrimeP() {
        return this.primeP;
    }

    public BigInteger getPrimeQ() {
        return this.primeQ;
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    private byte[] ensurePositiveUnsigned(byte[] byArray) {
        if ((byArray[0] & 0x80) == 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[byArray.length + 1];
        byArray2[0] = 0;
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        return byArray2;
    }

    private void initFromKey() throws JSAFE_UnimplementedException {
        byte[][] byArray = this.key.getKeyData("RSAPrivateKeyCRT");
        this.modulus = new BigInteger(this.ensurePositiveUnsigned(byArray[0]));
        this.publicExponent = new BigInteger(this.ensurePositiveUnsigned(byArray[1]));
        this.primeP = new BigInteger(this.ensurePositiveUnsigned(byArray[3]));
        this.primeQ = new BigInteger(this.ensurePositiveUnsigned(byArray[4]));
        this.primeExponentP = new BigInteger(this.ensurePositiveUnsigned(byArray[5]));
        this.primeExponentQ = new BigInteger(this.ensurePositiveUnsigned(byArray[6]));
        this.crtCoefficient = new BigInteger(this.ensurePositiveUnsigned(byArray[7]));
    }

    public boolean equals(Object object) {
        return object == this || object instanceof JSAFE_PrivateKeyWrapper && this.key.equals((Object)((JSAFE_PrivateKeyWrapper)object).key);
    }

    public int hashCode() {
        int n = this.crtCoefficient.hashCode();
        n = 31 * n + this.primeExponentP.hashCode();
        n = 31 * n + this.primeExponentQ.hashCode();
        n = 31 * n + this.primeP.hashCode();
        n = 31 * n + this.primeQ.hashCode();
        n = 31 * n + this.publicExponent.hashCode();
        n = 31 * n + this.modulus.hashCode();
        return n;
    }

    public JSAFE_PrivateKeyWrapper(byte[] byArray) {
        try {
            this.key = JSAFE_PrivateKey.getInstance((byte[])byArray, (int)0, (String)"Java");
            this.initFromKey();
        }
        catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
            if (JaLogger.isLoggable(Level.SEVERE)) {
                JaLogger.log(Level.SEVERE, JaLogger.Component.SSLCONTEXT, "Error instantiating PrivateKey object: ", jSAFE_UnimplementedException.getMessage());
            }
            throw new IllegalStateException(jSAFE_UnimplementedException.getMessage());
        }
    }

    public JSAFE_PrivateKeyWrapper(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) {
        try {
            this.key = JSAFE_PrivateKey.getInstance((String)"RSA", (String)"Java");
            this.key.setKeyData((byte[][])new byte[][]{bigInteger.toByteArray(), bigInteger2.toByteArray(), bigInteger3.toByteArray(), bigInteger4.toByteArray(), bigInteger5.toByteArray(), bigInteger6.toByteArray(), bigInteger7.toByteArray(), bigInteger8.toByteArray()});
            this.initFromKey();
        }
        catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
            throw new IllegalStateException(jSAFE_UnimplementedException.getMessage());
        }
        catch (JSAFE_InvalidKeyException jSAFE_InvalidKeyException) {
            throw new IllegalStateException(jSAFE_InvalidKeyException.getMessage());
        }
        catch (JSAFE_InvalidParameterException jSAFE_InvalidParameterException) {
            throw new IllegalStateException(jSAFE_InvalidParameterException.getMessage());
        }
    }

    public JSAFE_PrivateKeyWrapper(JSAFE_PrivateKey jSAFE_PrivateKey) {
        this.key = jSAFE_PrivateKey;
        try {
            this.initFromKey();
        }
        catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
            if (JaLogger.isLoggable(Level.SEVERE)) {
                JaLogger.log(Level.SEVERE, JaLogger.Component.SSLCONTEXT, "Error setting PrivateKey object: ", jSAFE_UnimplementedException.getMessage());
            }
            throw new IllegalStateException(jSAFE_UnimplementedException.getMessage());
        }
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getPrivateExponent() {
        byte[][] byArray = this.key.getKeyData();
        return new BigInteger(byArray[1]);
    }

    public JSAFE_PrivateKey getKey() {
        return this.key;
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public byte[] getEncoded() {
        try {
            return this.key.getKeyData("RSAPrivateKeyBER")[0];
        }
        catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
            if (JaLogger.isLoggable(Level.SEVERE)) {
                JaLogger.log(Level.SEVERE, JaLogger.Component.SSLCONTEXT, "Error getting encoded value of the PrivateKey object: ", jSAFE_UnimplementedException.getMessage());
            }
            throw new IllegalStateException();
        }
    }
}

