/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.SSL.jsseadapter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ProtocolException;
import java.net.SocketException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Level;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import weblogic.security.SSL.WLSSSLNioSocket;
import weblogic.security.SSL.WeblogicSSLEngine;
import weblogic.security.SSL.jsseadapter.JaApplicationOutputStream;
import weblogic.security.SSL.jsseadapter.JaApplicationReadableByteChannel;
import weblogic.security.SSL.jsseadapter.JaApplicationWritableByteChannel;
import weblogic.security.SSL.jsseadapter.JaChannelInputStream;
import weblogic.security.SSL.jsseadapter.JaLogger;
import weblogic.security.SSL.jsseadapter.JaSSLContext;
import weblogic.security.SSL.jsseadapter.JaSSLEngineRunner;
import weblogic.security.SSL.jsseadapter.JaSSLParameters;
import weblogic.security.utils.SSLIOContext;
import weblogic.security.utils.SSLIOContextTable;
import weblogic.security.utils.SSLTrustValidator;
import weblogic.security.utils.SSLTruster;

abstract class JaAbstractSSLSocket
extends SSLSocket
implements WLSSSLNioSocket {
    private final JaSSLContext jaSSLContext;
    private SSLIOContext sslIoContext;
    private final JaSSLEngineRunner.Context sslEngineRunnerContext = new JaSSLEngineRunner.Context();
    private final ReadableByteChannel appReadableByteChannel = new JaApplicationReadableByteChannel(this.sslEngineRunnerContext);
    private final WritableByteChannel appWritableByteChannel = new JaApplicationWritableByteChannel(this.sslEngineRunnerContext);
    private final JaChannelInputStream appInStream = new JaChannelInputStream(this.appReadableByteChannel);
    private final OutputStream appOutStream = new JaApplicationOutputStream(this);

    public String[] getSupportedCipherSuites() {
        return this.sslEngineRunnerContext.getSslEngine().getSupportedCipherSuites();
    }

    public String[] getEnabledCipherSuites() {
        return this.sslEngineRunnerContext.getSslEngine().getEnabledCipherSuites();
    }

    public void setEnabledCipherSuites(String[] stringArray) {
        this.sslEngineRunnerContext.getSslEngine().setEnabledCipherSuites(stringArray);
    }

    public String[] getSupportedProtocols() {
        return this.sslEngineRunnerContext.getSslEngine().getSupportedProtocols();
    }

    public String[] getEnabledProtocols() {
        return this.sslEngineRunnerContext.getSslEngine().getEnabledProtocols();
    }

    public void setEnabledProtocols(String[] stringArray) {
        this.sslEngineRunnerContext.getSslEngine().setEnabledProtocols(stringArray);
    }

    public SSLSession getSession() {
        return this.sslEngineRunnerContext.getSslEngine().getSession();
    }

    public void addHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        SSLEngine sSLEngine = this.sslEngineRunnerContext.getSslEngine();
        if (!(sSLEngine instanceof WeblogicSSLEngine)) {
            throw new UnsupportedOperationException("HandshakeCompletedListener is only supported when using WeblogicSSLEngine.");
        }
        ((WeblogicSSLEngine)sSLEngine).addHandshakeCompletedListener(handshakeCompletedListener);
    }

    public void removeHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        SSLEngine sSLEngine = this.sslEngineRunnerContext.getSslEngine();
        if (!(sSLEngine instanceof WeblogicSSLEngine)) {
            throw new UnsupportedOperationException("HandshakeCompletedListener is only supported when using WeblogicSSLEngine.");
        }
        ((WeblogicSSLEngine)sSLEngine).removeHandshakeCompletedListener(handshakeCompletedListener);
    }

    public void startHandshake() throws IOException {
        JaSSLEngineRunner.RunnerResult runnerResult;
        byte[] byArray;
        boolean bl;
        SSLEngine sSLEngine = this.sslEngineRunnerContext.getSslEngine();
        if (SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING == sSLEngine.getHandshakeStatus() || SSLEngineResult.HandshakeStatus.FINISHED == sSLEngine.getHandshakeStatus()) {
            this.sslEngineRunnerContext.getSslEngine().beginHandshake();
        }
        boolean bl2 = bl = null == (byArray = sSLEngine.getSession().getId()) || 0 == byArray.length;
        if (!bl) {
            if (JaLogger.isLoggable(Level.FINEST)) {
                String string = this.getInetAddress().getHostAddress();
                int n = this.getPort();
                JaLogger.log(Level.FINEST, JaLogger.Component.SSLSOCKET, "startHandshake() called for rehandshaking, not blocking on socket to peer {0}:{1}.", string, n);
            }
            return;
        }
        SocketChannel socketChannel = this.getChannel();
        boolean bl3 = null == socketChannel ? true : socketChannel.isBlocking();
        boolean bl4 = false;
        if (null != socketChannel && !socketChannel.isBlocking()) {
            socketChannel.configureBlocking(true);
            bl4 = true;
            if (JaLogger.isLoggable(Level.FINER)) {
                JaLogger.log(Level.FINER, JaLogger.Component.SSLSOCKET, "Socket Channel {0} temporarily changed to blocking.", socketChannel);
            }
        }
        while (JaSSLEngineRunner.RunnerResult.OK != (runnerResult = JaSSLEngineRunner.wrap(this.sslEngineRunnerContext))) {
            if (JaLogger.isLoggable(Level.FINEST)) {
                JaLogger.log(Level.FINEST, JaLogger.Component.SSLSOCKET, "Trying to complete handshake on socket channel {0}, last result={1}.", new Object[]{socketChannel, runnerResult});
            }
            Thread.currentThread();
            Thread.yield();
        }
        if (JaLogger.isLoggable(Level.FINEST)) {
            JaLogger.log(Level.FINEST, JaLogger.Component.SSLSOCKET, "Completed initial handshake on socket channel {0}, last result={1}.", new Object[]{socketChannel, runnerResult});
        }
        if (bl4 && null != socketChannel) {
            socketChannel.configureBlocking(bl3);
            if (JaLogger.isLoggable(Level.FINER)) {
                JaLogger.log(Level.FINER, JaLogger.Component.SSLSOCKET, "Socket Channel {0} restored to blocking mode={1}.", socketChannel, bl3);
            }
        }
    }

    public void setUseClientMode(boolean bl) {
        this.sslEngineRunnerContext.getSslEngine().setUseClientMode(bl);
    }

    public boolean getUseClientMode() {
        return this.sslEngineRunnerContext.getSslEngine().getUseClientMode();
    }

    public void setNeedClientAuth(boolean bl) {
        this.sslEngineRunnerContext.getSslEngine().setNeedClientAuth(bl);
    }

    public boolean getNeedClientAuth() {
        return this.sslEngineRunnerContext.getSslEngine().getNeedClientAuth();
    }

    public void setWantClientAuth(boolean bl) {
        this.sslEngineRunnerContext.getSslEngine().setWantClientAuth(bl);
    }

    public boolean getWantClientAuth() {
        return this.sslEngineRunnerContext.getSslEngine().getWantClientAuth();
    }

    public void setEnableSessionCreation(boolean bl) {
        this.sslEngineRunnerContext.getSslEngine().setEnableSessionCreation(bl);
    }

    public boolean getEnableSessionCreation() {
        return this.sslEngineRunnerContext.getSslEngine().getEnableSessionCreation();
    }

    public InputStream getInputStream() throws IOException {
        return this.appInStream;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.appOutStream;
    }

    public void close() throws IOException {
        JaSSLEngineRunner.close(this.sslEngineRunnerContext, false);
        if (this.sslIoContext != null) {
            SSLIOContextTable.removeContext(this.sslIoContext);
        }
        super.close();
    }

    public void shutdownInput() throws IOException {
        try {
            JaSSLEngineRunner.close(this.sslEngineRunnerContext, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.shutdownInput();
    }

    public void shutdownOutput() throws IOException {
        try {
            JaSSLEngineRunner.closeOutbound(this.sslEngineRunnerContext);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.shutdownOutput();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public String toString() {
        return super.toString();
    }

    public ReadableByteChannel getReadableByteChannel() {
        return this.appReadableByteChannel;
    }

    public WritableByteChannel getWritableByteChannel() {
        return this.appWritableByteChannel;
    }

    public SelectableChannel getSelectableChannel() {
        return this.getChannel();
    }

    JaSSLEngineRunner.Context getSslEngineRunnerContext() {
        return this.sslEngineRunnerContext;
    }

    WeblogicSSLEngine createSslEngine(JaSSLParameters jaSSLParameters) throws SSLException {
        String string = this.getInetAddress().getHostAddress();
        int n = this.getPort();
        WeblogicSSLEngine weblogicSSLEngine = this.jaSSLContext.createSSLEngine(string, n);
        jaSSLParameters.setUnencryptedNullCipherEnabled(this.jaSSLContext.isUnencryptedNullCipherEnabled());
        jaSSLParameters.configureSslEngine(weblogicSSLEngine);
        SSLTruster sSLTruster = this.jaSSLContext.getTrustManager();
        if (sSLTruster instanceof SSLTrustValidator) {
            SSLTrustValidator sSLTrustValidator = (SSLTrustValidator)sSLTruster;
            weblogicSSLEngine.setNeedClientAuth(sSLTrustValidator.isPeerCertsRequired());
        }
        return weblogicSSLEngine;
    }

    void init(SocketChannel socketChannel, JaSSLParameters jaSSLParameters) throws IOException {
        if (null == socketChannel) {
            throw new IllegalArgumentException("Expected non-null SocketChannel.");
        }
        this.appInStream.setSelectableChannel(socketChannel);
        JaChannelInputStream jaChannelInputStream = new JaChannelInputStream(socketChannel);
        jaChannelInputStream.setSelectableChannel(socketChannel);
        this.sslIoContext = new SSLIOContext(jaChannelInputStream, socketChannel.socket().getOutputStream(), this);
        InputStream inputStream = this.sslIoContext.getMuxerIS();
        SSLIOContextTable.addContext(this.sslIoContext);
        ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream);
        SocketChannel socketChannel2 = socketChannel;
        if (JaLogger.isLoggable(Level.FINEST)) {
            JaLogger.log(Level.FINEST, JaLogger.Component.SSLSOCKET, "{0}[{1}] Accessing network using SocketChannel.", this.getClass().getName(), this.hashCode());
        }
        this.init(readableByteChannel, socketChannel2, jaSSLParameters);
    }

    void init(JaSSLParameters jaSSLParameters) throws IOException {
        InputStream inputStream = super.getInputStream();
        OutputStream outputStream = super.getOutputStream();
        this.init(jaSSLParameters, inputStream, outputStream);
    }

    void init(JaSSLParameters jaSSLParameters, InputStream inputStream, OutputStream outputStream) throws IOException {
        this.sslIoContext = new SSLIOContext(inputStream, outputStream, this);
        InputStream inputStream2 = this.sslIoContext.getMuxerIS();
        SSLIOContextTable.addContext(this.sslIoContext);
        ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream2);
        WritableByteChannel writableByteChannel = Channels.newChannel(outputStream);
        if (JaLogger.isLoggable(Level.FINEST)) {
            JaLogger.log(Level.FINEST, JaLogger.Component.SSLSOCKET, "{0}[{1}] Accessing network using InputStream and OutputStream.", this.getClass().getName(), this.hashCode());
        }
        this.init(readableByteChannel, writableByteChannel, jaSSLParameters);
    }

    void init(ReadableByteChannel readableByteChannel, WritableByteChannel writableByteChannel, JaSSLParameters jaSSLParameters) throws IOException {
        if (null == jaSSLParameters) {
            throw new IllegalArgumentException("Expected non-null JaSSLParameters.");
        }
        try {
            this.setTcpNoDelay(true);
        }
        catch (SocketException socketException) {
            throw new ProtocolException(socketException.getMessage());
        }
        WeblogicSSLEngine weblogicSSLEngine = this.createSslEngine(jaSSLParameters);
        weblogicSSLEngine.setAssociatedSSLSocket(this);
        this.sslEngineRunnerContext.init(weblogicSSLEngine, readableByteChannel, writableByteChannel, this.sslIoContext);
    }

    JaAbstractSSLSocket(JaSSLContext jaSSLContext) throws IOException {
        if (null == jaSSLContext) {
            throw new IllegalArgumentException("Expected non-null JaSSLContext.");
        }
        this.jaSSLContext = jaSSLContext;
    }

    JaAbstractSSLSocket(JaSSLContext jaSSLContext, String string, int n) throws IOException {
        super(string, n);
        if (null == jaSSLContext) {
            throw new IllegalArgumentException("Expected non-null JaSSLContext.");
        }
        this.jaSSLContext = jaSSLContext;
    }

    JaAbstractSSLSocket(JaSSLContext jaSSLContext, InetAddress inetAddress, int n) throws IOException {
        super(inetAddress, n);
        if (null == jaSSLContext) {
            throw new IllegalArgumentException("Expected non-null JaSSLContext.");
        }
        this.jaSSLContext = jaSSLContext;
    }

    JaAbstractSSLSocket(JaSSLContext jaSSLContext, String string, int n, InetAddress inetAddress, int n2) throws IOException {
        super(string, n, inetAddress, n2);
        if (null == jaSSLContext) {
            throw new IllegalArgumentException("Expected non-null JaSSLContext.");
        }
        this.jaSSLContext = jaSSLContext;
    }

    JaAbstractSSLSocket(JaSSLContext jaSSLContext, InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        super(inetAddress, n, inetAddress2, n2);
        if (null == jaSSLContext) {
            throw new IllegalArgumentException("Expected non-null JaSSLContext.");
        }
        this.jaSSLContext = jaSSLContext;
    }
}

