/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.SSL.jsseadapter;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.text.MessageFormat;
import java.util.logging.Level;
import weblogic.security.SSL.jsseadapter.JaAbstractSSLSocket;
import weblogic.security.SSL.jsseadapter.JaLogger;
import weblogic.security.SSL.jsseadapter.JaSSLEngineSynchronizer;

final class JaApplicationOutputStream
extends OutputStream {
    private final JaAbstractSSLSocket socket;

    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (null == byArray) {
            throw new NullPointerException("Expected non-null array.");
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            String string = MessageFormat.format("Offset={0}, Length={1}, ArrayLength={2}", n, n2, byArray.length);
            throw new IndexOutOfBoundsException(string);
        }
        if (JaLogger.isLoggable(Level.FINEST)) {
            JaLogger.log(Level.FINEST, JaLogger.Component.SSLSOCKET, "{0}[{1}]: Given {2} bytes to write.", this.getClass().getName(), this.hashCode(), n2);
        }
        if (0 == n2) {
            return;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
        this.socket.getSslEngineRunnerContext().getSync().lock(JaSSLEngineSynchronizer.LockState.OUTBOUND);
        try {
            int n4;
            WritableByteChannel writableByteChannel = this.socket.getWritableByteChannel();
            n3 = n4 = writableByteChannel.write(byteBuffer);
            if (byteBuffer.hasRemaining()) {
                if (JaLogger.isLoggable(Level.FINEST)) {
                    JaLogger.log(Level.FINEST, JaLogger.Component.SSLSOCKET, "{0}[{1}]: Last write(1): Written bytes={2}, Remaining bytes={3}.", this.getClass().getName(), this.hashCode(), n4, byteBuffer.remaining());
                }
                while (byteBuffer.hasRemaining()) {
                    Thread.currentThread();
                    Thread.yield();
                    n4 = writableByteChannel.write(byteBuffer);
                    n3 += n4;
                    if (!JaLogger.isLoggable(Level.FINEST)) continue;
                    JaLogger.log(Level.FINEST, JaLogger.Component.SSLSOCKET, "{0}[{1}]: Last write(2): Written bytes={2}, Remaining bytes={3}.", this.getClass().getName(), this.hashCode(), n4, byteBuffer.remaining());
                }
            }
        }
        finally {
            this.socket.getSslEngineRunnerContext().getSync().unlock();
        }
        if (JaLogger.isLoggable(Level.FINEST)) {
            JaLogger.log(Level.FINEST, JaLogger.Component.SSLSOCKET, "{0}[{1}]: All bytes written: Total written bytes={2}, Remaining bytes={3}", this.getClass().getName(), this.hashCode(), n3, byteBuffer.remaining());
        }
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
        if (JaLogger.isLoggable(Level.FINEST)) {
            JaLogger.log(Level.FINEST, JaLogger.Component.SSLSOCKET, "{0}[{1}]: close() called.", this.getClass().getName(), this.hashCode());
        }
        this.socket.shutdownOutput();
    }

    JaApplicationOutputStream(JaAbstractSSLSocket jaAbstractSSLSocket) {
        if (null == jaAbstractSSLSocket) {
            throw new IllegalArgumentException("Expected non-null JaAbstractSSLSocket.");
        }
        this.socket = jaAbstractSSLSocket;
    }
}

