/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.SSL.jsseadapter;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.logging.Level;
import weblogic.security.SSL.jsseadapter.JaLogger;
import weblogic.security.SSL.jsseadapter.JaSSLEngineRunner;
import weblogic.security.SSL.jsseadapter.JaSSLEngineSynchronizer;

final class JaApplicationReadableByteChannel
implements ReadableByteChannel {
    private final JaSSLEngineRunner.Context sslEngineRunnerContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(ByteBuffer byteBuffer) throws IOException {
        if (null == byteBuffer) {
            throw new IllegalArgumentException("Non-null destination expected.");
        }
        if (byteBuffer.remaining() <= 0) {
            return 0;
        }
        try {
            this.sslEngineRunnerContext.getSync().lock(JaSSLEngineSynchronizer.LockState.INBOUND);
            try {
                int n;
                ByteBuffer byteBuffer2 = this.sslEngineRunnerContext.getBufferAppIn();
                int n2 = JaApplicationReadableByteChannel.calcRemainingToRead(byteBuffer2);
                if (n2 <= 0) {
                    JaSSLEngineRunner.RunnerResult runnerResult = JaSSLEngineRunner.unwrap(this.sslEngineRunnerContext);
                    if (runnerResult == JaSSLEngineRunner.RunnerResult.CLOSED) {
                        int n3 = -1;
                        return n3;
                    }
                    byteBuffer2 = this.sslEngineRunnerContext.getBufferAppIn();
                    n2 = JaApplicationReadableByteChannel.calcRemainingToRead(byteBuffer2);
                }
                int n4 = 0;
                if (n2 > 0) {
                    try {
                        byteBuffer2.flip();
                        n = byteBuffer2.remaining() - byteBuffer.remaining();
                        if (n <= 0) {
                            n4 = byteBuffer2.remaining();
                            byteBuffer.put(byteBuffer2);
                        } else {
                            int n5 = byteBuffer2.limit();
                            byteBuffer2.limit(n5 - n);
                            n4 = byteBuffer2.remaining();
                            byteBuffer.put(byteBuffer2);
                            byteBuffer2.limit(n5);
                        }
                    }
                    finally {
                        byteBuffer2.compact();
                    }
                }
                n = n4;
                return n;
            }
            finally {
                this.sslEngineRunnerContext.getSync().unlock();
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            throw interruptedIOException;
        }
        catch (IOException iOException) {
            try {
                JaSSLEngineRunner.closeOutbound(this.sslEngineRunnerContext);
                throw iOException;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            try {
                JaSSLEngineRunner.closeOutbound(this.sslEngineRunnerContext);
                throw runtimeException;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw runtimeException;
        }
    }

    public void close() throws IOException {
        block3: {
            if (JaLogger.isLoggable(Level.FINEST)) {
                JaLogger.log(Level.FINEST, JaLogger.Component.SSLENGINE, "[{0}] close() called.", this.getClass().getName());
            }
            try {
                JaSSLEngineRunner.RunnerResult runnerResult = JaSSLEngineRunner.closeInbound(this.sslEngineRunnerContext, false);
            }
            catch (Exception exception) {
                if (!JaLogger.isLoggable(Level.FINER)) break block3;
                JaLogger.log(Level.FINER, JaLogger.Component.SSLENGINE, exception, "[{0}] Exception occurred during close().", this.getClass().getName());
            }
        }
    }

    public boolean isOpen() {
        if (JaLogger.isLoggable(Level.FINEST)) {
            JaLogger.log(Level.FINEST, JaLogger.Component.SSLENGINE, "[{0}] isOpen() called.", this.getClass().getName());
        }
        return !JaSSLEngineRunner.isInboundDone(this.sslEngineRunnerContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() throws IOException {
        this.sslEngineRunnerContext.getSync().lock(JaSSLEngineSynchronizer.LockState.INBOUND);
        try {
            ByteBuffer byteBuffer = this.sslEngineRunnerContext.getBufferAppIn();
            int n = JaApplicationReadableByteChannel.calcRemainingToRead(byteBuffer);
            return n;
        }
        finally {
            this.sslEngineRunnerContext.getSync().unlock();
        }
    }

    JaApplicationReadableByteChannel(JaSSLEngineRunner.Context context) {
        if (null == context) {
            throw new IllegalArgumentException("Expected non-null JaSSLEngineRunner.Context.");
        }
        this.sslEngineRunnerContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int calcRemainingToRead(ByteBuffer byteBuffer) {
        int n = 0;
        try {
            byteBuffer.flip();
            n = byteBuffer.remaining();
        }
        finally {
            byteBuffer.compact();
        }
        return n;
    }
}

