/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.SSL.jsseadapter;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Level;
import weblogic.security.SSL.jsseadapter.JaLogger;
import weblogic.security.SSL.jsseadapter.JaSSLEngineRunner;
import weblogic.security.SSL.jsseadapter.JaSSLEngineSynchronizer;

final class JaApplicationWritableByteChannel
implements WritableByteChannel {
    private final JaSSLEngineRunner.Context sslEngineRunnerContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer byteBuffer) throws IOException {
        if (null == byteBuffer) {
            throw new IllegalArgumentException("Non-null source expected.");
        }
        int n = byteBuffer.remaining();
        if (n <= 0) {
            return 0;
        }
        this.sslEngineRunnerContext.getSync().lock(JaSSLEngineSynchronizer.LockState.OUTBOUND);
        try {
            this.sslEngineRunnerContext.setBufferAppOut(byteBuffer);
            try {
                byteBuffer.compact();
                JaSSLEngineRunner.RunnerResult runnerResult = JaSSLEngineRunner.wrap(this.sslEngineRunnerContext);
                if (null != runnerResult && JaSSLEngineRunner.RunnerResult.CLOSED == runnerResult) {
                    if (JaLogger.isLoggable(Level.FINER)) {
                        JaLogger.log(Level.FINER, JaLogger.Component.SSLSOCKET, "{0}[{1}]: Unable to write: SSL channel is closed.", this.getClass().getName(), this.hashCode());
                    }
                    throw new ClosedChannelException();
                }
            }
            finally {
                byteBuffer.flip();
                this.sslEngineRunnerContext.setBufferAppOut(null);
            }
        }
        finally {
            this.sslEngineRunnerContext.getSync().unlock();
        }
        int n2 = n - byteBuffer.remaining();
        return n2;
    }

    public void close() throws IOException {
        block3: {
            if (JaLogger.isLoggable(Level.FINEST)) {
                JaLogger.log(Level.FINEST, JaLogger.Component.SSLENGINE, "[{0}] close() called.", this.getClass().getName());
            }
            try {
                JaSSLEngineRunner.RunnerResult runnerResult = JaSSLEngineRunner.closeOutbound(this.sslEngineRunnerContext);
            }
            catch (Exception exception) {
                if (!JaLogger.isLoggable(Level.FINER)) break block3;
                JaLogger.log(Level.FINER, JaLogger.Component.SSLENGINE, exception, "[{0}] Exception occurred during close().", this.getClass().getName());
            }
        }
    }

    public boolean isOpen() {
        if (JaLogger.isLoggable(Level.FINEST)) {
            JaLogger.log(Level.FINEST, JaLogger.Component.SSLENGINE, "[{0}] isOpen() called.", this.getClass().getName());
        }
        return !JaSSLEngineRunner.isOutboundDone(this.sslEngineRunnerContext);
    }

    JaApplicationWritableByteChannel(JaSSLEngineRunner.Context context) {
        if (null == context) {
            throw new IllegalArgumentException("Expected non-null JaSSLEngineRunner.Context.");
        }
        this.sslEngineRunnerContext = context;
    }
}

