/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.SSL.jsseadapter;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.text.MessageFormat;
import java.util.logging.Level;
import weblogic.security.SSL.jsseadapter.JaApplicationReadableByteChannel;
import weblogic.security.SSL.jsseadapter.JaLogger;

final class JaChannelInputStream
extends InputStream {
    private final ReadableByteChannel readableChannel;
    private AbstractSelectableChannel selectableChannel;
    private Selector selector;
    private final Object selectorLock = new Object();

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray, 0, 1);
        if (n < 0) {
            return -1;
        }
        if (0 == n) {
            throw new IllegalBlockingModeException();
        }
        return byArray[0];
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (null == byArray) {
            throw new NullPointerException("Expected non-null array.");
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            String string = MessageFormat.format("Offset={0}, Length={1}, ArrayLength={2}", n, n2, byArray.length);
            throw new IndexOutOfBoundsException(string);
        }
        if (0 == n2) {
            return 0;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.position(n);
        byteBuffer.limit(n + n2);
        int n3 = this.readableChannel.read(byteBuffer);
        if (JaLogger.isLoggable(Level.FINEST)) {
            JaLogger.log(Level.FINEST, JaLogger.Component.SSLSOCKET, "{0}[{1}]: Given buffer length {2} bytes, actually read {3} bytes", this.getClass().getName(), this.hashCode(), n2, n3);
        }
        return n3;
    }

    public int available() throws IOException {
        InputStream inputStream;
        SocketChannel socketChannel;
        Socket socket;
        if (this.readableChannel instanceof JaApplicationReadableByteChannel) {
            JaApplicationReadableByteChannel jaApplicationReadableByteChannel = (JaApplicationReadableByteChannel)this.readableChannel;
            return jaApplicationReadableByteChannel.available();
        }
        if (this.readableChannel instanceof SocketChannel && null != (socket = (socketChannel = (SocketChannel)this.readableChannel).socket()) && null != (inputStream = socket.getInputStream())) {
            return inputStream.available();
        }
        return 0;
    }

    public void close() throws IOException {
        this.readableChannel.close();
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    JaChannelInputStream(ReadableByteChannel readableByteChannel) {
        if (null == readableByteChannel) {
            throw new IllegalArgumentException("Expected non-null ReadableByteChannel.");
        }
        this.readableChannel = readableByteChannel;
    }

    void setSelectableChannel(AbstractSelectableChannel abstractSelectableChannel) {
        if (null == abstractSelectableChannel) {
            throw new IllegalArgumentException("Expected non-null AbstractSelectableChannel.");
        }
        this.selectableChannel = abstractSelectableChannel;
    }
}

