/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.SSL.jsseadapter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

final class JaCipherSuiteNameMap {
    private static final String SYSPROPNAME_DISABLE_CIPHERSUITE_ALIASES = "weblogic.security.SSL.disableJsseCipherSuiteAliases";
    private static final boolean DISABLE_CIPHERSUITE_ALIASES = Boolean.getBoolean("weblogic.security.SSL.disableJsseCipherSuiteAliases");
    private static final Map<String, String> nameMap_toJsse;
    private static final Map<String, String> nameMap_fromJsse;
    private static final int NAMEMAP_FROMJSSE_SIZE;

    JaCipherSuiteNameMap() {
    }

    static final String[] toJsse(String[] stringArray) {
        if (DISABLE_CIPHERSUITE_ALIASES) {
            return stringArray;
        }
        if (null == stringArray) {
            throw new IllegalArgumentException("Non-null cipherSuiteNames expected.");
        }
        if (0 == stringArray.length) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (String string : stringArray) {
            String string2;
            String string3;
            String string4;
            if (null == string || 0 == (string4 = string.trim()).length() || arrayList.contains(string3 = null == (string2 = nameMap_toJsse.get(string4)) ? string4 : string2)) continue;
            arrayList.add(string3);
        }
        String[] stringArray2 = arrayList.toArray(new String[0]);
        return stringArray2;
    }

    static final String[] fromJsse(String[] stringArray) {
        if (DISABLE_CIPHERSUITE_ALIASES) {
            return stringArray;
        }
        if (null == stringArray) {
            throw new IllegalArgumentException("Non-null jsseCipherSuiteNames expected.");
        }
        if (0 == stringArray.length) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length + NAMEMAP_FROMJSSE_SIZE);
        for (String string : stringArray) {
            String string2;
            String string3;
            if (null == string || 0 == (string3 = string.trim()).length()) continue;
            if (!arrayList.contains(string3)) {
                arrayList.add(string3);
            }
            if (null == (string2 = nameMap_fromJsse.get(string3)) || arrayList.contains(string2)) continue;
            arrayList.add(string2);
        }
        String[] stringArray2 = arrayList.toArray(new String[0]);
        return stringArray2;
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA");
        hashMap.put("TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA");
        hashMap.put("TLS_DHE_DSS_WITH_DES_CBC_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA");
        hashMap.put("TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA");
        hashMap.put("TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA");
        hashMap.put("TLS_DHE_RSA_WITH_DES_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA");
        hashMap.put("TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA", "SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA");
        hashMap.put("TLS_DH_anon_EXPORT_WITH_RC4_40_MD5", "SSL_DH_anon_EXPORT_WITH_RC4_40_MD5");
        hashMap.put("TLS_DH_anon_WITH_3DES_EDE_CBC_SHA", "SSL_DH_anon_WITH_3DES_EDE_CBC_SHA");
        hashMap.put("TLS_DH_anon_WITH_DES_CBC_SHA", "SSL_DH_anon_WITH_DES_CBC_SHA");
        hashMap.put("TLS_DH_anon_WITH_RC4_128_MD5", "SSL_DH_anon_WITH_RC4_128_MD5");
        hashMap.put("TLS_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA");
        hashMap.put("TLS_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_EXPORT_WITH_RC4_40_MD5");
        hashMap.put("TLS_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA");
        hashMap.put("TLS_RSA_WITH_DES_CBC_SHA", "SSL_RSA_WITH_DES_CBC_SHA");
        hashMap.put("TLS_RSA_WITH_RC4_128_MD5", "SSL_RSA_WITH_RC4_128_MD5");
        hashMap.put("TLS_RSA_WITH_RC4_128_SHA", "SSL_RSA_WITH_RC4_128_SHA");
        nameMap_toJsse = Collections.unmodifiableMap(hashMap);
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : nameMap_toJsse.entrySet()) {
            hashMap2.put(entry.getValue(), entry.getKey());
        }
        nameMap_fromJsse = Collections.unmodifiableMap(hashMap2);
        NAMEMAP_FROMJSSE_SIZE = nameMap_fromJsse.size();
    }
}

