/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.SSL.jsseadapter;

import java.text.MessageFormat;
import java.util.logging.Level;
import weblogic.security.utils.SSLSetupLogging;

final class JaLogger {
    private static final String LOGGER_NAME = JaLogger.class.getPackage().getName();

    JaLogger() {
    }

    static boolean isLoggable(Level level) {
        return SSLSetupLogging.isDebugEnabled();
    }

    static void log(Level level, Component component, String string, Object ... objectArray) {
        JaLogger.log(level, component, null, string, objectArray);
    }

    static void log(Level level, Component component, Throwable throwable, String string, Object ... objectArray) {
        if (!JaLogger.isLoggable(level)) {
            return;
        }
        if (null == component) {
            component = Component.UNKNOWN;
        }
        string = null != string ? MessageFormat.format(string, objectArray) : "";
        String string2 = MessageFormat.format("[{0}]{1}: {2}: {3}", new Object[]{Thread.currentThread().toString(), LOGGER_NAME, component, string});
        if (null != throwable) {
            SSLSetupLogging.debug(JaLogger.toSSLSetupLoggingLevel(level), throwable, string2);
        } else {
            SSLSetupLogging.debug(JaLogger.toSSLSetupLoggingLevel(level), string2);
        }
    }

    private static int toSSLSetupLoggingLevel(Level level) {
        if (null == level) {
            throw new IllegalArgumentException("Illegal log level: null");
        }
        if (level == Level.OFF) {
            throw new IllegalArgumentException("Illegal log level: " + Level.OFF);
        }
        if (level == Level.SEVERE) {
            return 0;
        }
        if (level == Level.WARNING) {
            return 2;
        }
        if (level == Level.INFO) {
            return 3;
        }
        if (level == Level.CONFIG) {
            return 3;
        }
        if (level == Level.FINE) {
            return 1;
        }
        if (level == Level.FINER) {
            return 2;
        }
        if (level == Level.FINEST) {
            return 3;
        }
        if (level == Level.ALL) {
            throw new IllegalArgumentException("Illegal log level: " + Level.ALL);
        }
        return 2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Component {
        KEYSTORE,
        KEYSTORE_MANAGER,
        TRUSTSTORE,
        TRUSTSTORE_MANAGER,
        SSLCONTEXT,
        SSLENGINE,
        SSLSERVERSOCKETFACTORY,
        SSLSERVERSOCKET,
        NIOSSLSERVERSOCKET,
        SSLSOCKETFACTORY,
        SSLSOCKET,
        UNKNOWN;

    }
}

