/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.SSL.jsseadapter;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocket;
import weblogic.security.SSL.jsseadapter.JaCipherSuiteNameMap;
import weblogic.security.SSL.jsseadapter.JaLogger;
import weblogic.security.SSL.jsseadapter.JaNioSSLSocket;
import weblogic.security.SSL.jsseadapter.JaSSLContext;
import weblogic.security.SSL.jsseadapter.JaSSLParameters;

final class JaNioSSLServerSocket
extends SSLServerSocket {
    private final JaSSLContext jaSSLContext;
    private final JaSSLParameters sslParameters;
    private final ServerSocketChannel serverSocketChannel;
    private final ServerSocket serverSocket;

    public String[] getEnabledCipherSuites() {
        return JaCipherSuiteNameMap.fromJsse(this.sslParameters.getEnabledCipherSuites());
    }

    public void setEnabledCipherSuites(String[] stringArray) {
        String[] stringArray2 = JaCipherSuiteNameMap.toJsse(stringArray);
        SSLContext sSLContext = this.jaSSLContext.getSSLContext();
        SSLEngine sSLEngine = sSLContext.createSSLEngine();
        sSLEngine.setEnabledCipherSuites(stringArray2);
        this.sslParameters.setEnabledCipherSuites(stringArray2);
    }

    public String[] getSupportedCipherSuites() {
        return this.jaSSLContext.getSupportedCipherSuites();
    }

    public String[] getSupportedProtocols() {
        return this.jaSSLContext.getSupportedProtocols();
    }

    public String[] getEnabledProtocols() {
        return this.sslParameters.getEnabledProtocols();
    }

    public void setEnabledProtocols(String[] stringArray) {
        SSLContext sSLContext = this.jaSSLContext.getSSLContext();
        SSLEngine sSLEngine = sSLContext.createSSLEngine();
        sSLEngine.setEnabledProtocols(stringArray);
        this.sslParameters.setEnabledProtocols(stringArray);
    }

    public void setNeedClientAuth(boolean bl) {
        this.sslParameters.setNeedClientAuth(bl);
    }

    public boolean getNeedClientAuth() {
        return this.sslParameters.getNeedClientAuth();
    }

    public void setWantClientAuth(boolean bl) {
        this.sslParameters.setWantClientAuth(bl);
    }

    public boolean getWantClientAuth() {
        return this.sslParameters.getWantClientAuth();
    }

    public void setUseClientMode(boolean bl) {
        this.sslParameters.setUseClientMode(bl);
    }

    public boolean getUseClientMode() {
        return this.sslParameters.getUseClientMode();
    }

    public void setEnableSessionCreation(boolean bl) {
        this.sslParameters.setEnableSessionCreation(bl);
    }

    public boolean getEnableSessionCreation() {
        return this.sslParameters.getEnableSessionCreation();
    }

    public void bind(SocketAddress socketAddress) throws IOException {
        this.serverSocket.bind(socketAddress);
    }

    public void bind(SocketAddress socketAddress, int n) throws IOException {
        this.serverSocket.bind(socketAddress, n);
    }

    public InetAddress getInetAddress() {
        return this.serverSocket.getInetAddress();
    }

    public int getLocalPort() {
        return this.serverSocket.getLocalPort();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.serverSocket.getLocalSocketAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Socket accept() throws IOException {
        SocketChannel socketChannel = this.serverSocketChannel.accept();
        if (null == socketChannel) {
            if (!JaLogger.isLoggable(Level.FINE)) throw new IllegalStateException("Expected blocking ServerSocketChannel; accept() returned null.");
            JaLogger.log(Level.FINE, JaLogger.Component.NIOSSLSERVERSOCKET, "Expected blocking ServerSocketChannel; accept() returned null.", new Object[0]);
            throw new IllegalStateException("Expected blocking ServerSocketChannel; accept() returned null.");
        }
        Socket socket = socketChannel.socket();
        if (JaLogger.isLoggable(Level.FINEST)) {
            JaLogger.log(Level.FINEST, JaLogger.Component.NIOSSLSERVERSOCKET, "Accepted connection from client: {0}", socket.getInetAddress().getHostAddress());
        }
        socketChannel.configureBlocking(true);
        JaNioSSLSocket jaNioSSLSocket = null;
        try {
            jaNioSSLSocket = new JaNioSSLSocket(socketChannel, this.jaSSLContext, new JaSSLParameters(this.sslParameters), true);
            if (null != jaNioSSLSocket) return jaNioSSLSocket;
        }
        catch (Throwable throwable) {
            if (null != jaNioSSLSocket) throw throwable;
            socket.close();
            if (!JaLogger.isLoggable(Level.FINE)) throw throwable;
            JaLogger.log(Level.FINE, JaLogger.Component.NIOSSLSERVERSOCKET, "Closed channel socket since unable to construct JaNioSSLSocket. Host={0}, Port={1}", socket.getInetAddress().getHostAddress(), socket.getPort());
            throw throwable;
        }
        socket.close();
        if (!JaLogger.isLoggable(Level.FINE)) return jaNioSSLSocket;
        JaLogger.log(Level.FINE, JaLogger.Component.NIOSSLSERVERSOCKET, "Closed channel socket since unable to construct JaNioSSLSocket. Host={0}, Port={1}", socket.getInetAddress().getHostAddress(), socket.getPort());
        return jaNioSSLSocket;
    }

    public void close() throws IOException {
        this.serverSocket.close();
    }

    public ServerSocketChannel getChannel() {
        return this.serverSocketChannel;
    }

    public boolean isBound() {
        return this.serverSocket.isBound();
    }

    public boolean isClosed() {
        return this.serverSocket.isClosed();
    }

    public synchronized void setSoTimeout(int n) throws SocketException {
        this.serverSocket.setSoTimeout(n);
    }

    public synchronized int getSoTimeout() throws IOException {
        return this.serverSocket.getSoTimeout();
    }

    public void setReuseAddress(boolean bl) throws SocketException {
        this.serverSocket.setReuseAddress(bl);
    }

    public boolean getReuseAddress() throws SocketException {
        return this.serverSocket.getReuseAddress();
    }

    public String toString() {
        return this.serverSocket.toString();
    }

    public synchronized void setReceiveBufferSize(int n) throws SocketException {
        this.serverSocket.setReceiveBufferSize(n);
    }

    public synchronized int getReceiveBufferSize() throws SocketException {
        return this.serverSocket.getReceiveBufferSize();
    }

    public void setPerformancePreferences(int n, int n2, int n3) {
        this.serverSocket.setPerformancePreferences(n, n2, n3);
    }

    public int hashCode() {
        return this.serverSocket.hashCode();
    }

    public boolean equals(Object object) {
        return this.serverSocket.equals(object);
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    JaNioSSLServerSocket(JaSSLContext jaSSLContext, int n, int n2, InetAddress inetAddress) throws IOException {
        if (null == jaSSLContext) {
            throw new IllegalArgumentException("Expected non-null JaSSLContext.");
        }
        this.jaSSLContext = jaSSLContext;
        SSLContext sSLContext = jaSSLContext.getSSLContext();
        this.sslParameters = new JaSSLParameters(sSLContext);
        this.sslParameters.setUseClientMode(false);
        this.serverSocketChannel = ServerSocketChannel.open();
        this.serverSocketChannel.configureBlocking(true);
        ServerSocket serverSocket = this.serverSocketChannel.socket();
        InetSocketAddress inetSocketAddress = null != inetAddress ? new InetSocketAddress(inetAddress, n) : new InetSocketAddress(n);
        if (n2 > 0) {
            serverSocket.bind(inetSocketAddress, n2);
        } else {
            serverSocket.bind(inetSocketAddress);
        }
        this.serverSocket = serverSocket;
    }
}

