/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.SSL.jsseadapter;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.text.MessageFormat;
import javax.net.ssl.SSLSocketFactory;
import weblogic.security.SSL.jsseadapter.JaNioSSLSocket;
import weblogic.security.SSL.jsseadapter.JaSSLContext;
import weblogic.security.SSL.jsseadapter.JaSSLParameters;

final class JaNioSSLSocketFactory
extends SSLSocketFactory {
    private final JaSSLContext jaSSLContext;

    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        SocketChannel socketChannel = SocketChannel.open();
        socketChannel.configureBlocking(true);
        socketChannel.connect(new InetSocketAddress(string, n));
        JaSSLParameters jaSSLParameters = new JaSSLParameters(this.jaSSLContext.getSSLContext());
        jaSSLParameters.setUseClientMode(true);
        return new JaNioSSLSocket(socketChannel, this.jaSSLContext, jaSSLParameters, true);
    }

    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        SocketChannel socketChannel = SocketChannel.open();
        socketChannel.configureBlocking(true);
        socketChannel.connect(new InetSocketAddress(inetAddress, n));
        JaSSLParameters jaSSLParameters = new JaSSLParameters(this.jaSSLContext.getSSLContext());
        jaSSLParameters.setUseClientMode(true);
        return new JaNioSSLSocket(socketChannel, this.jaSSLContext, jaSSLParameters, true);
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        SocketChannel socketChannel = SocketChannel.open();
        socketChannel.configureBlocking(true);
        socketChannel.socket().bind(new InetSocketAddress(inetAddress, n2));
        socketChannel.connect(new InetSocketAddress(string, n));
        JaSSLParameters jaSSLParameters = new JaSSLParameters(this.jaSSLContext.getSSLContext());
        jaSSLParameters.setUseClientMode(true);
        return new JaNioSSLSocket(socketChannel, this.jaSSLContext, jaSSLParameters, true);
    }

    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        SocketChannel socketChannel = SocketChannel.open();
        socketChannel.configureBlocking(true);
        socketChannel.socket().bind(new InetSocketAddress(inetAddress2, n2));
        socketChannel.connect(new InetSocketAddress(inetAddress.getHostAddress(), n));
        JaSSLParameters jaSSLParameters = new JaSSLParameters(this.jaSSLContext.getSSLContext());
        jaSSLParameters.setUseClientMode(true);
        return new JaNioSSLSocket(socketChannel, this.jaSSLContext, jaSSLParameters, true);
    }

    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException {
        SocketChannel socketChannel = socket.getChannel();
        if (null == socketChannel) {
            String string2 = MessageFormat.format("The Socket argument is not created by SocketChannel.open() :{0}", socket.toString());
            throw new IllegalArgumentException(string2);
        }
        socketChannel.configureBlocking(true);
        JaSSLParameters jaSSLParameters = new JaSSLParameters(this.jaSSLContext.getSSLContext());
        jaSSLParameters.setUseClientMode(true);
        return new JaNioSSLSocket(socketChannel, this.jaSSLContext, jaSSLParameters, bl);
    }

    public String[] getDefaultCipherSuites() {
        return this.jaSSLContext.getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        return this.jaSSLContext.getSupportedCipherSuites();
    }

    JaNioSSLSocketFactory(JaSSLContext jaSSLContext) {
        if (null == jaSSLContext) {
            throw new IllegalArgumentException("Expected non-null JaSSLContext instance.");
        }
        this.jaSSLContext = jaSSLContext;
    }
}

