/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.SSL.jsseadapter;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import weblogic.security.SSL.jsseadapter.JaCipherSuiteNameMap;
import weblogic.security.SSL.jsseadapter.JaLogger;
import weblogic.security.SSL.jsseadapter.JaSSLContext;
import weblogic.security.SSL.jsseadapter.JaSSLEngine;
import weblogic.security.SSL.jsseadapter.JaSSLEngineFactoryImpl;
import weblogic.security.SSL.jsseadapter.JaSSLParameters;
import weblogic.security.SSL.jsseadapter.JaSSLServerSocketFactory;
import weblogic.security.SSL.jsseadapter.JaSSLSupport;
import weblogic.security.SSL.jsseadapter.JaTrustManager;
import weblogic.security.utils.BasicConstraintsSSLContextDelegate;
import weblogic.security.utils.SSLHostnameVerifier;
import weblogic.security.utils.SSLTrustValidator;
import weblogic.security.utils.SSLTruster;
import weblogic.socket.JSSESocketFactory;

public final class JaSSLContextImpl
extends JaSSLContext
implements BasicConstraintsSSLContextDelegate {
    private String specifiedProviderName;
    private Provider specifiedProvider;
    private SecureRandom secureRandom;
    private SSLContext sslContext;
    private int protocolVersion;
    private static final String DEFAULT_PROTOCOL = "TLS";
    private volatile SSLTruster truster;
    private volatile SSLHostnameVerifier hostnameVerifier;
    private int enforceConstraintsLevel;
    private boolean enableUnencryptedNullCipher;
    private int exportRefreshCount;
    private Vector<X509Certificate> trustedCAs = new Vector();
    private PrivateKey identityPrivateKey;
    private X509Certificate[] certChain;
    private static final String CERT_HEADER = "-----BEGIN CERTIFICATE-----";

    public void addTrustedCA(X509Certificate x509Certificate) throws CertificateException {
        if (JaLogger.isLoggable(Level.FINEST)) {
            JaLogger.log(Level.FINEST, JaLogger.Component.SSLCONTEXT, "addTrustedCA called.", new Object[0]);
        }
        this.trustedCAs.add(x509Certificate);
    }

    public X509Certificate[] getTrustedCAs() {
        X509Certificate[] x509CertificateArray = new X509Certificate[this.trustedCAs.size()];
        return this.trustedCAs.toArray(x509CertificateArray);
    }

    public PrivateKey inputPrivateKey(InputStream inputStream, char[] cArray) throws KeyManagementException {
        if (JaLogger.isLoggable(Level.FINEST)) {
            JaLogger.log(Level.FINEST, JaLogger.Component.SSLCONTEXT, "inputPrivateKey called.", new Object[0]);
        }
        return JaSSLSupport.getLocalIdentityPrivateKey(inputStream, cArray);
    }

    public X509Certificate[] inputCertChain(InputStream inputStream) throws KeyManagementException {
        Collection<Certificate> collection;
        block10: {
            byte[] byArray;
            String string;
            block9: {
                if (JaLogger.isLoggable(Level.FINEST)) {
                    JaLogger.log(Level.FINEST, JaLogger.Component.SSLCONTEXT, "inputCertChain called.", new Object[0]);
                }
                string = null;
                byArray = null;
                collection = new ArrayList<Certificate>();
                try {
                    byArray = JaSSLSupport.readFully(inputStream);
                    if (byArray != null) {
                        string = new String(byArray);
                    }
                }
                catch (IOException iOException) {
                    if (!JaLogger.isLoggable(Level.SEVERE)) break block9;
                    JaLogger.log(Level.SEVERE, JaLogger.Component.SSLCONTEXT, iOException, "Error reading data from from the certificate inputstream: " + iOException.getMessage(), new Object[0]);
                }
            }
            if (string != null) {
                Matcher matcher = Pattern.compile("-----BEGIN CERTIFICATE-----.+?-----END CERTIFICATE-----", 32).matcher(string);
                CertificateFactory certificateFactory = null;
                try {
                    boolean bl;
                    certificateFactory = CertificateFactory.getInstance("X.509");
                    int n = 0;
                    while (matcher.find()) {
                        String string2 = matcher.group();
                        collection.add(certificateFactory.generateCertificate(new ByteArrayInputStream(string2.getBytes())));
                        ++n;
                    }
                    boolean bl2 = bl = n > 0;
                    if (!bl) {
                        collection = certificateFactory.generateCertificates(new ByteArrayInputStream(byArray));
                    }
                }
                catch (CertificateException certificateException) {
                    if (!JaLogger.isLoggable(Level.SEVERE)) break block10;
                    JaLogger.log(Level.SEVERE, JaLogger.Component.SSLCONTEXT, certificateException, "Error retrieving certifcate(s) from inputstream: " + certificateException.getMessage(), new Object[0]);
                }
            }
        }
        return collection.toArray(new X509Certificate[collection.size()]);
    }

    public void loadLocalIdentity(InputStream inputStream, char[] cArray) throws KeyManagementException {
        if (JaLogger.isLoggable(Level.FINEST)) {
            JaLogger.log(Level.FINEST, JaLogger.Component.SSLCONTEXT, "loadLocalIdentity called, ignored by JSSE for now.", new Object[0]);
        }
    }

    public void loadTrustedCerts(InputStream inputStream) throws CertificateException, KeyManagementException {
        X509Certificate[] x509CertificateArray;
        if (JaLogger.isLoggable(Level.FINEST)) {
            JaLogger.log(Level.FINEST, JaLogger.Component.SSLCONTEXT, "loadTrustedCerts called.", new Object[0]);
        }
        for (X509Certificate x509Certificate : x509CertificateArray = this.inputCertChain(inputStream)) {
            this.trustedCAs.add(x509Certificate);
        }
    }

    public void addIdentity(X509Certificate[] x509CertificateArray, PrivateKey privateKey) {
        this.identityPrivateKey = privateKey;
        this.certChain = x509CertificateArray;
        if (JaLogger.isLoggable(Level.FINEST)) {
            JaLogger.log(Level.FINEST, JaLogger.Component.SSLCONTEXT, "addIdentity called.", new Object[0]);
        }
    }

    public boolean doKeysMatch(PublicKey publicKey, PrivateKey privateKey) throws KeyManagementException {
        boolean bl;
        block4: {
            boolean bl2;
            if (JaLogger.isLoggable(Level.FINEST)) {
                JaLogger.log(Level.FINEST, JaLogger.Component.SSLCONTEXT, "doKeysMatch called.", new Object[0]);
            }
            bl = bl2 = publicKey.getAlgorithm().equals(privateKey.getAlgorithm());
            if (bl2) {
                String string = "Hello there!";
                try {
                    Cipher cipher = Cipher.getInstance(publicKey.getAlgorithm());
                    Cipher cipher2 = Cipher.getInstance(privateKey.getAlgorithm());
                    cipher.init(1, publicKey);
                    cipher2.init(2, privateKey);
                    byte[] byArray = cipher.doFinal(string.getBytes());
                    bl = string.equals(new String(cipher2.doFinal(byArray)));
                }
                catch (Exception exception) {
                    if (!JaLogger.isLoggable(Level.FINEST)) break block4;
                    JaLogger.log(Level.FINEST, JaLogger.Component.SSLCONTEXT, "Error getting Cipher instance.", exception.getMessage());
                }
            }
        }
        return bl;
    }

    public void setExportRefreshCount(int n) {
        this.exportRefreshCount = n;
        if (JaLogger.isLoggable(Level.FINEST)) {
            JaLogger.log(Level.FINEST, JaLogger.Component.SSLCONTEXT, "Set exportRefreshCount to {0}.", n);
        }
    }

    public void setProtocolVersion(int n) throws IllegalArgumentException {
        this.protocolVersion = n;
        if (JaLogger.isLoggable(Level.FINEST)) {
            JaLogger.log(Level.FINEST, JaLogger.Component.SSLCONTEXT, "Set protocolVersion to {0}.", this.protocolVersion);
        }
    }

    public SSLServerSocketFactory getSSLServerSocketFactory() {
        return new JaSSLServerSocketFactory(this, false);
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.getConfiguredSSLSocketFactory();
    }

    public void setTrustManager(SSLTruster sSLTruster) {
        this.truster = sSLTruster;
        if (JaLogger.isLoggable(Level.FINEST)) {
            JaLogger.log(Level.FINEST, JaLogger.Component.SSLCONTEXT, "Set weblogic.security.utils.SSLTruster to {0}.", sSLTruster);
        }
    }

    public SSLTruster getTrustManager() {
        return this.truster;
    }

    public void setHostnameVerifier(SSLHostnameVerifier sSLHostnameVerifier) {
        this.hostnameVerifier = sSLHostnameVerifier;
        if (JaLogger.isLoggable(Level.FINEST)) {
            JaLogger.log(Level.FINEST, JaLogger.Component.SSLCONTEXT, "Set weblogic.security.utils.SSLHostnameVerifier to {0}.", sSLHostnameVerifier);
        }
    }

    public SSLHostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void enforceConstraints(int n) {
        this.enforceConstraintsLevel = n;
        JaSSLSupport.setX509BasicConstraintsStrict(2 == n || 3 == n);
        JaSSLSupport.setNoV1CAs(4 == n || 3 == n);
        if (JaLogger.isLoggable(Level.FINEST)) {
            JaLogger.log(Level.FINEST, JaLogger.Component.SSLCONTEXT, "Set enforceConstraints level to {0}.", n);
        }
    }

    public void enableUnencryptedNullCipher(boolean bl) {
        this.enableUnencryptedNullCipher = bl;
        JaSSLSupport.isUnEncrytedNullCipherAllowed();
        if (JaLogger.isLoggable(Level.FINEST)) {
            JaLogger.log(Level.FINEST, JaLogger.Component.SSLCONTEXT, "Set enableUnencryptedNullCipher to {0}.", bl);
        }
    }

    public boolean isUnencryptedNullCipherEnabled() {
        return this.enableUnencryptedNullCipher;
    }

    public SSLServerSocketFactory getSSLNioServerSocketFactory() {
        return new JaSSLServerSocketFactory(this, true);
    }

    public SSLSocketFactory getSSLNioSocketFactory() {
        return this.getSSLSocketFactory();
    }

    public JaSSLEngine createSSLEngine() throws SSLException {
        try {
            JaSSLEngine jaSSLEngine = new JaSSLEngine(this, this.getSSLContext().createSSLEngine());
            this.configureSslEngine(jaSSLEngine);
            return jaSSLEngine;
        }
        catch (Exception exception) {
            throw new SSLException(exception);
        }
    }

    public JaSSLEngine createSSLEngine(String string, int n) throws SSLException {
        try {
            JaSSLEngine jaSSLEngine = new JaSSLEngine(this, this.getSSLContext().createSSLEngine(string, n));
            this.configureSslEngine(jaSSLEngine);
            return jaSSLEngine;
        }
        catch (Exception exception) {
            throw new SSLException(exception);
        }
    }

    public String[] getDefaultCipherSuites() {
        SSLContext sSLContext = this.getSSLContext();
        SSLEngine sSLEngine = sSLContext.createSSLEngine();
        return JaCipherSuiteNameMap.fromJsse(sSLEngine.getEnabledCipherSuites());
    }

    public String[] getSupportedCipherSuites() {
        SSLContext sSLContext = this.getSSLContext();
        SSLEngine sSLEngine = sSLContext.createSSLEngine();
        return JaCipherSuiteNameMap.fromJsse(sSLEngine.getSupportedCipherSuites());
    }

    public String[] getDefaultProtocols() {
        SSLContext sSLContext = this.getSSLContext();
        SSLEngine sSLEngine = sSLContext.createSSLEngine();
        return sSLEngine.getEnabledProtocols();
    }

    public String[] getSupportedProtocols() {
        SSLContext sSLContext = this.getSSLContext();
        SSLEngine sSLEngine = sSLContext.createSSLEngine();
        return sSLEngine.getSupportedProtocols();
    }

    synchronized SSLContext getSSLContext() {
        if (null == this.sslContext) {
            Provider provider = this.getSpecifiedProvider();
            try {
                SSLContext sSLContext = null == provider ? SSLContext.getInstance(DEFAULT_PROTOCOL) : SSLContext.getInstance(DEFAULT_PROTOCOL, provider);
                this.initializeContext(sSLContext);
                this.sslContext = sSLContext;
                if (JaLogger.isLoggable(Level.FINEST)) {
                    JaLogger.log(Level.FINEST, JaLogger.Component.SSLCONTEXT, "Got SSLContext, protocol={0}, provider={1}", DEFAULT_PROTOCOL, sSLContext.getProvider().getName());
                }
            }
            catch (Exception exception) {
                if (JaLogger.isLoggable(Level.FINE)) {
                    JaLogger.log(Level.FINE, JaLogger.Component.SSLCONTEXT, exception, "Unable to construct SSLContext, protocol={0}, provider={1}", DEFAULT_PROTOCOL, null == provider ? provider : provider.getName());
                }
                throw new RuntimeException(exception);
            }
        }
        return this.sslContext;
    }

    synchronized String getSpecifiedProviderName() {
        return this.specifiedProviderName;
    }

    synchronized SecureRandom getSecureRandom() throws NoSuchAlgorithmException {
        if (null == this.secureRandom) {
            Provider provider = this.getSpecifiedProvider();
            try {
                SecureRandom secureRandom = null == provider ? SecureRandom.getInstance("SHA1PRNG") : SecureRandom.getInstance("SHA1PRNG", provider);
                this.secureRandom = secureRandom;
                if (JaLogger.isLoggable(Level.FINEST)) {
                    JaLogger.log(Level.FINEST, JaLogger.Component.SSLCONTEXT, "Got SecureRandom, algorithm={0}, provider={1}", "SHA1PRNG", secureRandom.getProvider().getName());
                }
            }
            catch (RuntimeException runtimeException) {
                this.log_getSecureRandom(runtimeException, "SHA1PRNG", provider);
                throw runtimeException;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.log_getSecureRandom(noSuchAlgorithmException, "SHA1PRNG", provider);
                throw noSuchAlgorithmException;
            }
        }
        return this.secureRandom;
    }

    private void log_getSecureRandom(Exception exception, String string, Provider provider) {
        if (JaLogger.isLoggable(Level.FINE)) {
            JaLogger.log(Level.FINE, JaLogger.Component.SSLCONTEXT, exception, "Unable to get SecureRandom, algorithm={0}, provider={1}", string, null == provider ? provider : provider.getName());
        }
    }

    synchronized boolean hasSpecifiedProvider() {
        return null != this.getSpecifiedProviderName();
    }

    synchronized Provider getSpecifiedProvider() {
        if (!this.hasSpecifiedProvider()) {
            return null;
        }
        if (null == this.specifiedProvider) {
            String string = this.getSpecifiedProviderName();
            try {
                this.specifiedProvider = Security.getProvider(string);
                if (null == this.specifiedProvider) {
                    throw new IllegalArgumentException("Specified provider \"" + string + "\" has not been installed.");
                }
                if (JaLogger.isLoggable(Level.FINEST)) {
                    JaLogger.log(Level.FINEST, JaLogger.Component.SSLCONTEXT, "Got Provider, name={0}", string);
                }
            }
            catch (RuntimeException runtimeException) {
                if (JaLogger.isLoggable(Level.FINE)) {
                    JaLogger.log(Level.FINE, JaLogger.Component.SSLCONTEXT, runtimeException, "Unable to get specified provider, name={0}.", string);
                }
                throw runtimeException;
            }
        }
        return this.specifiedProvider;
    }

    private void log_getKeyStore(Exception exception, String string, Provider provider) {
        if (JaLogger.isLoggable(Level.FINE)) {
            JaLogger.log(Level.FINE, JaLogger.Component.SSLCONTEXT, exception, "Unable to get KeyStore, type={0}, provider={1}", string, null == provider ? provider : provider.getName());
        }
    }

    private void log_getTrustStore(Exception exception, String string, Provider provider) {
        if (JaLogger.isLoggable(Level.FINE)) {
            JaLogger.log(Level.FINE, JaLogger.Component.SSLCONTEXT, exception, "Unable to get TrustStore, type={0}, provider={1}", string, null == provider ? provider : provider.getName());
        }
    }

    private void initializeContext(SSLContext sSLContext) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        if (sSLContext != null) {
            Object[] objectArray = new X509Certificate[this.trustedCAs.size()];
            this.trustedCAs.copyInto(objectArray);
            TrustManager[] trustManagerArray = new TrustManager[]{new JaTrustManager((X509Certificate[])objectArray)};
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            char[] cArray = null;
            if (null != this.identityPrivateKey) {
                String string = Integer.toString(this.identityPrivateKey.hashCode());
                cArray = string.toCharArray();
                keyStore.setKeyEntry(string, this.identityPrivateKey, cArray, this.certChain);
            }
            keyManagerFactory.init(keyStore, cArray);
            sSLContext.init(keyManagerFactory.getKeyManagers(), trustManagerArray, null);
        }
    }

    private void configureSslEngine(JaSSLEngine jaSSLEngine) {
        JaSSLParameters jaSSLParameters = new JaSSLParameters(this.getSSLContext());
        jaSSLParameters.setUnencryptedNullCipherEnabled(this.isUnencryptedNullCipherEnabled());
        jaSSLParameters.configureSslEngine(jaSSLEngine);
        SSLTruster sSLTruster = this.getTrustManager();
        if (sSLTruster instanceof SSLTrustValidator) {
            SSLTrustValidator sSLTrustValidator = (SSLTrustValidator)sSLTruster;
            jaSSLEngine.setNeedClientAuth(sSLTrustValidator.isPeerCertsRequired());
        }
    }

    private SSLSocketFactory getConfiguredSSLSocketFactory() {
        JaSSLEngineFactoryImpl jaSSLEngineFactoryImpl = new JaSSLEngineFactoryImpl(this);
        return JSSESocketFactory.getSSLSocketFactory(jaSSLEngineFactoryImpl);
    }
}

