/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.SSL.jsseadapter;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Vector;
import java.util.logging.Level;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import weblogic.security.SSL.WeblogicSSLEngine;
import weblogic.security.SSL.jsseadapter.JaCipherSuiteNameMap;
import weblogic.security.SSL.jsseadapter.JaLogger;
import weblogic.security.SSL.jsseadapter.JaSSLContext;
import weblogic.security.utils.SSLTrustValidator;
import weblogic.security.utils.SSLTruster;

final class JaSSLEngine
extends WeblogicSSLEngine {
    private final SSLEngine engine;
    private final JaSSLContext jaSSLContext;
    private volatile SSLSocket associatedSSLSocket;
    private final int HANDSHAKECOMPLETEDLISTENERS_INITIALCAPACITY = 16;
    private final Vector<HandshakeCompletedListener> handshakeCompletedListeners = new Vector(16);

    public String getPeerHost() {
        return this.engine.getPeerHost();
    }

    public int getPeerPort() {
        return this.engine.getPeerPort();
    }

    public SSLEngineResult wrap(final ByteBuffer byteBuffer, final ByteBuffer byteBuffer2) throws SSLException {
        return this.doAction(new SSLEngineResultSSLExceptionAction(){

            public SSLEngineResult run() throws SSLException {
                return JaSSLEngine.this.engine.wrap(byteBuffer, byteBuffer2);
            }
        }, "SSLEngine.wrap(ByteBuffer,ByteBuffer)");
    }

    public SSLEngineResult wrap(final ByteBuffer[] byteBufferArray, final ByteBuffer byteBuffer) throws SSLException {
        return this.doAction(new SSLEngineResultSSLExceptionAction(){

            public SSLEngineResult run() throws SSLException {
                return JaSSLEngine.this.engine.wrap(byteBufferArray, byteBuffer);
            }
        }, "SSLEngine.wrap(ByteBuffer[],ByteBuffer)");
    }

    public SSLEngineResult wrap(final ByteBuffer[] byteBufferArray, final int n, final int n2, final ByteBuffer byteBuffer) throws SSLException {
        return this.doAction(new SSLEngineResultSSLExceptionAction(){

            public SSLEngineResult run() throws SSLException {
                return JaSSLEngine.this.engine.wrap(byteBufferArray, n, n2, byteBuffer);
            }
        }, "SSLEngine.wrap(ByteBuffer[],int,int,ByteBuffer)");
    }

    public SSLEngineResult unwrap(final ByteBuffer byteBuffer, final ByteBuffer byteBuffer2) throws SSLException {
        return this.doAction(new SSLEngineResultSSLExceptionAction(){

            public SSLEngineResult run() throws SSLException {
                return JaSSLEngine.this.engine.unwrap(byteBuffer, byteBuffer2);
            }
        }, "SSLEngine.unwrap(ByteBuffer,ByteBuffer)");
    }

    public SSLEngineResult unwrap(final ByteBuffer byteBuffer, final ByteBuffer[] byteBufferArray) throws SSLException {
        return this.doAction(new SSLEngineResultSSLExceptionAction(){

            public SSLEngineResult run() throws SSLException {
                return JaSSLEngine.this.engine.unwrap(byteBuffer, byteBufferArray);
            }
        }, "SSLEngine.unwrap(ByteBuffer,ByteBuffer[])");
    }

    public SSLEngineResult unwrap(final ByteBuffer byteBuffer, final ByteBuffer[] byteBufferArray, final int n, final int n2) throws SSLException {
        return this.doAction(new SSLEngineResultSSLExceptionAction(){

            public SSLEngineResult run() throws SSLException {
                return JaSSLEngine.this.engine.unwrap(byteBuffer, byteBufferArray, n, n2);
            }
        }, "SSLEngine.unwrap(ByteBuffer,ByteBuffer[],int,int)");
    }

    public Runnable getDelegatedTask() {
        return this.engine.getDelegatedTask();
    }

    public void closeInbound() throws SSLException {
        this.doAction(new SSLEngineResultSSLExceptionAction(){

            public SSLEngineResult run() throws SSLException {
                JaSSLEngine.this.engine.closeInbound();
                return null;
            }
        }, "SSLEngine.closeInbound()");
    }

    public boolean isInboundDone() {
        return this.engine.isInboundDone();
    }

    public void closeOutbound() {
        this.doAction(new SetValueAction(){

            public void run() {
                JaSSLEngine.this.engine.closeOutbound();
            }

            public String getSetValue() {
                return "closed";
            }
        }, "SSLEngine.closeOutbound()");
    }

    public boolean isOutboundDone() {
        return this.engine.isOutboundDone();
    }

    public String[] getSupportedCipherSuites() {
        return JaCipherSuiteNameMap.fromJsse(this.engine.getSupportedCipherSuites());
    }

    public String[] getEnabledCipherSuites() {
        return JaCipherSuiteNameMap.fromJsse(this.engine.getEnabledCipherSuites());
    }

    public void setEnabledCipherSuites(final String[] stringArray) {
        this.doAction(new SetValueAction(){

            public void run() {
                JaSSLEngine.this.engine.setEnabledCipherSuites(JaCipherSuiteNameMap.toJsse(stringArray));
            }

            public String getSetValue() {
                return JaSSLEngine.toString(stringArray);
            }
        }, "SSLEngine.setEnabledCipherSuites(String[])");
    }

    public String[] getSupportedProtocols() {
        return this.engine.getSupportedProtocols();
    }

    public String[] getEnabledProtocols() {
        return this.engine.getEnabledProtocols();
    }

    public void setEnabledProtocols(final String[] stringArray) {
        this.doAction(new SetValueAction(){

            public void run() {
                JaSSLEngine.this.engine.setEnabledProtocols(stringArray);
            }

            public String getSetValue() {
                return JaSSLEngine.toString(stringArray);
            }
        }, "SSLEngine.setEnabledProtocols(String[])");
    }

    public SSLSession getSession() {
        return this.engine.getSession();
    }

    public void beginHandshake() throws SSLException {
        this.doAction(new SSLEngineResultSSLExceptionAction(){

            public SSLEngineResult run() throws SSLException {
                JaSSLEngine.this.engine.beginHandshake();
                return null;
            }
        }, "SSLEngine.beginHandshake()");
    }

    public SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        return this.engine.getHandshakeStatus();
    }

    public void setUseClientMode(final boolean bl) {
        this.doAction(new SetValueAction(){

            public void run() {
                JaSSLEngine.this.engine.setUseClientMode(bl);
            }

            public String getSetValue() {
                return Boolean.toString(bl);
            }
        }, "SSLEngine.setUseClientMode(boolean)");
    }

    public boolean getUseClientMode() {
        return this.engine.getUseClientMode();
    }

    public void setNeedClientAuth(final boolean bl) {
        this.doAction(new SetValueAction(){

            public void run() {
                JaSSLEngine.this.engine.setNeedClientAuth(bl);
            }

            public String getSetValue() {
                return Boolean.toString(bl);
            }
        }, "SSLEngine.setNeedClientAuth(boolean)");
    }

    public boolean getNeedClientAuth() {
        return this.engine.getNeedClientAuth();
    }

    public void setWantClientAuth(final boolean bl) {
        this.doAction(new SetValueAction(){

            public void run() {
                JaSSLEngine.this.engine.setWantClientAuth(bl);
            }

            public String getSetValue() {
                return Boolean.toString(bl);
            }
        }, "SSLEngine.setWantClientAuth(boolean)");
    }

    public boolean getWantClientAuth() {
        return this.engine.getWantClientAuth();
    }

    public void setEnableSessionCreation(final boolean bl) {
        this.doAction(new SetValueAction(){

            public void run() {
                JaSSLEngine.this.engine.setEnableSessionCreation(bl);
            }

            public String getSetValue() {
                return Boolean.toString(bl);
            }
        }, "SSLEngine.setEnableSessionCreation(boolean)");
    }

    public boolean getEnableSessionCreation() {
        return this.engine.getEnableSessionCreation();
    }

    public void setAssociatedSSLSocket(SSLSocket sSLSocket) {
        this.associatedSSLSocket = sSLSocket;
    }

    public SSLSocket getAssociatedSSLSocket() {
        return this.associatedSSLSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        if (null == handshakeCompletedListener) {
            throw new IllegalArgumentException("Non-null HandshakeCompletedListener expected.");
        }
        boolean bl = false;
        Vector<HandshakeCompletedListener> vector = this.handshakeCompletedListeners;
        synchronized (vector) {
            if (!this.handshakeCompletedListeners.contains(handshakeCompletedListener)) {
                this.handshakeCompletedListeners.add(handshakeCompletedListener);
                bl = true;
            }
        }
        if (bl) {
            if (JaLogger.isLoggable(Level.FINEST)) {
                JaLogger.log(Level.FINEST, JaLogger.Component.SSLENGINE, "Added HandshakeCompletedListener: class={0}, instance={1}.", handshakeCompletedListener.getClass().getName(), handshakeCompletedListener);
            }
        } else if (JaLogger.isLoggable(Level.FINEST)) {
            JaLogger.log(Level.FINEST, JaLogger.Component.SSLENGINE, "HandshakeCompletedListener previously added: class={0}, instance={1}.", handshakeCompletedListener.getClass().getName(), handshakeCompletedListener);
        }
        if (null == this.getAssociatedSSLSocket() && JaLogger.isLoggable(Level.FINER)) {
            JaLogger.log(Level.FINER, JaLogger.Component.SSLENGINE, "No associated SSLSocket when adding HandshakeCompletedListener: class={0}, instance={1}. An associated SSLSocket is required.", handshakeCompletedListener.getClass().getName(), handshakeCompletedListener);
        }
    }

    public void removeHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        if (null == handshakeCompletedListener) {
            throw new IllegalArgumentException("Non-null HandshakeCompletedListener expected.");
        }
        if (!this.handshakeCompletedListeners.remove(handshakeCompletedListener)) {
            String string = MessageFormat.format("Attempting to remove unregistered HandshakeCompletedListener: class={0}, instance={1}.", handshakeCompletedListener.getClass().getName(), handshakeCompletedListener);
            if (JaLogger.isLoggable(Level.FINE)) {
                JaLogger.log(Level.FINE, JaLogger.Component.SSLENGINE, string, new Object[0]);
            }
            throw new IllegalArgumentException(string);
        }
        if (JaLogger.isLoggable(Level.FINEST)) {
            JaLogger.log(Level.FINEST, JaLogger.Component.SSLENGINE, "Removed HandshakeCompletedListener: class={0}, instance={1}.", handshakeCompletedListener.getClass().getName(), handshakeCompletedListener);
        }
    }

    JaSSLEngine(JaSSLContext jaSSLContext, SSLEngine sSLEngine) {
        if (null == jaSSLContext) {
            throw new IllegalArgumentException("Expected non-null JaSSLContext.");
        }
        if (null == sSLEngine) {
            throw new IllegalArgumentException("Expected non-null SSLEngine.");
        }
        this.engine = sSLEngine;
        this.jaSSLContext = jaSSLContext;
    }

    final SSLEngine getDelegate() {
        return this.engine;
    }

    static void validateErrToException(int n) throws IOException {
        if (0 == n) {
            if (JaLogger.isLoggable(Level.FINEST)) {
                JaLogger.log(Level.FINEST, JaLogger.Component.SSLENGINE, "No trust failure, validateErr={0}.", n);
            }
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("Trust failure (");
        stringBuilder.append(n);
        stringBuilder.append("): ");
        if ((1 & n) != 0) {
            stringBuilder.append(" CERT_CHAIN_INVALID");
        }
        if ((2 & n) != 0) {
            stringBuilder.append(" CERT_EXPIRED");
        }
        if ((4 & n) != 0) {
            stringBuilder.append(" CERT_CHAIN_INCOMPLETE");
        }
        if ((8 & n) != 0) {
            stringBuilder.append(" SIGNATURE_INVALID");
        }
        if ((0x10 & n) != 0) {
            stringBuilder.append(" CERT_CHAIN_UNTRUSTED");
        }
        if ((0x20 & n) != 0) {
            stringBuilder.append(" VALIDATION_FAILED");
        }
        String string = stringBuilder.toString();
        if (JaLogger.isLoggable(Level.FINE)) {
            JaLogger.log(Level.FINE, JaLogger.Component.SSLENGINE, string, new Object[0]);
        }
        throw new SSLKeyException(string);
    }

    /*
     * WARNING - void declaration
     */
    void doPostHandshake() throws IOException {
        String string;
        Object object3;
        SSLSocket sSLSocket = this.getAssociatedSSLSocket();
        if (null == sSLSocket) {
            if (JaLogger.isLoggable(Level.FINE)) {
                JaLogger.log(Level.FINE, JaLogger.Component.SSLENGINE, "No associated SSLSocket for WeblogicSSLEngine (class={0}, instance={1}), unable to perform post-handshake processing.", this.getClass().getName(), this);
            }
            return;
        }
        SSLSession sSLSession = this.getSession();
        SSLTruster sSLTruster = this.jaSSLContext.getTrustManager();
        if (sSLTruster != null) {
            block13: {
                object3 = null;
                try {
                    object3 = (X509Certificate[])sSLSession.getPeerCertificates();
                }
                catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                    if (!JaLogger.isLoggable(Level.FINER)) break block13;
                    JaLogger.log(Level.FINER, JaLogger.Component.SSLENGINE, "Trying to get peer certificates from SSLSession, SSLPeerUnverifiedException: {0}.", sSLPeerUnverifiedException.getMessage());
                }
            }
            X509Certificate[] object22 = this.jaSSLContext.getTrustedCAs();
            string = sSLSession.getCipherSuite();
            if (JaLogger.isLoggable(Level.FINEST)) {
                JaLogger.log(Level.FINEST, JaLogger.Component.SSLENGINE, "negotiatedCipherSuite: {0}", string);
                JaLogger.log(Level.FINEST, JaLogger.Component.SSLENGINE, "SSLEngine.getNeedClientAuth(): {0}", this.getNeedClientAuth());
                JaLogger.log(Level.FINEST, JaLogger.Component.SSLENGINE, "Peer certificate chain: {0}", object3);
                if (sSLTruster instanceof SSLTrustValidator) {
                    JaLogger.log(Level.FINEST, JaLogger.Component.SSLENGINE, "weblogic.security.utils.SSLTrustValidator.isPeerCertsRequired(): {0}", ((SSLTrustValidator)sSLTruster).isPeerCertsRequired());
                }
            }
            if (string != null && string.toLowerCase().indexOf("_anon_") < 0) {
                JaSSLEngine.validateErrToException(sSLTruster.validationCallback((X509Certificate[])object3, 0, sSLSocket, object22));
            }
        }
        if (this.getUseClientMode() && (object3 = this.jaSSLContext.getHostnameVerifier()) != null) {
            void var6_10;
            InetAddress object = sSLSocket.getInetAddress();
            if (null == object) {
                String string2 = "";
            } else {
                String string3 = object.getHostName();
            }
            if (!object3.hostnameValidationCallback((String)var6_10, sSLSocket)) {
                string = MessageFormat.format("Hostname verification failed: HostnameVerifier={0}, hostname={1}.", object3.getClass().getName(), var6_10);
                throw new SSLKeyException(string);
            }
        }
        object3 = new HandshakeCompletedEvent(sSLSocket, sSLSession);
        for (HandshakeCompletedListener handshakeCompletedListener : this.handshakeCompletedListeners) {
            handshakeCompletedListener.handshakeCompleted((HandshakeCompletedEvent)object3);
        }
    }

    SSLEngineResult doAction(SSLEngineResultSSLExceptionAction sSLEngineResultSSLExceptionAction, String string) throws SSLException {
        SSLEngineResult sSLEngineResult;
        if (null == sSLEngineResultSSLExceptionAction) {
            throw new IllegalArgumentException("Expected non-null SSLEngineResultSSLExceptionAction object.");
        }
        if (null == string) {
            throw new IllegalArgumentException("Expected non-null actionName object.");
        }
        try {
            sSLEngineResult = sSLEngineResultSSLExceptionAction.run();
            if (JaLogger.isLoggable(Level.FINEST)) {
                JaLogger.log(Level.FINEST, JaLogger.Component.SSLENGINE, "{0} called: result={1}.", string, sSLEngineResult);
            }
            if (null == sSLEngineResult) {
                return sSLEngineResult;
            }
            SSLEngineResult.Status status = sSLEngineResult.getStatus();
            SSLEngineResult.HandshakeStatus handshakeStatus = sSLEngineResult.getHandshakeStatus();
            if (SSLEngineResult.Status.OK == status && SSLEngineResult.HandshakeStatus.FINISHED == handshakeStatus) {
                this.doPostHandshake();
                if (JaLogger.isLoggable(Level.FINEST)) {
                    JaLogger.log(Level.FINEST, JaLogger.Component.SSLENGINE, "Successfully completed post-handshake processing.", new Object[0]);
                }
            }
        }
        catch (Exception exception) {
            if (JaLogger.isLoggable(Level.FINE)) {
                JaLogger.log(Level.FINE, JaLogger.Component.SSLENGINE, exception, "Exception occurred during {0}.", string);
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception instanceof SSLException) {
                throw (SSLException)exception;
            }
            throw new SSLException("Occurred during " + string + ".", exception);
        }
        return sSLEngineResult;
    }

    private void doAction(SetValueAction setValueAction, String string) {
        if (null == setValueAction) {
            throw new IllegalArgumentException("Expected non-null SetValueAction object.");
        }
        if (null == string) {
            throw new IllegalArgumentException("Expected non-null actionName object.");
        }
        try {
            setValueAction.run();
            if (JaLogger.isLoggable(Level.FINEST)) {
                JaLogger.log(Level.FINEST, JaLogger.Component.SSLENGINE, "{0}: value={1}.", string, setValueAction.getSetValue());
            }
        }
        catch (RuntimeException runtimeException) {
            if (JaLogger.isLoggable(Level.FINE)) {
                JaLogger.log(Level.FINE, JaLogger.Component.SSLENGINE, runtimeException, "Exception occurred during {0}: value={1}.", string, setValueAction.getSetValue());
            }
            throw runtimeException;
        }
    }

    static String toString(String[] stringArray) {
        if (null == stringArray) {
            return "<null>";
        }
        StringBuilder stringBuilder = new StringBuilder(256);
        for (String string : stringArray) {
            if (null == string) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private static interface SetValueAction {
        public void run();

        public String getSetValue();
    }

    static interface SSLEngineResultSSLExceptionAction {
        public SSLEngineResult run() throws SSLException;
    }
}

