/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.SSL.jsseadapter;

import javax.net.ssl.SSLException;
import weblogic.security.SSL.SSLEngineFactory;
import weblogic.security.SSL.WeblogicSSLEngine;
import weblogic.security.SSL.jsseadapter.JaSSLContext;
import weblogic.security.SSL.jsseadapter.JaSSLEngineFactoryBuilder;
import weblogic.security.utils.SSLContextWrapper;

final class JaSSLEngineFactoryImpl
implements SSLEngineFactory {
    private final SSLContextWrapper context;
    private final JaSSLContext jaContext;

    JaSSLEngineFactoryImpl(SSLContextWrapper sSLContextWrapper) {
        if (!JaSSLEngineFactoryBuilder.isJSSEEnabled()) {
            throw new UnsupportedOperationException("SSLEngine is only available when JSSE is enabled.");
        }
        if (null == sSLContextWrapper) {
            throw new IllegalArgumentException("Non-null SSLContextWrapper expected.");
        }
        this.context = sSLContextWrapper;
        this.jaContext = null;
    }

    JaSSLEngineFactoryImpl(JaSSLContext jaSSLContext) {
        if (!JaSSLEngineFactoryBuilder.isJSSEEnabled()) {
            throw new UnsupportedOperationException("SSLEngine is only available when JSSE is enabled.");
        }
        if (null == jaSSLContext) {
            throw new IllegalArgumentException("Non-null JaSSLContext expected.");
        }
        this.context = null;
        this.jaContext = jaSSLContext;
    }

    public String[] getDefaultCipherSuites() {
        if (null != this.jaContext) {
            return this.jaContext.getDefaultCipherSuites();
        }
        return this.context.getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        if (null != this.jaContext) {
            return this.jaContext.getSupportedCipherSuites();
        }
        return this.context.getSupportedCipherSuites();
    }

    public WeblogicSSLEngine createSSLEngine() throws SSLException {
        if (null != this.jaContext) {
            return this.jaContext.createSSLEngine();
        }
        return this.context.createSSLEngine();
    }

    public WeblogicSSLEngine createSSLEngine(String string, int n) throws SSLException {
        if (null != this.jaContext) {
            return this.jaContext.createSSLEngine(string, n);
        }
        return this.context.createSSLEngine(string, n);
    }
}

