/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.SSL.jsseadapter;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import weblogic.security.SSL.jsseadapter.JaLogger;
import weblogic.security.SSL.jsseadapter.JaSSLEngineSynchronizer;
import weblogic.security.utils.SSLIOContext;

final class JaSSLEngineRunner {
    private static final int APP_IN_BUFFER_MARGIN_BYTES = 50;
    private static final int NET_BUFFER_MARGIN_BYTES = 50;
    private static final SSLEngineStateTransition TRANSITION_NEED_TASK = new Transition_NeedTask();
    private static final SSLEngineStateTransition TRANSITION_NEED_UNWRAP = new Transition_NeedUnwrap();
    private static final SSLEngineStateTransition TRANSITION_NEED_WRAP = new Transition_NeedWrap();
    private static final SSLEngineStateTransition TRANSITION_HANDSHAKE_FINISHED = new Transition_HandshakeFinished();
    private static final SSLEngineStateTransition TRANSITION_BUFFER_OVERFLOW_WRAP = new Transition_BufferOverflow_Wrap();
    private static final SSLEngineStateTransition TRANSITION_BUFFER_OVERFLOW_UNWRAP = new Transition_BufferOverflow_Unwrap();
    private static final SSLEngineStateTransition TRANSITION_BUFFER_UNDERFLOW_UNWRAP = new Transition_BufferUnderflow_Unwrap();
    private static final Map<SSLEngineState, SSLEngineStateTransition> sslEngineTransitions;

    private JaSSLEngineRunner() {
    }

    private static boolean isTransitioning(Method method, Context context, TransitionResult transitionResult) {
        if (null == method || null == context || null == transitionResult) {
            throw new IllegalArgumentException("Expected non-null arguments.");
        }
        if (JaLogger.isLoggable(Level.FINEST)) {
            JaLogger.log(Level.FINEST, JaLogger.Component.SSLENGINE, "isTransitioning: method={0}, transitionResult={1}.", new Object[]{method, transitionResult});
        }
        RunnerResult runnerResult = transitionResult.getRunnerResult();
        switch (runnerResult) {
            case INCOMPLETE_NETWORK_READ: 
            case INCOMPLETE_NETWORK_WRITE: 
            case NEED_APPLICATION_READ: {
                if (JaLogger.isLoggable(Level.FINEST)) {
                    JaLogger.log(Level.FINEST, JaLogger.Component.SSLENGINE, "Need data transfer: method={0}, transitionResult={1}.", new Object[]{method, transitionResult});
                }
                return false;
            }
            case OK: {
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected RunnerResult: " + (Object)((Object)runnerResult));
            }
        }
        SSLEngineResult sSLEngineResult = transitionResult.getSslEngineResult();
        SSLEngineResult.Status status = sSLEngineResult.getStatus();
        SSLEngineResult.HandshakeStatus handshakeStatus = sSLEngineResult.getHandshakeStatus();
        SSLEngine sSLEngine = context.getSslEngine();
        context.ensureHandshakeLockIfNeeded(handshakeStatus);
        switch (status) {
            case BUFFER_UNDERFLOW: 
            case BUFFER_OVERFLOW: {
                return true;
            }
            case OK: 
            case CLOSED: {
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected status: " + (Object)((Object)status));
            }
        }
        switch (handshakeStatus) {
            case NEED_UNWRAP: {
                if (sSLEngine.isInboundDone()) {
                    if (JaLogger.isLoggable(Level.FINER)) {
                        JaLogger.log(Level.FINER, JaLogger.Component.SSLENGINE, "Need unwrap but inbound closed: method={0}, transitionResult={1}.", new Object[]{method, transitionResult});
                    }
                    return false;
                }
                return true;
            }
            case NEED_WRAP: {
                if (sSLEngine.isOutboundDone()) {
                    if (JaLogger.isLoggable(Level.FINER)) {
                        JaLogger.log(Level.FINER, JaLogger.Component.SSLENGINE, "Need wrap but outbound closed: method={0}, transitionResult={1}.", new Object[]{method, transitionResult});
                    }
                    return false;
                }
                return true;
            }
            case NEED_TASK: 
            case FINISHED: {
                return true;
            }
            case NOT_HANDSHAKING: {
                if (SSLEngineResult.Status.CLOSED != status) break;
                if (JaLogger.isLoggable(Level.FINER)) {
                    JaLogger.log(Level.FINER, JaLogger.Component.SSLENGINE, "Not handshaking but status was CLOSED: method={0}, transitionResult={1}.", new Object[]{method, transitionResult});
                }
                return false;
            }
            default: {
                throw new IllegalStateException("Unexpected handshake status: " + (Object)((Object)handshakeStatus));
            }
        }
        if (SSLEngineResult.Status.OK != status || SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING != handshakeStatus) {
            throw new IllegalStateException("Unexpected status: " + sSLEngineResult);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RunnerResult doTransitions(Context context, Method method) throws IOException {
        TransitionResult transitionResult;
        SSLEngineStateTransition sSLEngineStateTransition;
        if (null == context) {
            throw new IllegalArgumentException("Expected non-null Context.");
        }
        if (null == method) {
            throw new IllegalArgumentException("Expected non-null Method.");
        }
        SSLEngine sSLEngine = context.getSslEngine();
        switch (method) {
            case UNWRAP: {
                if (sSLEngine.isInboundDone()) {
                    return RunnerResult.CLOSED;
                }
                sSLEngineStateTransition = TRANSITION_NEED_UNWRAP;
                break;
            }
            case WRAP: {
                if (sSLEngine.isOutboundDone()) {
                    return RunnerResult.CLOSED;
                }
                sSLEngineStateTransition = TRANSITION_NEED_WRAP;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected Method=" + (Object)((Object)method) + ".");
            }
        }
        if (JaLogger.isLoggable(Level.FINEST)) {
            JaLogger.log(Level.FINEST, JaLogger.Component.SSLENGINE, "Starting doTransitions: method={0}, starting transition={1}.", new Object[]{method, sSLEngineStateTransition.getClass().getName()});
        }
        SSLEngineResult sSLEngineResult = null;
        try {
            while (JaSSLEngineRunner.isTransitioning(method, context, transitionResult = sSLEngineStateTransition.getNextState(method, context, sSLEngineResult))) {
                sSLEngineResult = transitionResult.getSslEngineResult();
                SSLEngineState sSLEngineState = new SSLEngineState(method, sSLEngineResult);
                sSLEngineStateTransition = sslEngineTransitions.get(sSLEngineState);
                if (null == sSLEngineStateTransition) {
                    throw new IllegalStateException("Unexpected null transition for state: " + sSLEngineState);
                }
                if (!JaLogger.isLoggable(Level.FINEST)) continue;
                JaLogger.log(Level.FINEST, JaLogger.Component.SSLENGINE, "Next transition: method={0}, last result={1}, next transition={2}.", new Object[]{method, sSLEngineResult, sSLEngineStateTransition.getClass().getName()});
            }
        }
        finally {
            context.ensureHandshakeUnlock();
        }
        if (JaLogger.isLoggable(Level.FINEST)) {
            JaLogger.log(Level.FINEST, JaLogger.Component.SSLENGINE, "Ending doTransitions: method={0}, result={1}.", new Object[]{method, transitionResult});
        }
        if (null != (sSLEngineResult = transitionResult.getSslEngineResult()) && sSLEngineResult.getStatus() == SSLEngineResult.Status.CLOSED) {
            return RunnerResult.CLOSED;
        }
        return transitionResult.getRunnerResult();
    }

    private static void log_wrapException(Exception exception) {
        if (JaLogger.isLoggable(Level.FINE)) {
            JaLogger.log(Level.FINE, JaLogger.Component.SSLENGINE, exception, "Unable to complete JaSSLEngineRunner.wrap.", new Object[0]);
        }
    }

    private static void log_unwrapException(Exception exception) {
        if (JaLogger.isLoggable(Level.FINE)) {
            JaLogger.log(Level.FINE, JaLogger.Component.SSLENGINE, exception, "Unable to complete JaSSLEngineRunner.unwrap.", new Object[0]);
        }
    }

    private static void log_closeInboundException(Exception exception, boolean bl) {
        if (JaLogger.isLoggable(Level.FINE)) {
            JaLogger.log(Level.FINE, JaLogger.Component.SSLENGINE, exception, "Unable to complete JaSSLEngineRunner.closeInbound, expectCloseNotify={0}.", bl);
        }
    }

    private static void log_closeOutboundException(Exception exception) {
        if (JaLogger.isLoggable(Level.FINE)) {
            JaLogger.log(Level.FINE, JaLogger.Component.SSLENGINE, exception, "Unable to complete JaSSLEngineRunner.closeOutbound.", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RunnerResult unwrap(Context context) throws IOException {
        try {
            RunnerResult runnerResult;
            if (null == context) {
                throw new IllegalArgumentException("Expected non-null Context.");
            }
            SSLEngine sSLEngine = context.getSslEngine();
            if (null == sSLEngine || sSLEngine.isInboundDone()) {
                runnerResult = RunnerResult.CLOSED;
            } else {
                context.getSync().lock(JaSSLEngineSynchronizer.LockState.INBOUND);
                try {
                    runnerResult = JaSSLEngineRunner.doTransitions(context, Method.UNWRAP);
                }
                finally {
                    context.getSync().unlock();
                }
            }
            if (JaLogger.isLoggable(Level.FINEST)) {
                JaLogger.log(Level.FINEST, JaLogger.Component.SSLENGINE, "JaSSLEngineRunner.unwrap result={0}.", new Object[]{runnerResult});
            }
            return runnerResult;
        }
        catch (InterruptedIOException interruptedIOException) {
            throw interruptedIOException;
        }
        catch (SSLException sSLException) {
            JaSSLEngineRunner.log_unwrapException(sSLException);
            throw sSLException;
        }
        catch (IOException iOException) {
            JaSSLEngineRunner.log_unwrapException(iOException);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            JaSSLEngineRunner.log_unwrapException(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RunnerResult wrap(Context context) throws IOException {
        try {
            RunnerResult runnerResult;
            if (null == context) {
                throw new IllegalArgumentException("Expected non-null Context.");
            }
            SSLEngine sSLEngine = context.getSslEngine();
            if (null == sSLEngine || sSLEngine.isOutboundDone()) {
                runnerResult = RunnerResult.CLOSED;
            } else {
                context.getSync().lock(JaSSLEngineSynchronizer.LockState.OUTBOUND);
                try {
                    runnerResult = JaSSLEngineRunner.doTransitions(context, Method.WRAP);
                }
                finally {
                    context.getSync().unlock();
                }
            }
            if (JaLogger.isLoggable(Level.FINEST)) {
                JaLogger.log(Level.FINEST, JaLogger.Component.SSLENGINE, "JaSSLEngineRunner.wrap result={0}.", new Object[]{runnerResult});
            }
            return runnerResult;
        }
        catch (InterruptedIOException interruptedIOException) {
            throw interruptedIOException;
        }
        catch (SSLException sSLException) {
            JaSSLEngineRunner.log_wrapException(sSLException);
            try {
                JaSSLEngineRunner.closeOutbound(context);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw sSLException;
        }
        catch (IOException iOException) {
            JaSSLEngineRunner.log_wrapException(iOException);
            try {
                JaSSLEngineRunner.closeOutbound(context);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            JaSSLEngineRunner.log_wrapException(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RunnerResult closeOutbound(Context context) throws IOException {
        try {
            RunnerResult runnerResult;
            if (null == context) {
                throw new IllegalArgumentException("Expected non-null Context.");
            }
            SSLEngine sSLEngine = context.getSslEngine();
            if (null == sSLEngine || sSLEngine.isOutboundDone()) {
                runnerResult = RunnerResult.CLOSED;
            } else {
                context.getSync().lock(JaSSLEngineSynchronizer.LockState.OUTBOUND);
                try {
                    sSLEngine.closeOutbound();
                    runnerResult = JaSSLEngineRunner.doTransitions(context, Method.WRAP);
                }
                finally {
                    context.getSync().unlock();
                }
            }
            if (JaLogger.isLoggable(Level.FINEST)) {
                JaLogger.log(Level.FINEST, JaLogger.Component.SSLENGINE, "JaSSLEngineRunner.closeOutbound result={0}.", new Object[]{runnerResult});
            }
            return runnerResult;
        }
        catch (InterruptedIOException interruptedIOException) {
            throw interruptedIOException;
        }
        catch (IOException iOException) {
            JaSSLEngineRunner.log_closeOutboundException(iOException);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            JaSSLEngineRunner.log_closeOutboundException(runtimeException);
            throw runtimeException;
        }
    }

    static boolean isOutboundDone(Context context) {
        try {
            boolean bl;
            if (null == context) {
                throw new IllegalArgumentException("Expected non-null Context.");
            }
            SSLEngine sSLEngine = context.getSslEngine();
            boolean bl2 = bl = null == sSLEngine || sSLEngine.isOutboundDone();
            if (JaLogger.isLoggable(Level.FINEST)) {
                JaLogger.log(Level.FINEST, JaLogger.Component.SSLENGINE, "JaSSLEngineRunner.isOutboundDone result={0}, engine={1}", bl, sSLEngine);
            }
            return bl;
        }
        catch (RuntimeException runtimeException) {
            if (JaLogger.isLoggable(Level.FINE)) {
                JaLogger.log(Level.FINE, JaLogger.Component.SSLENGINE, runtimeException, "Unable to complete JaSSLEngineRunner.isOutboundDone.", new Object[0]);
            }
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RunnerResult closeInbound(Context context, boolean bl) throws IOException {
        try {
            RunnerResult runnerResult;
            if (null == context) {
                throw new IllegalArgumentException("Expected non-null Context.");
            }
            SSLEngine sSLEngine = context.getSslEngine();
            if (null == sSLEngine || sSLEngine.isInboundDone()) {
                runnerResult = RunnerResult.CLOSED;
            } else {
                context.getSync().lock(JaSSLEngineSynchronizer.LockState.INBOUND);
                try {
                    runnerResult = JaSSLEngineRunner.doTransitions(context, Method.UNWRAP);
                    if (bl && RunnerResult.CLOSED != runnerResult) {
                        sSLEngine.closeInbound();
                    }
                }
                finally {
                    context.getSync().unlock();
                }
            }
            if (JaLogger.isLoggable(Level.FINEST)) {
                JaLogger.log(Level.FINEST, JaLogger.Component.SSLENGINE, "JaSSLEngineRunner.closeInbound result={0}, expectCloseNotify={1}.", new Object[]{runnerResult, bl});
            }
            return runnerResult;
        }
        catch (InterruptedIOException interruptedIOException) {
            throw interruptedIOException;
        }
        catch (IOException iOException) {
            JaSSLEngineRunner.log_closeInboundException(iOException, bl);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            JaSSLEngineRunner.log_closeInboundException(runtimeException, bl);
            throw runtimeException;
        }
    }

    static boolean isInboundDone(Context context) {
        try {
            boolean bl;
            if (null == context) {
                throw new IllegalArgumentException("Expected non-null Context.");
            }
            SSLEngine sSLEngine = context.getSslEngine();
            boolean bl2 = bl = null == sSLEngine || sSLEngine.isInboundDone();
            if (JaLogger.isLoggable(Level.FINEST)) {
                JaLogger.log(Level.FINEST, JaLogger.Component.SSLENGINE, "JaSSLEngineRunner.isInboundDone result={0}, engine={1}", bl, sSLEngine);
            }
            return bl;
        }
        catch (RuntimeException runtimeException) {
            if (JaLogger.isLoggable(Level.FINE)) {
                JaLogger.log(Level.FINE, JaLogger.Component.SSLENGINE, runtimeException, "Unable to complete JaSSLEngineRunner.isInboundDone.", new Object[0]);
            }
            throw runtimeException;
        }
    }

    static void close(Context context, boolean bl) throws IOException {
        if (JaLogger.isLoggable(Level.FINEST)) {
            JaLogger.log(Level.FINEST, JaLogger.Component.SSLENGINE, "Attempting to execute JaSSLEngineRunner.close, expectCloseNotify={0}.", bl);
        }
        if (null == context) {
            if (JaLogger.isLoggable(Level.FINER)) {
                JaLogger.log(Level.FINER, JaLogger.Component.SSLENGINE, "JaSSLEngineRunner.Context is null, no SSL context to close.", new Object[0]);
            }
            return;
        }
        RunnerResult runnerResult = JaSSLEngineRunner.closeOutbound(context);
        if (JaLogger.isLoggable(Level.FINEST)) {
            JaLogger.log(Level.FINEST, JaLogger.Component.SSLENGINE, "During JaSSLEngineRunner.close, closeOutbound result={0}", new Object[]{runnerResult});
        }
        runnerResult = JaSSLEngineRunner.closeInbound(context, bl);
        if (JaLogger.isLoggable(Level.FINEST)) {
            JaLogger.log(Level.FINEST, JaLogger.Component.SSLENGINE, "During JaSSLEngineRunner.close, closeInbound result={0}", new Object[]{runnerResult});
        }
    }

    static {
        HashMap<SSLEngineState, SSLEngineStateTransition> hashMap = new HashMap<SSLEngineState, SSLEngineStateTransition>(64);
        hashMap.put(new SSLEngineState(Method.WRAP, SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING), null);
        hashMap.put(new SSLEngineState(Method.WRAP, SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_TASK), TRANSITION_NEED_TASK);
        hashMap.put(new SSLEngineState(Method.WRAP, SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_UNWRAP), TRANSITION_NEED_UNWRAP);
        hashMap.put(new SSLEngineState(Method.WRAP, SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_WRAP), TRANSITION_NEED_WRAP);
        hashMap.put(new SSLEngineState(Method.WRAP, SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.FINISHED), TRANSITION_HANDSHAKE_FINISHED);
        hashMap.put(new SSLEngineState(Method.WRAP, SSLEngineResult.Status.BUFFER_OVERFLOW, SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING), TRANSITION_BUFFER_OVERFLOW_WRAP);
        hashMap.put(new SSLEngineState(Method.WRAP, SSLEngineResult.Status.BUFFER_OVERFLOW, SSLEngineResult.HandshakeStatus.NEED_TASK), null);
        hashMap.put(new SSLEngineState(Method.WRAP, SSLEngineResult.Status.BUFFER_OVERFLOW, SSLEngineResult.HandshakeStatus.NEED_UNWRAP), TRANSITION_BUFFER_OVERFLOW_UNWRAP);
        hashMap.put(new SSLEngineState(Method.WRAP, SSLEngineResult.Status.BUFFER_OVERFLOW, SSLEngineResult.HandshakeStatus.NEED_WRAP), TRANSITION_BUFFER_OVERFLOW_WRAP);
        hashMap.put(new SSLEngineState(Method.WRAP, SSLEngineResult.Status.BUFFER_OVERFLOW, SSLEngineResult.HandshakeStatus.FINISHED), null);
        hashMap.put(new SSLEngineState(Method.WRAP, SSLEngineResult.Status.BUFFER_UNDERFLOW, SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING), null);
        hashMap.put(new SSLEngineState(Method.WRAP, SSLEngineResult.Status.BUFFER_UNDERFLOW, SSLEngineResult.HandshakeStatus.NEED_TASK), null);
        hashMap.put(new SSLEngineState(Method.WRAP, SSLEngineResult.Status.BUFFER_UNDERFLOW, SSLEngineResult.HandshakeStatus.NEED_UNWRAP), TRANSITION_BUFFER_UNDERFLOW_UNWRAP);
        hashMap.put(new SSLEngineState(Method.WRAP, SSLEngineResult.Status.BUFFER_UNDERFLOW, SSLEngineResult.HandshakeStatus.NEED_WRAP), null);
        hashMap.put(new SSLEngineState(Method.WRAP, SSLEngineResult.Status.BUFFER_UNDERFLOW, SSLEngineResult.HandshakeStatus.FINISHED), null);
        hashMap.put(new SSLEngineState(Method.WRAP, SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING), null);
        hashMap.put(new SSLEngineState(Method.WRAP, SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NEED_TASK), TRANSITION_NEED_TASK);
        hashMap.put(new SSLEngineState(Method.WRAP, SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NEED_UNWRAP), TRANSITION_NEED_UNWRAP);
        hashMap.put(new SSLEngineState(Method.WRAP, SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NEED_WRAP), TRANSITION_NEED_WRAP);
        hashMap.put(new SSLEngineState(Method.WRAP, SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.FINISHED), null);
        hashMap.put(new SSLEngineState(Method.UNWRAP, SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING), null);
        hashMap.put(new SSLEngineState(Method.UNWRAP, SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_TASK), TRANSITION_NEED_TASK);
        hashMap.put(new SSLEngineState(Method.UNWRAP, SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_UNWRAP), TRANSITION_NEED_UNWRAP);
        hashMap.put(new SSLEngineState(Method.UNWRAP, SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_WRAP), TRANSITION_NEED_WRAP);
        hashMap.put(new SSLEngineState(Method.UNWRAP, SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.FINISHED), TRANSITION_HANDSHAKE_FINISHED);
        hashMap.put(new SSLEngineState(Method.UNWRAP, SSLEngineResult.Status.BUFFER_OVERFLOW, SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING), TRANSITION_BUFFER_OVERFLOW_UNWRAP);
        hashMap.put(new SSLEngineState(Method.UNWRAP, SSLEngineResult.Status.BUFFER_OVERFLOW, SSLEngineResult.HandshakeStatus.NEED_TASK), null);
        hashMap.put(new SSLEngineState(Method.UNWRAP, SSLEngineResult.Status.BUFFER_OVERFLOW, SSLEngineResult.HandshakeStatus.NEED_UNWRAP), TRANSITION_BUFFER_OVERFLOW_UNWRAP);
        hashMap.put(new SSLEngineState(Method.UNWRAP, SSLEngineResult.Status.BUFFER_OVERFLOW, SSLEngineResult.HandshakeStatus.NEED_WRAP), TRANSITION_BUFFER_OVERFLOW_WRAP);
        hashMap.put(new SSLEngineState(Method.UNWRAP, SSLEngineResult.Status.BUFFER_OVERFLOW, SSLEngineResult.HandshakeStatus.FINISHED), null);
        hashMap.put(new SSLEngineState(Method.UNWRAP, SSLEngineResult.Status.BUFFER_UNDERFLOW, SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING), TRANSITION_BUFFER_UNDERFLOW_UNWRAP);
        hashMap.put(new SSLEngineState(Method.UNWRAP, SSLEngineResult.Status.BUFFER_UNDERFLOW, SSLEngineResult.HandshakeStatus.NEED_TASK), null);
        hashMap.put(new SSLEngineState(Method.UNWRAP, SSLEngineResult.Status.BUFFER_UNDERFLOW, SSLEngineResult.HandshakeStatus.NEED_UNWRAP), TRANSITION_BUFFER_UNDERFLOW_UNWRAP);
        hashMap.put(new SSLEngineState(Method.UNWRAP, SSLEngineResult.Status.BUFFER_UNDERFLOW, SSLEngineResult.HandshakeStatus.NEED_WRAP), null);
        hashMap.put(new SSLEngineState(Method.UNWRAP, SSLEngineResult.Status.BUFFER_UNDERFLOW, SSLEngineResult.HandshakeStatus.FINISHED), null);
        hashMap.put(new SSLEngineState(Method.UNWRAP, SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING), null);
        hashMap.put(new SSLEngineState(Method.UNWRAP, SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NEED_TASK), TRANSITION_NEED_TASK);
        hashMap.put(new SSLEngineState(Method.UNWRAP, SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NEED_UNWRAP), TRANSITION_NEED_UNWRAP);
        hashMap.put(new SSLEngineState(Method.UNWRAP, SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NEED_WRAP), TRANSITION_NEED_WRAP);
        hashMap.put(new SSLEngineState(Method.UNWRAP, SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.FINISHED), null);
        sslEngineTransitions = Collections.unmodifiableMap(hashMap);
    }

    private static class Transition_BufferUnderflow_Unwrap
    implements SSLEngineStateTransition {
        private Transition_BufferUnderflow_Unwrap() {
        }

        public TransitionResult getNextState(Method method, Context context, SSLEngineResult sSLEngineResult) throws IOException {
            SSLSession sSLSession = context.getSslEngine().getSession();
            int n = sSLSession.getPacketBufferSize() + 50;
            if (n > context.getBufferNetIn().capacity()) {
                ByteBuffer byteBuffer = ByteBuffer.allocate(n);
                context.getBufferNetIn().flip();
                byteBuffer.put(context.getBufferNetIn());
                context.setBufferNetIn(byteBuffer);
            }
            if (0 == context.fillBufferNetIn()) {
                return new TransitionResult(RunnerResult.INCOMPLETE_NETWORK_READ, sSLEngineResult);
            }
            return TRANSITION_NEED_UNWRAP.getNextState(method, context, sSLEngineResult);
        }
    }

    private static class Transition_BufferOverflow_Unwrap
    implements SSLEngineStateTransition {
        private Transition_BufferOverflow_Unwrap() {
        }

        public TransitionResult getNextState(Method method, Context context, SSLEngineResult sSLEngineResult) throws IOException {
            SSLSession sSLSession = context.getSslEngine().getSession();
            int n = sSLSession.getApplicationBufferSize() + 50;
            if (n <= context.getBufferAppIn().capacity()) {
                return new TransitionResult(RunnerResult.NEED_APPLICATION_READ, sSLEngineResult);
            }
            Object object = ByteBuffer.allocate(n);
            context.getBufferAppIn().flip();
            ((ByteBuffer)object).put(context.getBufferAppIn());
            context.setBufferAppIn((ByteBuffer)object);
            object = TRANSITION_NEED_UNWRAP.getNextState(method, context, sSLEngineResult);
            return object;
        }
    }

    private static class Transition_BufferOverflow_Wrap
    implements SSLEngineStateTransition {
        private Transition_BufferOverflow_Wrap() {
        }

        public TransitionResult getNextState(Method method, Context context, SSLEngineResult sSLEngineResult) throws IOException {
            Object object;
            SSLSession sSLSession = context.getSslEngine().getSession();
            int n = sSLSession.getPacketBufferSize() + 50;
            if (n > context.getBufferNetOut().capacity()) {
                object = ByteBuffer.allocate(n);
                context.getBufferNetOut().flip();
                ((ByteBuffer)object).put(context.getBufferNetOut());
                context.setBufferNetOut((ByteBuffer)object);
            } else if (!context.flushBufferNetOut()) {
                TransitionResult transitionResult = new TransitionResult(RunnerResult.INCOMPLETE_NETWORK_WRITE, sSLEngineResult);
                return transitionResult;
            }
            object = TRANSITION_NEED_WRAP.getNextState(method, context, sSLEngineResult);
            return object;
        }
    }

    private static class Transition_NeedTask
    implements SSLEngineStateTransition {
        private Transition_NeedTask() {
        }

        public TransitionResult getNextState(Method method, Context context, SSLEngineResult sSLEngineResult) throws IOException {
            Runnable runnable;
            while ((runnable = context.getSslEngine().getDelegatedTask()) != null) {
                if (JaLogger.isLoggable(Level.FINEST)) {
                    JaLogger.log(Level.FINEST, JaLogger.Component.SSLENGINE, "Transition_NeedTask: Running delegated task: method={0}, last result={1}, task={2}.", new Object[]{method, sSLEngineResult, runnable.getClass().getName()});
                }
                runnable.run();
            }
            SSLEngineResult.HandshakeStatus handshakeStatus = context.getSslEngine().getHandshakeStatus();
            return new TransitionResult(RunnerResult.OK, new SSLEngineResult(SSLEngineResult.Status.OK, handshakeStatus, 0, 0));
        }
    }

    private static class Transition_HandshakeFinished
    implements SSLEngineStateTransition {
        private Transition_HandshakeFinished() {
        }

        public TransitionResult getNextState(Method method, Context context, SSLEngineResult sSLEngineResult) throws IOException {
            TransitionResult transitionResult;
            context.getSync().unlock();
            switch (method) {
                case WRAP: {
                    transitionResult = TRANSITION_NEED_WRAP.getNextState(method, context, sSLEngineResult);
                    break;
                }
                case UNWRAP: {
                    transitionResult = TRANSITION_NEED_UNWRAP.getNextState(method, context, sSLEngineResult);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported Method " + (Object)((Object)method));
                }
            }
            return transitionResult;
        }
    }

    private static class Transition_NeedWrap
    implements SSLEngineStateTransition {
        private Transition_NeedWrap() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TransitionResult getNextState(Method method, Context context, SSLEngineResult sSLEngineResult) throws IOException {
            TransitionResult transitionResult;
            try {
                context.getBufferAppOut().flip();
                transitionResult = new TransitionResult(RunnerResult.OK, context.getSslEngine().wrap(context.getBufferAppOut(), context.getBufferNetOut()));
            }
            finally {
                context.getBufferAppOut().compact();
            }
            SSLEngineResult sSLEngineResult2 = transitionResult.getSslEngineResult();
            if (sSLEngineResult2.bytesProduced() > 0 && !context.flushBufferNetOut()) {
                transitionResult = new TransitionResult(RunnerResult.INCOMPLETE_NETWORK_WRITE, transitionResult.getSslEngineResult());
                return transitionResult;
            }
            return transitionResult;
        }
    }

    private static class Transition_NeedUnwrap
    implements SSLEngineStateTransition {
        private Transition_NeedUnwrap() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TransitionResult getNextState(Method method, Context context, SSLEngineResult sSLEngineResult) throws IOException {
            TransitionResult transitionResult;
            int n;
            try {
                context.getBufferNetIn().flip();
                n = context.getBufferNetIn().remaining();
            }
            finally {
                context.getBufferNetIn().compact();
            }
            if (n <= 0 && 0 == context.fillBufferNetIn()) {
                return new TransitionResult(RunnerResult.INCOMPLETE_NETWORK_READ, sSLEngineResult);
            }
            try {
                context.getBufferNetIn().flip();
                transitionResult = new TransitionResult(RunnerResult.OK, context.getSslEngine().unwrap(context.getBufferNetIn(), context.getBufferAppIn()));
            }
            finally {
                context.getBufferNetIn().compact();
            }
            return transitionResult;
        }
    }

    private static interface SSLEngineStateTransition {
        public TransitionResult getNextState(Method var1, Context var2, SSLEngineResult var3) throws IOException;
    }

    static class SSLEngineState {
        private final Method method;
        private final SSLEngineResult.Status status;
        private final SSLEngineResult.HandshakeStatus handshakeStatus;

        private SSLEngineState(Method method, SSLEngineResult sSLEngineResult) {
            this(method, sSLEngineResult.getStatus(), sSLEngineResult.getHandshakeStatus());
        }

        private SSLEngineState(Method method, SSLEngineResult.Status status, SSLEngineResult.HandshakeStatus handshakeStatus) {
            if (null == method || null == status || null == handshakeStatus) {
                throw new IllegalArgumentException("Expected non-null arguments.");
            }
            this.method = method;
            this.status = status;
            this.handshakeStatus = handshakeStatus;
        }

        Method getMethod() {
            return this.method;
        }

        SSLEngineResult.Status getStatus() {
            return this.status;
        }

        SSLEngineResult.HandshakeStatus getHandshakeStatus() {
            return this.handshakeStatus;
        }

        public int hashCode() {
            return this.handshakeStatus.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof SSLEngineState)) {
                return false;
            }
            SSLEngineState sSLEngineState = (SSLEngineState)object;
            return sSLEngineState.method == this.method && sSLEngineState.status == this.status && sSLEngineState.handshakeStatus == this.handshakeStatus;
        }

        public String toString() {
            return MessageFormat.format("SSLEngine State: Method={0}, Status={1}, HandshakeStatus={2}", new Object[]{this.method, this.status, this.handshakeStatus});
        }
    }

    static final class TransitionResult {
        private final RunnerResult runnerResult;
        private final SSLEngineResult sslEngineResult;

        private TransitionResult(RunnerResult runnerResult, SSLEngineResult sSLEngineResult) {
            if (null == runnerResult) {
                throw new IllegalArgumentException("Expected non-null RunnerResult.");
            }
            this.runnerResult = runnerResult;
            this.sslEngineResult = sSLEngineResult;
        }

        RunnerResult getRunnerResult() {
            return this.runnerResult;
        }

        SSLEngineResult getSslEngineResult() {
            return this.sslEngineResult;
        }

        public String toString() {
            return MessageFormat.format("TransitionResult: RunnerResult={0}, SSLEngineResult={1}", new Object[]{this.runnerResult, this.sslEngineResult});
        }
    }

    static final class Context {
        private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
        private final JaSSLEngineSynchronizer sync = new JaSSLEngineSynchronizer();
        private SSLEngine sslEngine;
        private ByteBuffer bufferNetIn = EMPTY_BUFFER;
        private ByteBuffer bufferAppIn = EMPTY_BUFFER;
        private ByteBuffer bufferAppOut = EMPTY_BUFFER;
        private ByteBuffer bufferNetOut = EMPTY_BUFFER;
        private ReadableByteChannel networkReadableByteChannel;
        private WritableByteChannel networkWritableByteChannel;
        private SSLIOContext sslIoContext;

        Context() {
        }

        SSLEngine getSslEngine() {
            return this.sslEngine;
        }

        private void setSslEngine(SSLEngine sSLEngine) {
            this.sslEngine = sSLEngine;
        }

        private ByteBuffer getBufferNetIn() {
            return this.bufferNetIn;
        }

        private void setBufferNetIn(ByteBuffer byteBuffer) {
            this.bufferNetIn = byteBuffer;
        }

        ByteBuffer getBufferAppIn() {
            return this.bufferAppIn;
        }

        void setBufferAppIn(ByteBuffer byteBuffer) {
            this.bufferAppIn = byteBuffer;
        }

        ByteBuffer getBufferAppOut() {
            return this.bufferAppOut;
        }

        void setBufferAppOut(ByteBuffer byteBuffer) {
            if (null == byteBuffer) {
                byteBuffer = EMPTY_BUFFER;
            }
            this.bufferAppOut = byteBuffer;
        }

        private ByteBuffer getBufferNetOut() {
            return this.bufferNetOut;
        }

        private void setBufferNetOut(ByteBuffer byteBuffer) {
            this.bufferNetOut = byteBuffer;
        }

        private ReadableByteChannel getNetworkReadableByteChannel() {
            return this.networkReadableByteChannel;
        }

        private void setNetworkReadableByteChannel(ReadableByteChannel readableByteChannel) {
            this.networkReadableByteChannel = readableByteChannel;
        }

        private WritableByteChannel getNetworkWritableByteChannel() {
            return this.networkWritableByteChannel;
        }

        private void setNetworkWritableByteChannel(WritableByteChannel writableByteChannel) {
            this.networkWritableByteChannel = writableByteChannel;
        }

        JaSSLEngineSynchronizer getSync() {
            return this.sync;
        }

        SSLIOContext getSslIoContext() {
            return this.sslIoContext;
        }

        private void setSslIoContext(SSLIOContext sSLIOContext) {
            this.sslIoContext = sSLIOContext;
        }

        boolean notCompleteSSLRecord() {
            return this.sslIoContext != null && this.sslIoContext.isMuxerActivated() && !this.sslIoContext.hasSSLRecord();
        }

        InputStream getMuxerInputStream() {
            return this.sslIoContext == null ? null : this.sslIoContext.getMuxerIS();
        }

        boolean isMuxerActivated() {
            return this.sslIoContext != null && this.sslIoContext.isMuxerActivated();
        }

        void init(SSLEngine sSLEngine, ReadableByteChannel readableByteChannel, WritableByteChannel writableByteChannel, SSLIOContext sSLIOContext) throws IOException {
            if (null == sSLEngine) {
                throw new IllegalArgumentException("Expected non-null SSLEngine.");
            }
            if (null == readableByteChannel) {
                throw new IllegalArgumentException("Expected non-null networkReadableByteChannel.");
            }
            if (null == writableByteChannel) {
                throw new IllegalArgumentException("Expected non-null networkWritableByteChannel.");
            }
            this.setSslEngine(sSLEngine);
            SSLSession sSLSession = sSLEngine.getSession();
            int n = sSLSession.getApplicationBufferSize() + 50;
            int n2 = sSLSession.getPacketBufferSize() + 50;
            this.setBufferAppIn(ByteBuffer.allocate(n));
            this.setBufferAppOut(EMPTY_BUFFER);
            this.setBufferNetIn(ByteBuffer.allocate(n2));
            this.setBufferNetOut(ByteBuffer.allocate(n2));
            this.setNetworkReadableByteChannel(readableByteChannel);
            this.setNetworkWritableByteChannel(writableByteChannel);
            this.setSslIoContext(sSLIOContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean flushBufferNetOut() throws IOException {
            ByteBuffer byteBuffer = this.getBufferNetOut();
            try {
                byteBuffer.flip();
                if (byteBuffer.remaining() <= 0) {
                    boolean bl = true;
                    return bl;
                }
                WritableByteChannel writableByteChannel = this.getNetworkWritableByteChannel();
                int n = writableByteChannel.write(byteBuffer);
                int n2 = byteBuffer.remaining();
                if (n2 > 0) {
                    if (JaLogger.isLoggable(Level.FINER)) {
                        JaLogger.log(Level.FINER, JaLogger.Component.SSLENGINE, "Unable to completely flush outbound network buffer. Remaining bytes={0}, Flushed bytes={1}", n2, n);
                    }
                    boolean bl = false;
                    return bl;
                }
                if (JaLogger.isLoggable(Level.FINEST)) {
                    JaLogger.log(Level.FINEST, JaLogger.Component.SSLENGINE, "Completely flushed outbound network buffer. Flushed bytes={0}", n);
                }
                boolean bl = true;
                return bl;
            }
            finally {
                byteBuffer.compact();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int fillBufferNetIn() throws IOException {
            int n;
            int n2;
            ByteBuffer byteBuffer = this.getBufferNetIn();
            if (byteBuffer.remaining() <= 0) {
                if (JaLogger.isLoggable(Level.FINEST)) {
                    JaLogger.log(Level.FINEST, JaLogger.Component.SSLENGINE, "No data read, bufferNetIn is full.", new Object[0]);
                }
                return 0;
            }
            try {
                byteBuffer.flip();
                if (byteBuffer.remaining() > 0) {
                    if (JaLogger.isLoggable(Level.FINER)) {
                        JaLogger.log(Level.FINER, JaLogger.Component.SSLENGINE, "Attempted to fill bufferNetIn before reading entire previous SSL record.", new Object[0]);
                    }
                    int n3 = 0;
                    return n3;
                }
            }
            finally {
                byteBuffer.compact();
            }
            if (this.notCompleteSSLRecord()) {
                throw new InterruptedIOException();
            }
            while (0 != (n2 = this.getBytesPending())) {
                int n4;
                Object object;
                Object object2;
                if (n2 > byteBuffer.remaining()) {
                    object2 = MessageFormat.format("Unexpectedly large SSL Record size, bytesPending={0}, bufferNetIn.remaining={1}.", n2, byteBuffer.remaining());
                    throw new IllegalStateException((String)object2);
                }
                object2 = this.getMuxerInputStream();
                if (object2 != null) {
                    object = new byte[n2];
                    int n5 = 0;
                    int n6 = ((byte[])object).length;
                    while ((n4 = ((InputStream)object2).read((byte[])object, n5, n6)) < n6) {
                        if (0 == n4) {
                            String string = MessageFormat.format("Unable to read complete SSL record from muxer input stream, no bytes available, remaining={0} bytes.", n6);
                            if (JaLogger.isLoggable(Level.FINE)) {
                                JaLogger.log(Level.FINE, JaLogger.Component.SSLENGINE, string, new Object[0]);
                            }
                            throw new IllegalStateException(string);
                        }
                        if (-1 == n4) {
                            SSLEngine sSLEngine = this.getSslEngine();
                            if (null != sSLEngine) {
                                sSLEngine.closeInbound();
                            }
                            throw new ClosedChannelException();
                        }
                        n6 -= n4;
                        n5 += n4;
                        Thread.currentThread();
                        Thread.yield();
                    }
                    byteBuffer.put((byte[])object);
                } else {
                    int n7 = byteBuffer.limit();
                    try {
                        byteBuffer.limit(byteBuffer.position() + n2);
                        ReadableByteChannel readableByteChannel = this.getNetworkReadableByteChannel();
                        n4 = readableByteChannel.read(byteBuffer);
                    }
                    finally {
                        byteBuffer.limit(n7);
                    }
                }
                if (-1 == n4) {
                    object = this.getSslEngine();
                    if (null != object) {
                        ((SSLEngine)object).closeInbound();
                    }
                    throw new ClosedChannelException();
                }
                if (0 != n4) continue;
                if (this.isMuxerActivated()) {
                    throw new IllegalStateException("Muxer is activated, but available bytes are not readable.");
                }
                return 0;
            }
            try {
                byteBuffer.flip();
                n = byteBuffer.remaining();
            }
            finally {
                byteBuffer.compact();
            }
            return n;
        }

        private int getBytesPending() throws IOException {
            ByteBuffer byteBuffer = this.getBufferNetIn();
            int n = byteBuffer.position();
            int n2 = 0;
            if (n == 0) {
                return 1;
            }
            if ((byteBuffer.get(0) & 0x80) == 128) {
                if (n < 2) {
                    return 2 - n;
                }
                int n3 = Context.readUInt8(byteBuffer.get(0));
                int n4 = Context.readUInt8(byteBuffer.get(1));
                n2 = (n3 & 0x7F) << 8 | n4 + 2;
            } else {
                if (n < 5) {
                    return 5 - n;
                }
                n2 = Context.readUInt16(byteBuffer.get(3), byteBuffer.get(4)) + 5;
                if (n2 < 0) {
                    String string = MessageFormat.format("Illegal negative SSL record length field, value={0}.", n2);
                    throw new IOException(string);
                }
            }
            if (n2 < n) {
                String string = MessageFormat.format("Buffer filled beyond SSL record length. SSLRecord length={0}, byte previously read={1}.", n2, n);
                throw new IllegalStateException(string);
            }
            return n2 - n;
        }

        private static int readUInt8(byte by) {
            return by & 0xFF;
        }

        private static int readUInt16(byte by, byte by2) {
            int n = Context.readUInt8(by);
            int n2 = Context.readUInt8(by2);
            return (n << 8) + n2;
        }

        private void ensureHandshakeLockIfNeeded(SSLEngineResult.HandshakeStatus handshakeStatus) {
            if (null == handshakeStatus) {
                throw new IllegalArgumentException("Non-null HandshakeStatus expected.");
            }
            if (this.getSync().getLockState() == JaSSLEngineSynchronizer.LockState.HANDSHAKE) {
                return;
            }
            if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP && this.getSync().getLockState() == JaSSLEngineSynchronizer.LockState.INBOUND) {
                this.getSync().lock(JaSSLEngineSynchronizer.LockState.HANDSHAKE);
            } else if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP && this.getSync().getLockState() == JaSSLEngineSynchronizer.LockState.OUTBOUND) {
                this.getSync().lock(JaSSLEngineSynchronizer.LockState.HANDSHAKE);
            }
        }

        private void ensureHandshakeUnlock() {
            while (this.getSync().getLockState() == JaSSLEngineSynchronizer.LockState.HANDSHAKE) {
                this.getSync().unlock();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RunnerResult {
        OK,
        INCOMPLETE_NETWORK_READ,
        INCOMPLETE_NETWORK_WRITE,
        NEED_APPLICATION_READ,
        CLOSED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Method {
        WRAP,
        UNWRAP;

    }
}

