/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.SSL.jsseadapter;

import java.util.Stack;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import weblogic.security.SSL.jsseadapter.JaLogger;

final class JaSSLEngineSynchronizer {
    private final ThreadLocal<Stack<LockState>> lockStateStack = new ThreadLocal<Stack<LockState>>(){

        @Override
        protected Stack<LockState> initialValue() {
            return new Stack<LockState>();
        }
    };
    private final Lock inboundLock;
    private final Lock outboundLock;

    LockState getLockState() {
        Stack<LockState> stack = this.lockStateStack.get();
        LockState lockState = stack.empty() ? LockState.NONE : stack.peek();
        return lockState;
    }

    int getLockStateStackSize() {
        Stack<LockState> stack = this.lockStateStack.get();
        return stack.size();
    }

    void lock(LockState lockState) {
        if (null == lockState) {
            throw new IllegalArgumentException("Non-null nextState expected.");
        }
        if (LockState.NONE == lockState) {
            throw new IllegalArgumentException("NONE state may not be set; use unlock instead.");
        }
        LockState lockState2 = this.getLockState();
        if (lockState2 != lockState) {
            if (LockState.NONE == lockState2 && LockState.INBOUND == lockState) {
                this.inboundLock.lock();
            } else if (LockState.NONE == lockState2 && LockState.OUTBOUND == lockState) {
                this.outboundLock.lock();
            } else if (LockState.INBOUND == lockState2 && LockState.HANDSHAKE == lockState) {
                this.inboundLock.unlock();
                this.outboundLock.lock();
                this.inboundLock.lock();
            } else if (LockState.OUTBOUND == lockState2 && LockState.HANDSHAKE == lockState) {
                this.inboundLock.lock();
            } else {
                if (JaLogger.isLoggable(Level.FINE)) {
                    JaLogger.log(Level.FINE, JaLogger.Component.SSLENGINE, "[{0}] Illegal state for lock: currentLockState={1}, nextState={2}.", new Object[]{this.getClass().getName(), lockState2, lockState});
                }
                throw new IllegalStateException("currentLockState=" + (Object)((Object)lockState2) + ", nextState=" + (Object)((Object)lockState));
            }
        }
        this.lockStateStack.get().push(lockState);
        if (JaLogger.isLoggable(Level.FINEST)) {
            JaLogger.log(Level.FINEST, JaLogger.Component.SSLENGINE, "[{0}] lock completed, pushed lock state \"{1}\", previous lock state \"{2}\", post-push stack size={3}", new Object[]{this.getClass().getName(), lockState, lockState2, this.lockStateStack.get().size()});
        }
    }

    void unlock() {
        LockState lockState;
        Stack<LockState> stack = this.lockStateStack.get();
        if (stack.empty()) {
            if (JaLogger.isLoggable(Level.FINE)) {
                JaLogger.log(Level.FINE, JaLogger.Component.SSLENGINE, "[{0}] unlock called with empty stack. Not matched with lock?", this.getClass().getName());
            }
            return;
        }
        LockState lockState2 = stack.pop();
        if (lockState2 == (lockState = this.getLockState())) {
            if (JaLogger.isLoggable(Level.FINEST)) {
                JaLogger.log(Level.FINEST, JaLogger.Component.SSLENGINE, "[{0}] unlock called with no state change, state={1}", new Object[]{this.getClass().getName(), lockState2});
            }
            return;
        }
        if (LockState.HANDSHAKE == lockState2 && LockState.INBOUND == lockState) {
            this.outboundLock.unlock();
        } else if (LockState.HANDSHAKE == lockState2 && LockState.OUTBOUND == lockState) {
            this.inboundLock.unlock();
        } else if (LockState.INBOUND == lockState2 && LockState.NONE == lockState) {
            this.inboundLock.unlock();
        } else if (LockState.OUTBOUND == lockState2 && LockState.NONE == lockState) {
            this.outboundLock.unlock();
        } else {
            if (JaLogger.isLoggable(Level.FINE)) {
                JaLogger.log(Level.FINE, JaLogger.Component.SSLENGINE, "[{0}] Illegal state for unlock: poppedState={1}, lockStack.peek()={2}.", new Object[]{this.getClass().getName(), lockState2, lockState});
            }
            throw new IllegalStateException("poppedState=" + (Object)((Object)lockState2) + ", lockStack.peek=" + (Object)((Object)lockState));
        }
        if (JaLogger.isLoggable(Level.FINEST)) {
            JaLogger.log(Level.FINEST, JaLogger.Component.SSLENGINE, "[{0}] unlock completed, current lock state \"{1}\", popped lock state \"{2}\", post-pop stack size={3}", new Object[]{this.getClass().getName(), lockState, lockState2, this.lockStateStack.get().size()});
        }
    }

    JaSSLEngineSynchronizer() {
        this.inboundLock = new ReentrantLock();
        this.outboundLock = new ReentrantLock();
    }

    JaSSLEngineSynchronizer(Lock lock, Lock lock2) {
        this.inboundLock = lock;
        this.outboundLock = lock2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum LockState {
        NONE,
        INBOUND,
        OUTBOUND,
        HANDSHAKE;

    }
}

