/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.SSL.jsseadapter;

import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import weblogic.security.SSL.jsseadapter.JaSSLEngine;
import weblogic.security.SSL.jsseadapter.JaSSLSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JaSSLParameters {
    private String[] enabledCipherSuites = new String[0];
    private String[] enabledProtocols = new String[0];
    private boolean needClientAuth = false;
    private boolean wantClientAuth = false;
    private boolean useClientMode = true;
    private boolean enableSessionCreation = true;
    private boolean unencryptedNullCipherEnabled = false;
    private Set<String> NULL_CIPHERS = new HashSet<String>();
    private Set<String> ANON_CIPHERS = new HashSet<String>();

    public JaSSLParameters(JaSSLParameters jaSSLParameters) {
        if (null == jaSSLParameters) {
            throw new IllegalArgumentException("Expected non-null SSLParameters.");
        }
        this.setEnabledCipherSuites(jaSSLParameters.enabledCipherSuites);
        this.setEnabledProtocols(jaSSLParameters.enabledProtocols);
        this.setWantClientAuth(jaSSLParameters.wantClientAuth);
        this.setNeedClientAuth(jaSSLParameters.needClientAuth);
        this.setUseClientMode(jaSSLParameters.useClientMode);
        this.setEnableSessionCreation(jaSSLParameters.enableSessionCreation);
    }

    public JaSSLParameters(SSLContext sSLContext) {
        if (null == sSLContext) {
            throw new IllegalArgumentException("Expected non-null javax.net.ssl.SSLContext.");
        }
        SSLEngine sSLEngine = sSLContext.createSSLEngine();
        this.setEnabledCipherSuites(sSLEngine.getEnabledCipherSuites());
        this.setEnabledProtocols(sSLEngine.getEnabledProtocols());
        this.setWantClientAuth(sSLEngine.getWantClientAuth());
        this.setNeedClientAuth(sSLEngine.getNeedClientAuth());
    }

    public String[] getEnabledCipherSuites() {
        return JaSSLParameters.cloneArray(this.enabledCipherSuites);
    }

    public void setEnabledCipherSuites(String[] stringArray) {
        this.enabledCipherSuites = JaSSLParameters.cloneArray(stringArray);
    }

    public String[] getEnabledProtocols() {
        return JaSSLParameters.cloneArray(this.enabledProtocols);
    }

    public void setEnabledProtocols(String[] stringArray) {
        this.enabledProtocols = JaSSLParameters.cloneArray(stringArray);
    }

    public void setNeedClientAuth(boolean bl) {
        this.needClientAuth = bl;
    }

    public boolean getNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setWantClientAuth(boolean bl) {
        this.wantClientAuth = bl;
    }

    public boolean getWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setUseClientMode(boolean bl) {
        this.useClientMode = bl;
    }

    public boolean getUseClientMode() {
        return this.useClientMode;
    }

    public void setEnableSessionCreation(boolean bl) {
        this.enableSessionCreation = bl;
    }

    public boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    public void configureSslEngine(SSLEngine sSLEngine) {
        String[] stringArray;
        if (null == sSLEngine) {
            throw new IllegalArgumentException("Expected non-null SSLEngine.");
        }
        String[] stringArray2 = stringArray = this.unencryptedNullCipherEnabled ? JaSSLSupport.combineCiphers(this.getEnabledCipherSuites(), this.getNullCiphers(sSLEngine)) : this.getEnabledCipherSuites();
        if (JaSSLSupport.isAnonymousCipherAllowed()) {
            stringArray = JaSSLSupport.combineCiphers(stringArray, this.getAnonymousCiphers(sSLEngine));
        }
        sSLEngine.setEnabledCipherSuites(stringArray);
        String[] stringArray3 = JaSSLSupport.getEnabledProtocols(sSLEngine.getSupportedProtocols());
        String[] stringArray4 = stringArray3 != null ? stringArray3 : this.getEnabledProtocols();
        sSLEngine.setEnabledProtocols(stringArray4);
        sSLEngine.setEnableSessionCreation(this.getEnableSessionCreation());
        sSLEngine.setUseClientMode(this.getUseClientMode());
        sSLEngine.setWantClientAuth(this.getWantClientAuth());
        sSLEngine.setNeedClientAuth(this.getNeedClientAuth());
    }

    private static String[] cloneArray(String[] stringArray) {
        if (null == stringArray) {
            return stringArray;
        }
        String[] stringArray2 = new String[stringArray.length];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        return stringArray2;
    }

    void setUnencryptedNullCipherEnabled(boolean bl) {
        this.unencryptedNullCipherEnabled = bl;
    }

    synchronized String[] getNullCiphers(SSLEngine sSLEngine) {
        if (sSLEngine != null && this.NULL_CIPHERS.size() == 0) {
            this.selectCiphers(sSLEngine, "_NULL_", this.NULL_CIPHERS);
        }
        String[] stringArray = new String[this.NULL_CIPHERS.size()];
        return this.NULL_CIPHERS.toArray(stringArray);
    }

    synchronized String[] getAnonymousCiphers(SSLEngine sSLEngine) {
        if (sSLEngine != null && this.ANON_CIPHERS.size() == 0) {
            this.selectCiphers(sSLEngine, "_anon_", this.ANON_CIPHERS);
        }
        String[] stringArray = new String[this.ANON_CIPHERS.size()];
        return this.ANON_CIPHERS.toArray(stringArray);
    }

    private void selectCiphers(SSLEngine sSLEngine, String string, Set<String> set) {
        String[] stringArray;
        if (sSLEngine instanceof JaSSLEngine) {
            sSLEngine = ((JaSSLEngine)sSLEngine).getDelegate();
        }
        for (String string2 : stringArray = sSLEngine.getSupportedCipherSuites()) {
            if (string2.toUpperCase().indexOf(string.toUpperCase()) <= -1) continue;
            set.add(string2);
        }
    }
}

