/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.SSL.jsseadapter;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.logging.Level;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocket;
import weblogic.security.SSL.jsseadapter.JaCipherSuiteNameMap;
import weblogic.security.SSL.jsseadapter.JaLogger;
import weblogic.security.SSL.jsseadapter.JaSSLContext;
import weblogic.security.SSL.jsseadapter.JaSSLParameters;
import weblogic.security.SSL.jsseadapter.JaSSLSocket;

final class JaSSLServerSocket
extends SSLServerSocket {
    private final JaSSLContext jaSSLContext;
    private final JaSSLParameters sslParameters;

    public String[] getEnabledCipherSuites() {
        return JaCipherSuiteNameMap.fromJsse(this.sslParameters.getEnabledCipherSuites());
    }

    public void setEnabledCipherSuites(String[] stringArray) {
        String[] stringArray2 = JaCipherSuiteNameMap.toJsse(stringArray);
        SSLContext sSLContext = this.jaSSLContext.getSSLContext();
        SSLEngine sSLEngine = sSLContext.createSSLEngine();
        sSLEngine.setEnabledCipherSuites(stringArray2);
        this.sslParameters.setEnabledCipherSuites(stringArray2);
    }

    public String[] getSupportedCipherSuites() {
        return this.jaSSLContext.getSupportedCipherSuites();
    }

    public String[] getSupportedProtocols() {
        return this.jaSSLContext.getSupportedProtocols();
    }

    public String[] getEnabledProtocols() {
        return this.sslParameters.getEnabledProtocols();
    }

    public void setEnabledProtocols(String[] stringArray) {
        SSLContext sSLContext = this.jaSSLContext.getSSLContext();
        SSLEngine sSLEngine = sSLContext.createSSLEngine();
        sSLEngine.setEnabledProtocols(stringArray);
        this.sslParameters.setEnabledProtocols(stringArray);
    }

    public void setNeedClientAuth(boolean bl) {
        this.sslParameters.setNeedClientAuth(bl);
    }

    public boolean getNeedClientAuth() {
        return this.sslParameters.getNeedClientAuth();
    }

    public void setWantClientAuth(boolean bl) {
        this.sslParameters.setWantClientAuth(bl);
    }

    public boolean getWantClientAuth() {
        return this.sslParameters.getWantClientAuth();
    }

    public void setUseClientMode(boolean bl) {
        this.sslParameters.setUseClientMode(bl);
    }

    public boolean getUseClientMode() {
        return this.sslParameters.getUseClientMode();
    }

    public void setEnableSessionCreation(boolean bl) {
        this.sslParameters.setEnableSessionCreation(bl);
    }

    public boolean getEnableSessionCreation() {
        return this.sslParameters.getEnableSessionCreation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Socket accept() throws IOException {
        JaSSLSocket jaSSLSocket = null;
        boolean bl = false;
        try {
            jaSSLSocket = new JaSSLSocket(this.jaSSLContext);
            this.implAccept(jaSSLSocket);
            jaSSLSocket.init(this.sslParameters);
            bl = true;
            if (JaLogger.isLoggable(Level.FINEST)) {
                JaLogger.log(Level.FINEST, JaLogger.Component.SSLSERVERSOCKET, "Accepted connection from client: {0}:{1}", jaSSLSocket.getInetAddress().getHostAddress(), jaSSLSocket.getPort());
            }
            if (null == jaSSLSocket || bl) return jaSSLSocket;
        }
        catch (Throwable throwable) {
            if (null == jaSSLSocket || bl) throw throwable;
            jaSSLSocket.close();
            if (!JaLogger.isLoggable(Level.FINE)) throw throwable;
            JaLogger.log(Level.FINE, JaLogger.Component.SSLSERVERSOCKET, "Closed socket due to failure during accept. Host={0}, Port={1}", jaSSLSocket.getInetAddress().getHostAddress(), jaSSLSocket.getPort());
            throw throwable;
        }
        jaSSLSocket.close();
        if (!JaLogger.isLoggable(Level.FINE)) return jaSSLSocket;
        JaLogger.log(Level.FINE, JaLogger.Component.SSLSERVERSOCKET, "Closed socket due to failure during accept. Host={0}, Port={1}", jaSSLSocket.getInetAddress().getHostAddress(), jaSSLSocket.getPort());
        return jaSSLSocket;
    }

    public void close() throws IOException {
        super.close();
    }

    public boolean isClosed() {
        return super.isClosed();
    }

    public String toString() {
        return super.toString();
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    JaSSLServerSocket(JaSSLContext jaSSLContext, int n, int n2, InetAddress inetAddress) throws IOException {
        super(n, n2, inetAddress);
        if (null == jaSSLContext) {
            throw new IllegalArgumentException("Expected non-null JaSSLContext.");
        }
        this.jaSSLContext = jaSSLContext;
        this.sslParameters = new JaSSLParameters(jaSSLContext.getSSLContext());
        this.sslParameters.setUseClientMode(false);
    }
}

