/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.SSL.jsseadapter;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import weblogic.security.SSL.jsseadapter.JaNioSSLServerSocket;
import weblogic.security.SSL.jsseadapter.JaSSLContext;
import weblogic.security.SSL.jsseadapter.JaSSLServerSocket;

final class JaSSLServerSocketFactory
extends SSLServerSocketFactory {
    private final JaSSLContext jaSSLContext;
    private final boolean nio;

    JaSSLServerSocketFactory(JaSSLContext jaSSLContext, boolean bl) {
        if (null == jaSSLContext) {
            throw new IllegalArgumentException("Expected non-null JaSSLContext instance.");
        }
        this.jaSSLContext = jaSSLContext;
        this.nio = bl;
    }

    boolean isNio() {
        return this.nio;
    }

    public ServerSocket createServerSocket() throws IOException {
        throw new UnsupportedOperationException("Unbound ServerSocket instances are not supported.");
    }

    public ServerSocket createServerSocket(int n) throws IOException {
        return this.createServerSocket(n, -1, null);
    }

    public ServerSocket createServerSocket(int n, int n2) throws IOException {
        return this.createServerSocket(n, n2, null);
    }

    public ServerSocket createServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        SSLServerSocket sSLServerSocket = this.isNio() ? new JaNioSSLServerSocket(this.jaSSLContext, n, n2, inetAddress) : new JaSSLServerSocket(this.jaSSLContext, n, n2, inetAddress);
        return sSLServerSocket;
    }

    public String[] getDefaultCipherSuites() {
        return this.jaSSLContext.getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        return this.jaSSLContext.getSupportedCipherSuites();
    }
}

