/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.SSL.jsseadapter;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import weblogic.management.provider.CommandLine;
import weblogic.security.SSL.SSLEnabledProtocolVersions;
import weblogic.security.SSL.SSLEnabledProtocolVersionsLogging;
import weblogic.security.SSL.jsseadapter.JaLogger;
import weblogic.security.SSL.jsseadapter.RSAPKFactory;
import weblogic.security.utils.SSLSetup;
import weblogic.utils.encoders.BASE64Decoder;

public final class JaSSLSupport {
    private static final String SSL3 = "SSLv3";
    private static final String TLS_ONLY = "TLS";
    private static final String ALL_KEY = "ALL";
    private static final String SSL3_TLS = "SSL3_TLS";
    private static final String[] SSL3_ONLY = new String[]{"SSLv3"};
    private static volatile Map<String, String[]> SUPPORTED_PROTOCOLS = null;
    private static final boolean disableNullCipher = Boolean.getBoolean("weblogic.security.disableNullCipher");
    private static boolean allowUnencryptedNullCipher = Boolean.getBoolean("weblogic.ssl.AllowUnencryptedNullCipher");
    private static boolean sendEmptyCAList = false;
    private static volatile boolean x509BasicConstraintsStrict = false;
    private static volatile boolean noV1CAs = false;
    private static boolean anonymousCipherAllowed = Boolean.getBoolean("weblogic.security.SSL.AllowAnonymousCipher");
    static final String CERT_BEGIN_HEADER = "-----BEGIN CERTIFICATE-----";
    static final String CERT_END_HEADER = "-----END CERTIFICATE-----";

    private static void initSupportedProtocols(String[] stringArray) {
        if (SUPPORTED_PROTOCOLS == null) {
            HashMap<String, String[]> hashMap = new HashMap<String, String[]>(4);
            hashMap.put(SSL3, SSL3_ONLY);
            String[] stringArray2 = JaSSLSupport.grabTLSProtocols(stringArray);
            String[] stringArray3 = new String[stringArray2.length + 1];
            System.arraycopy(SSL3_ONLY, 0, stringArray3, 0, SSL3_ONLY.length);
            System.arraycopy(stringArray2, 0, stringArray3, 1, stringArray2.length);
            hashMap.put(TLS_ONLY, stringArray2);
            hashMap.put(SSL3_TLS, stringArray3);
            hashMap.put(ALL_KEY, stringArray);
            SUPPORTED_PROTOCOLS = hashMap;
        }
    }

    static String[] getEnabledProtocols(String[] stringArray) {
        String string = CommandLine.getCommandLine().getSSLMinimumProtocolVersion();
        if (null != string) {
            SSLEnabledProtocolVersionsLogging sSLEnabledProtocolVersionsLogging = new SSLEnabledProtocolVersionsLogging();
            return SSLEnabledProtocolVersions.getJSSEProtocolVersions(string, stringArray, sSLEnabledProtocolVersionsLogging);
        }
        JaSSLSupport.initSupportedProtocols(stringArray);
        int n = SSLSetup.getProtocolVersion();
        String string2 = null;
        switch (n) {
            case 1: {
                string2 = SSL3;
                break;
            }
            case 0: {
                string2 = TLS_ONLY;
                break;
            }
            case 2: {
                string2 = SSL3_TLS;
                break;
            }
            case 3: {
                string2 = ALL_KEY;
            }
        }
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        if (string2 != null) {
            stringArray3 = SUPPORTED_PROTOCOLS.get(string2);
        }
        if (stringArray3 != null) {
            stringArray2 = new String[stringArray3.length];
            System.arraycopy(stringArray3, 0, stringArray2, 0, stringArray3.length);
        }
        return stringArray2;
    }

    public static String[] combineCiphers(String[] stringArray, String[] stringArray2) {
        int n = 0;
        if (stringArray != null) {
            n += stringArray.length;
        }
        if (stringArray2 != null) {
            n += stringArray2.length;
        }
        ArrayList<String> arrayList = new ArrayList<String>(n);
        if (stringArray != null && stringArray.length > 0) {
            for (String string : stringArray) {
                arrayList.add(string);
            }
        }
        if (stringArray2 != null && stringArray2.length > 0) {
            for (String string : stringArray2) {
                arrayList.add(string);
            }
        }
        String[] stringArray3 = new String[arrayList.size()];
        return arrayList.toArray(stringArray3);
    }

    public static synchronized boolean isUnEncrytedNullCipherAllowed() {
        if (disableNullCipher) {
            if (allowUnencryptedNullCipher) {
                throw new IllegalArgumentException("Can not start SSL due to conflicting configuration - System configure parameter of weblogic.security.disableNullCipher = true, and configure parameter weblogic.security.ssl.allowUnencryptedNullCipher = true");
            }
            return false;
        }
        return allowUnencryptedNullCipher;
    }

    static boolean isAnonymousCipherAllowed() {
        return anonymousCipherAllowed;
    }

    public static synchronized void setSendEmptyCAList(boolean bl) {
        sendEmptyCAList = bl;
    }

    public static synchronized boolean isSendEmptyCAListEnabled() {
        return sendEmptyCAList;
    }

    public static PrivateKey getLocalIdentityPrivateKey(InputStream inputStream, char[] cArray) throws KeyManagementException {
        return RSAPKFactory.getPrivateKey(inputStream, cArray);
    }

    static byte[] readFully(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte[] byArray = new byte[dataInputStream.available()];
        dataInputStream.readFully(byArray);
        return byArray;
    }

    static byte[] decodeData(String string) throws IOException {
        BASE64Decoder bASE64Decoder = new BASE64Decoder();
        return bASE64Decoder.decodeBuffer(string);
    }

    static void loadCerts(KeyStore keyStore, Certificate[] certificateArray) {
        for (Certificate certificate : certificateArray) {
            try {
                keyStore.setCertificateEntry(certificate.toString(), certificate);
            }
            catch (KeyStoreException keyStoreException) {
                if (!JaLogger.isLoggable(Level.SEVERE)) continue;
                JaLogger.log(Level.SEVERE, JaLogger.Component.TRUSTSTORE_MANAGER, keyStoreException, "Error loading CAs into trust KeyStore.", new Object[0]);
            }
        }
    }

    static void setX509BasicConstraintsStrict(boolean bl) {
        x509BasicConstraintsStrict = bl;
    }

    static boolean isX509BasicConstraintsStrict() {
        return x509BasicConstraintsStrict;
    }

    static void setNoV1CAs(boolean bl) {
        noV1CAs = bl;
    }

    static boolean isNoV1CAs() {
        return noV1CAs;
    }

    private static String[] grabTLSProtocols(String[] stringArray) {
        String[] stringArray2 = new String[]{};
        if (stringArray != null && stringArray.length > 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : stringArray) {
                if (!string.startsWith(TLS_ONLY)) continue;
                arrayList.add(string);
            }
            if (arrayList.size() > 0) {
                stringArray2 = arrayList.toArray(stringArray2);
            }
        }
        return stringArray2;
    }
}

