/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.SSL.jsseadapter;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import weblogic.kernel.Kernel;
import weblogic.security.SSL.jsseadapter.JaLogger;
import weblogic.security.SSL.jsseadapter.JaSSLSupport;
import weblogic.security.pki.revocation.common.RevocationCertPathChecker;
import weblogic.security.pki.revocation.wls.WlsCertRevocContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JaTrustManager
implements X509TrustManager {
    private final X509Certificate[] trustedCAs;
    private final Set<TrustAnchor> trustAnchors;
    private X509TrustManager xTm;
    private static final String ID_CE_BASIC_CONSTRAINTS = "2.5.29.19";
    private static final int CERT_X509_V1 = 1;
    private static final int CERT_X509_V3 = 3;

    JaTrustManager(X509Certificate[] x509CertificateArray) {
        TrustManager[] trustManagerArray;
        TrustManagerFactory trustManagerFactory;
        block8: {
            this.trustedCAs = this.copyCerts(x509CertificateArray);
            this.trustAnchors = Collections.unmodifiableSet(JaTrustManager.createTrustAnchors(x509CertificateArray));
            trustManagerFactory = null;
            try {
                trustManagerFactory = TrustManagerFactory.getInstance("PKIX");
                if (Kernel.isServer()) {
                    trustManagerArray = new X509CertSelector();
                    PKIXBuilderParameters pKIXBuilderParameters = new PKIXBuilderParameters(this.trustAnchors, (CertSelector)trustManagerArray);
                    pKIXBuilderParameters.setRevocationEnabled(false);
                    Set<X509Certificate> set = this.toUnmodifiableSet(this.trustedCAs);
                    WlsCertRevocContext wlsCertRevocContext = new WlsCertRevocContext(set);
                    RevocationCertPathChecker object = RevocationCertPathChecker.getInstance(wlsCertRevocContext);
                    pKIXBuilderParameters.addCertPathChecker(object);
                    CertPathTrustManagerParameters certPathTrustManagerParameters = new CertPathTrustManagerParameters(pKIXBuilderParameters);
                    trustManagerFactory.init(certPathTrustManagerParameters);
                } else {
                    trustManagerArray = KeyStore.getInstance(KeyStore.getDefaultType());
                    trustManagerArray.load(null, null);
                    JaTrustManager.loadCerts((KeyStore)trustManagerArray, this.trustedCAs);
                    trustManagerFactory.init((KeyStore)trustManagerArray);
                }
            }
            catch (Exception exception) {
                if (!JaLogger.isLoggable(Level.WARNING)) break block8;
                JaLogger.log(Level.WARNING, JaLogger.Component.TRUSTSTORE_MANAGER, exception, "Error initializing trust manager factory: {0}.", exception.getMessage());
            }
        }
        if (trustManagerFactory != null) {
            trustManagerArray = trustManagerFactory.getTrustManagers();
            for (TrustManager trustManager : trustManagerArray) {
                if (!(trustManager instanceof X509TrustManager)) continue;
                this.xTm = (X509TrustManager)trustManager;
                break;
            }
        }
        if (null == this.xTm) {
            if (JaLogger.isLoggable(Level.WARNING)) {
                JaLogger.log(Level.WARNING, JaLogger.Component.TRUSTSTORE_MANAGER, "Unable to determine TrustManager.", new Object[0]);
            }
            throw new IllegalStateException("Unable to determine TrustManager.");
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.xTm.checkClientTrusted(x509CertificateArray, string);
        this.checkCertPath(x509CertificateArray);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.xTm.checkServerTrusted(x509CertificateArray, string);
        this.checkCertPath(x509CertificateArray);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] x509CertificateArray = !Boolean.getBoolean("weblogic.security.SSL.sendEmptyCAList") ? this.copyCerts(this.trustedCAs) : new X509Certificate[]{};
        return x509CertificateArray;
    }

    void checkCertPath(X509Certificate[] x509CertificateArray) throws CertificateException {
        PKIXCertPathBuilderResult pKIXCertPathBuilderResult;
        if ((null == x509CertificateArray || x509CertificateArray.length <= 0) && JaLogger.isLoggable(Level.FINEST)) {
            JaLogger.log(Level.FINEST, JaLogger.Component.TRUSTSTORE_MANAGER, "Empty peer certificate chain.", new Object[0]);
        }
        if (this.hasCertPath(pKIXCertPathBuilderResult = this.buildPKIXCertPath(x509CertificateArray))) {
            if (JaSSLSupport.isNoV1CAs() && this.hasV1CAs(pKIXCertPathBuilderResult)) {
                if (JaLogger.isLoggable(Level.WARNING)) {
                    JaLogger.log(Level.WARNING, JaLogger.Component.TRUSTSTORE_MANAGER, "The certificate path has a version 1 CA certificate. Version 1 CA certificates are disallowed.", new Object[0]);
                }
                throw new CertificateException("The certificate path has a version 1 CA certificate. Version 1 CA certificates are disallowed.");
            }
            if (JaSSLSupport.isX509BasicConstraintsStrict() && !this.isBasicConstraintsExtensionMarkedCritical(pKIXCertPathBuilderResult)) {
                if (JaLogger.isLoggable(Level.WARNING)) {
                    JaLogger.log(Level.WARNING, JaLogger.Component.TRUSTSTORE_MANAGER, "The Basic Constraints extension of at least one of the version 3 CA certificates in the chain is not marked critical.  This is being rejected due to the strict enforcement of Basic Constraints.", new Object[0]);
                }
                throw new CertificateException("The Basic Constraints extension of at least one of the version 3 CA certificates in the chain is not marked critical.  This is being rejected due to the strict enforcement of Basic Constraints.");
            }
        } else if (JaLogger.isLoggable(Level.FINEST)) {
            JaLogger.log(Level.FINEST, JaLogger.Component.TRUSTSTORE_MANAGER, "Additional cert path checks encountered empty cert path.", new Object[0]);
        }
    }

    private static void loadCerts(KeyStore keyStore, Certificate[] certificateArray) {
        for (Certificate certificate : certificateArray) {
            try {
                if (null == certificate) {
                    if (!JaLogger.isLoggable(Level.FINEST)) continue;
                    JaLogger.log(Level.FINEST, JaLogger.Component.TRUSTSTORE_MANAGER, "Null trusted certificate encountered.", new Object[0]);
                    continue;
                }
                keyStore.setCertificateEntry(certificate.toString(), certificate);
            }
            catch (KeyStoreException keyStoreException) {
                if (!JaLogger.isLoggable(Level.WARNING)) continue;
                JaLogger.log(Level.WARNING, JaLogger.Component.TRUSTSTORE_MANAGER, keyStoreException, "Unable to add certificate to keystore: cert={0}, message={1}.", certificate.toString(), keyStoreException.getMessage());
            }
        }
    }

    boolean isBasicConstraintsExtensionMarkedCritical(PKIXCertPathBuilderResult pKIXCertPathBuilderResult) {
        Set<String> set;
        CertPath certPath = pKIXCertPathBuilderResult.getCertPath();
        boolean bl = true;
        for (Certificate certificate2 : certPath.getCertificates()) {
            if (bl) {
                bl = false;
                continue;
            }
            if (!(certificate2 instanceof X509Certificate)) {
                if (!JaLogger.isLoggable(Level.FINEST)) continue;
                JaLogger.log(Level.FINEST, JaLogger.Component.TRUSTSTORE_MANAGER, "Critical Basic Constraint Extensions check skipping non-X509Certificate instance: {0}", certificate2);
                continue;
            }
            set = (X509Certificate)certificate2;
            if (((X509Certificate)((Object)set)).getVersion() != 3) {
                if (!JaLogger.isLoggable(Level.FINER)) continue;
                JaLogger.log(Level.FINER, JaLogger.Component.TRUSTSTORE_MANAGER, "Checking for Critical Basic Constraint Extensions, skipping non-v3 cert: Version={0}, SubjectDN={1}.", ((X509Certificate)((Object)set)).getVersion(), ((Object)((X509Certificate)((Object)set)).getSubjectDN()).toString());
                continue;
            }
            Set<String> set2 = set.getCriticalExtensionOIDs();
            if (JaTrustManager.isElementFound(set2, ID_CE_BASIC_CONSTRAINTS)) continue;
            if (JaLogger.isLoggable(Level.FINE)) {
                JaLogger.log(Level.FINE, JaLogger.Component.TRUSTSTORE_MANAGER, "Found v3 cert without critical BasicConstraints extension: {0}", ((Object)((X509Certificate)((Object)set)).getSubjectDN()).toString());
            }
            return false;
        }
        TrustAnchor trustAnchor = pKIXCertPathBuilderResult.getTrustAnchor();
        X509Certificate x509Certificate = trustAnchor.getTrustedCert();
        if (x509Certificate.getVersion() != 3) {
            if (JaLogger.isLoggable(Level.FINER)) {
                JaLogger.log(Level.FINER, JaLogger.Component.TRUSTSTORE_MANAGER, "Checking for Critical Basic Constraint Extensions, skipping non-v3 anchor cert: Version={0}, SubjectDN={1}.", x509Certificate.getVersion(), ((Object)x509Certificate.getSubjectDN()).toString());
            }
            return true;
        }
        set = x509Certificate.getCriticalExtensionOIDs();
        if (!JaTrustManager.isElementFound(set, ID_CE_BASIC_CONSTRAINTS)) {
            if (JaLogger.isLoggable(Level.FINE)) {
                JaLogger.log(Level.FINE, JaLogger.Component.TRUSTSTORE_MANAGER, "Found v3 anchor cert without critical BasicConstraints extension: {0}", ((Object)x509Certificate.getSubjectDN()).toString());
            }
            return false;
        }
        return true;
    }

    boolean hasV1CAs(PKIXCertPathBuilderResult pKIXCertPathBuilderResult) {
        CertPath certPath = pKIXCertPathBuilderResult.getCertPath();
        boolean bl = true;
        for (Certificate certificate2 : certPath.getCertificates()) {
            if (bl) {
                bl = false;
                continue;
            }
            if (!(certificate2 instanceof X509Certificate)) {
                if (!JaLogger.isLoggable(Level.FINEST)) continue;
                JaLogger.log(Level.FINEST, JaLogger.Component.TRUSTSTORE_MANAGER, "V1 CA certificate check skipping non-X509Certificate instance: {0}", certificate2);
                continue;
            }
            X509Certificate x509Certificate = (X509Certificate)certificate2;
            if (x509Certificate.getVersion() != 1) continue;
            if (JaLogger.isLoggable(Level.FINE)) {
                JaLogger.log(Level.FINE, JaLogger.Component.TRUSTSTORE_MANAGER, "Found version 1 certificate: {0}", ((Object)x509Certificate.getSubjectDN()).toString());
            }
            return true;
        }
        TrustAnchor trustAnchor = pKIXCertPathBuilderResult.getTrustAnchor();
        X509Certificate x509Certificate = trustAnchor.getTrustedCert();
        if (x509Certificate.getVersion() == 1) {
            if (JaLogger.isLoggable(Level.FINE)) {
                JaLogger.log(Level.FINE, JaLogger.Component.TRUSTSTORE_MANAGER, "Found version 1 anchor certificate: {0}", ((Object)x509Certificate.getSubjectDN()).toString());
            }
            return true;
        }
        return false;
    }

    public static boolean isElementFound(Set<String> set, String string) {
        if (set != null && string != null && set.size() > 0) {
            for (String string2 : set) {
                if (!string.equalsIgnoreCase(string2)) continue;
                return true;
            }
        }
        return false;
    }

    static Set<TrustAnchor> createTrustAnchors(X509Certificate[] x509CertificateArray) {
        HashSet<TrustAnchor> hashSet = new HashSet<TrustAnchor>();
        if (null == x509CertificateArray || x509CertificateArray.length <= 0) {
            if (JaLogger.isLoggable(Level.WARNING)) {
                JaLogger.log(Level.WARNING, JaLogger.Component.TRUSTSTORE_MANAGER, "No trusted CAs available to populate trust anchors.", new Object[0]);
            }
            return hashSet;
        }
        for (X509Certificate x509Certificate : x509CertificateArray) {
            if (null == x509Certificate) {
                if (!JaLogger.isLoggable(Level.FINEST)) continue;
                JaLogger.log(Level.FINEST, JaLogger.Component.TRUSTSTORE_MANAGER, "Null certificate encountered while populating trust anchors.", new Object[0]);
                continue;
            }
            hashSet.add(new TrustAnchor(x509Certificate, null));
        }
        return hashSet;
    }

    PKIXCertPathBuilderResult buildPKIXCertPath(X509Certificate[] x509CertificateArray) throws CertificateException {
        PKIXCertPathBuilderResult pKIXCertPathBuilderResult;
        try {
            X509CertSelector x509CertSelector = new X509CertSelector();
            x509CertSelector.setSubject(x509CertificateArray[0].getSubjectX500Principal());
            PKIXBuilderParameters pKIXBuilderParameters = new PKIXBuilderParameters(this.trustAnchors, (CertSelector)x509CertSelector);
            pKIXBuilderParameters.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(Arrays.asList(x509CertificateArray))));
            pKIXBuilderParameters.setRevocationEnabled(false);
            CertPathBuilder certPathBuilder = CertPathBuilder.getInstance("PKIX");
            pKIXCertPathBuilderResult = (PKIXCertPathBuilderResult)certPathBuilder.build(pKIXBuilderParameters);
        }
        catch (Exception exception) {
            if (JaLogger.isLoggable(Level.WARNING)) {
                JaLogger.log(Level.WARNING, JaLogger.Component.TRUSTSTORE_MANAGER, exception, "Error using PKIX CertPathBuilder.", new Object[0]);
            }
            throw new IllegalStateException("Error using PKIX CertPathBuilder.", exception);
        }
        return pKIXCertPathBuilderResult;
    }

    boolean hasCertPath(PKIXCertPathBuilderResult pKIXCertPathBuilderResult) {
        if (null == pKIXCertPathBuilderResult) {
            throw new IllegalArgumentException("Expected non-null PKIXCertPathBuilderResult.");
        }
        if (pKIXCertPathBuilderResult.getCertPath() != null && pKIXCertPathBuilderResult.getCertPath().getCertificates() != null && pKIXCertPathBuilderResult.getCertPath().getCertificates().size() > 0) {
            return true;
        }
        return pKIXCertPathBuilderResult.getTrustAnchor() != null && pKIXCertPathBuilderResult.getTrustAnchor().getTrustedCert() != null;
    }

    X509Certificate[] copyCerts(X509Certificate[] x509CertificateArray) {
        if (null == x509CertificateArray || x509CertificateArray.length <= 0) {
            if (JaLogger.isLoggable(Level.FINEST)) {
                JaLogger.log(Level.FINEST, JaLogger.Component.TRUSTSTORE_MANAGER, "No certs to copy.", new Object[0]);
            }
            return new X509Certificate[0];
        }
        X509Certificate[] x509CertificateArray2 = new X509Certificate[x509CertificateArray.length];
        System.arraycopy(x509CertificateArray, 0, x509CertificateArray2, 0, x509CertificateArray.length);
        return x509CertificateArray2;
    }

    private Set<X509Certificate> toUnmodifiableSet(X509Certificate[] x509CertificateArray) {
        if (null == x509CertificateArray) {
            x509CertificateArray = new X509Certificate[]{};
        }
        return Collections.unmodifiableSet(new HashSet<X509Certificate>(Arrays.asList(x509CertificateArray)));
    }
}

