/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.SSL.jsseadapter;

import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_SymmetricCipher;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyManagementException;
import java.security.PrivateKey;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import weblogic.security.SSL.jsseadapter.ASN1Object;
import weblogic.security.SSL.jsseadapter.DERDecoder;
import weblogic.security.SSL.jsseadapter.JSAFE_PrivateKeyWrapper;
import weblogic.security.SSL.jsseadapter.JaLogger;
import weblogic.security.SSL.jsseadapter.JaSSLSupport;

public class RSAPKFactory {
    private static final Hashtable<String, String> SUPPORTED_PK_TYPES = new Hashtable();
    private static final String ENC_PKCS8_RSA_PK_BEGIN_HEADER = "-----BEGIN ENCRYPTED PRIVATE KEY-----";
    private static final String ENC_PKCS8_RSA_PK_END_HEADER = "-----END ENCRYPTED PRIVATE KEY-----";
    private static final String UNENC_PKCS1_RSA_PK_BEGIN_HEADER = "-----BEGIN RSA PRIVATE KEY-----";
    private static final String UNENC_PKCS1_RSA_PK_END_HEADER = "-----END RSA PRIVATE KEY-----";
    private static final String UNENC_PKCS8_RSA_PK_BEGIN_HEADER = "-----BEGIN PRIVATE KEY-----";
    private static final String UNENC_PKCS8_RSA_PK_END_HEADER = "-----END PRIVATE KEY-----";

    static PrivateKey getPrivateKey(InputStream inputStream, char[] cArray) throws KeyManagementException {
        PrivateKey privateKey;
        String string;
        byte[] byArray;
        block14: {
            byArray = null;
            string = null;
            privateKey = null;
            if (JaLogger.isLoggable(Level.FINEST)) {
                JaLogger.log(Level.FINEST, JaLogger.Component.SSLCONTEXT, "Private key input stream: {0}", inputStream);
            }
            try {
                string = new String(JaSSLSupport.readFully(inputStream));
            }
            catch (IOException iOException) {
                if (!JaLogger.isLoggable(Level.SEVERE)) break block14;
                JaLogger.log(Level.SEVERE, JaLogger.Component.SSLCONTEXT, "Failed to read key material from the input stream: " + iOException.getMessage(), new Object[0]);
            }
        }
        String string2 = null;
        if (string != null && string.length() > 0) {
            Iterator<Map.Entry<String, String>> iterator = SUPPORTED_PK_TYPES.entrySet().iterator();
            try {
                Object object;
                Map.Entry<String, String> entry;
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    object = Pattern.compile(entry.getValue(), 32).matcher(string);
                    if (!((Matcher)object).find()) continue;
                    byArray = JaSSLSupport.decodeData(((Matcher)object).group(1));
                    string2 = (String)entry.getKey();
                    break;
                }
                if (byArray != null) {
                    entry = null;
                    entry = KeyFactory.getInstance("RSA");
                    if (UNENC_PKCS1_RSA_PK_BEGIN_HEADER.equalsIgnoreCase(string2)) {
                        object = RSAPKFactory.getRSAKeySpec(byArray);
                        privateKey = ((KeyFactory)((Object)entry)).generatePrivate((KeySpec)object);
                    } else if (UNENC_PKCS8_RSA_PK_BEGIN_HEADER.equalsIgnoreCase(string2)) {
                        object = new PKCS8EncodedKeySpec(byArray);
                        privateKey = ((KeyFactory)((Object)entry)).generatePrivate((KeySpec)object);
                    } else if (ENC_PKCS8_RSA_PK_BEGIN_HEADER.equalsIgnoreCase(string2)) {
                        privateKey = RSAPKFactory.getEncryptedPKCS8PrivateKey(byArray, cArray);
                    }
                }
            }
            catch (Exception exception) {
                if (JaLogger.isLoggable(Level.SEVERE)) {
                    JaLogger.log(Level.SEVERE, JaLogger.Component.SSLCONTEXT, "Failed to create the private key: " + exception.getMessage(), new Object[0]);
                }
                throw new KeyManagementException(exception);
            }
        }
        return privateKey;
    }

    private static RSAPrivateCrtKeySpec getRSAKeySpec(byte[] byArray) throws IOException {
        DERDecoder dERDecoder = new DERDecoder(byArray);
        ASN1Object aSN1Object = dERDecoder.readObject();
        if (aSN1Object.getType() != 16) {
            throw new IOException("Unexpected type; not a sequence");
        }
        dERDecoder = aSN1Object.getDecoder();
        dERDecoder.readObject();
        BigInteger bigInteger = dERDecoder.readObject().getBigInteger();
        BigInteger bigInteger2 = dERDecoder.readObject().getBigInteger();
        BigInteger bigInteger3 = dERDecoder.readObject().getBigInteger();
        BigInteger bigInteger4 = dERDecoder.readObject().getBigInteger();
        BigInteger bigInteger5 = dERDecoder.readObject().getBigInteger();
        BigInteger bigInteger6 = dERDecoder.readObject().getBigInteger();
        BigInteger bigInteger7 = dERDecoder.readObject().getBigInteger();
        BigInteger bigInteger8 = dERDecoder.readObject().getBigInteger();
        RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = new RSAPrivateCrtKeySpec(bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8);
        return rSAPrivateCrtKeySpec;
    }

    private static PrivateKey getEncryptedPKCS8PrivateKey(byte[] byArray, char[] cArray) throws Exception {
        JSAFE_SymmetricCipher jSAFE_SymmetricCipher = JSAFE_SymmetricCipher.getInstance((byte[])byArray, (int)0, (String)"Java");
        JSAFE_SecretKey jSAFE_SecretKey = jSAFE_SymmetricCipher.getBlankKey();
        jSAFE_SecretKey.setPassword(cArray, 0, cArray.length);
        jSAFE_SymmetricCipher.decryptInit(jSAFE_SecretKey, null);
        JSAFE_PrivateKey jSAFE_PrivateKey = jSAFE_SymmetricCipher.unwrapPrivateKey(byArray, 0, byArray.length, true);
        return new JSAFE_PrivateKeyWrapper(jSAFE_PrivateKey);
    }

    static {
        SUPPORTED_PK_TYPES.put(ENC_PKCS8_RSA_PK_BEGIN_HEADER, "-----BEGIN ENCRYPTED PRIVATE KEY-----(.+?)-----END ENCRYPTED PRIVATE KEY-----");
        SUPPORTED_PK_TYPES.put(UNENC_PKCS1_RSA_PK_BEGIN_HEADER, "-----BEGIN RSA PRIVATE KEY-----(.+?)-----END RSA PRIVATE KEY-----");
        SUPPORTED_PK_TYPES.put(UNENC_PKCS8_RSA_PK_BEGIN_HEADER, "-----BEGIN PRIVATE KEY-----(.+?)-----END PRIVATE KEY-----");
    }
}

